/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.containers;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.sisu.BeanScanning;
import org.eclipse.sisu.binders.ParameterKeys;
import org.eclipse.sisu.binders.SpaceModule;
import org.eclipse.sisu.binders.WireModule;
import org.eclipse.sisu.containers.Main;
import org.eclipse.sisu.containers.SisuGuice;
import org.eclipse.sisu.locators.DefaultBeanLocator;
import org.eclipse.sisu.locators.MutableBeanLocator;
import org.eclipse.sisu.reflect.BundleClassSpace;
import org.eclipse.sisu.reflect.Logs;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class SisuActivator
implements BundleActivator,
BundleTrackerCustomizer,
ServiceTrackerCustomizer {
    static final String CONTAINER_SYMBOLIC_NAME = "org.eclipse.sisu.inject";
    static final String BUNDLE_INJECTOR_CLASS_NAME = BundleInjector.class.getName();
    static final MutableBeanLocator locator = new DefaultBeanLocator();
    private BundleContext bundleContext;
    private ServiceTracker serviceTracker;
    private BundleTracker bundleTracker;

    public void start(BundleContext context) {
        this.bundleContext = context;
        this.serviceTracker = new ServiceTracker(context, BUNDLE_INJECTOR_CLASS_NAME, (ServiceTrackerCustomizer)this);
        this.serviceTracker.open();
        this.bundleTracker = new BundleTracker(context, 40, (BundleTrackerCustomizer)this);
        this.bundleTracker.open();
    }

    public void stop(BundleContext context) {
        this.bundleTracker.close();
        this.serviceTracker.close();
        locator.clear();
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        if (CONTAINER_SYMBOLIC_NAME.equals(bundle.getSymbolicName())) {
            return null;
        }
        if (SisuActivator.needsScanning(bundle) && SisuActivator.getBundleInjectorService(bundle) == null) {
            try {
                new BundleInjector(bundle);
            }
            catch (RuntimeException e) {
                Logs.warn("Problem starting: {}", bundle, e);
            }
        }
        return null;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
    }

    public Object addingService(ServiceReference reference) {
        Object service = this.bundleContext.getService(reference);
        locator.add(((BundleInjector)service).getInjector(), 0);
        return service;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        locator.remove(((BundleInjector)service).getInjector());
    }

    private static boolean needsScanning(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        String host = (String)headers.get("Fragment-Host");
        if (host != null) {
            return false;
        }
        String imports = (String)headers.get("Import-Package");
        if (imports == null) {
            return false;
        }
        return imports.contains("javax.inject") || imports.contains("com.google.inject");
    }

    private static ServiceReference getBundleInjectorService(Bundle bundle) {
        ServiceReference[] serviceReferences = bundle.getRegisteredServices();
        if (serviceReferences != null) {
            ServiceReference[] serviceReferenceArray = serviceReferences;
            int n = serviceReferences.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference ref = serviceReferenceArray[n2];
                String[] stringArray = (String[])ref.getProperty("objectClass");
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String name = stringArray[n4];
                    if (BUNDLE_INJECTOR_CLASS_NAME.equals(name)) {
                        return ref;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    private static final class BundleInjector
    implements Module {
        private static final String[] API = new String[]{BUNDLE_INJECTOR_CLASS_NAME};
        private final Map<?, ?> properties;
        private final Injector injector;
        private final BundleContext extendedBundleContext;

        BundleInjector(Bundle bundle) {
            this.extendedBundleContext = bundle.getBundleContext();
            this.properties = new BundleProperties(this.extendedBundleContext);
            BundleClassSpace space = new BundleClassSpace(bundle);
            BeanScanning scanning = Main.selectScanning(this.properties);
            this.injector = Guice.createInjector((Module[])new Module[]{new WireModule(this, new SpaceModule(space, scanning))});
            Hashtable<String, String> metadata = new Hashtable<String, String>();
            ((Dictionary)metadata).put("service.pid", SisuActivator.CONTAINER_SYMBOLIC_NAME);
            this.extendedBundleContext.registerService(API, (Object)this, metadata);
        }

        public void configure(Binder binder) {
            binder.requestStaticInjection(new Class[]{SisuGuice.class});
            binder.bind(ParameterKeys.PROPERTIES).toInstance(this.properties);
            binder.bind(MutableBeanLocator.class).toInstance((Object)locator);
            binder.bind(BundleContext.class).toInstance((Object)this.extendedBundleContext);
        }

        public Injector getInjector() {
            return this.injector;
        }
    }

    private static final class BundleProperties
    extends AbstractMap<Object, Object> {
        private final transient BundleContext context;

        BundleProperties(BundleContext context) {
            this.context = context;
        }

        @Override
        public Object get(Object key) {
            return this.context.getProperty(String.valueOf(key));
        }

        @Override
        public boolean containsKey(Object key) {
            return this.get(key) != null;
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        public int size() {
            return 0;
        }
    }
}

