/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.binders;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.enterprise.inject.Typed;
import javax.inject.Provider;
import org.eclipse.sisu.EagerSingleton;
import org.eclipse.sisu.Mediator;
import org.eclipse.sisu.binders.BeanListener;
import org.eclipse.sisu.locators.WildcardKey;
import org.eclipse.sisu.reflect.TypeParameters;
import org.eclipse.sisu.scanners.QualifiedTypeListener;

public final class QualifiedTypeBinder
implements QualifiedTypeListener {
    private static final TypeLiteral<?> OBJECT_TYPE_LITERAL = TypeLiteral.get(Object.class);
    private final Binder rootBinder;
    private BeanListener beanListener;
    private Object currentSource;
    private Binder binder;

    public QualifiedTypeBinder(Binder binder) {
        this.rootBinder = binder;
        this.binder = binder;
    }

    public void hear(Annotation qualifier, Class qualifiedType, Object source) {
        if (this.currentSource != source) {
            if (source != null) {
                this.binder = this.rootBinder.withSource(source);
                this.currentSource = source;
            } else {
                this.binder = this.rootBinder;
                this.currentSource = null;
            }
        }
        if (!TypeParameters.isConcrete(qualifiedType)) {
            return;
        }
        if (Module.class.isAssignableFrom(qualifiedType)) {
            this.installModule(qualifiedType);
        } else if (Mediator.class.isAssignableFrom(qualifiedType)) {
            this.registerMediator(qualifiedType);
        } else if (Provider.class.isAssignableFrom(qualifiedType)) {
            this.bindProviderType(qualifiedType);
        } else {
            this.bindQualifiedType(qualifiedType);
        }
    }

    private void installModule(Class<Module> moduleType) {
        Module module = this.newInstance(moduleType);
        if (module != null) {
            this.binder.install(module);
        }
    }

    private void registerMediator(Class<Mediator> mediatorType) {
        TypeLiteral<?>[] params = QualifiedTypeBinder.getSuperTypeParameters(mediatorType, Mediator.class);
        if (params.length != 3) {
            this.binder.addError(mediatorType + " has wrong number of type arguments", new Object[0]);
        } else {
            Mediator mediator = this.newInstance(mediatorType);
            if (mediator != null) {
                this.mediate(Key.get(params[1], (Class)params[0].getRawType()), mediator, params[2].getRawType());
            }
        }
    }

    private void mediate(Key key, Mediator mediator, Class watcherType) {
        if (this.beanListener == null) {
            this.beanListener = new BeanListener();
            this.binder.bindListener(Matchers.any(), (TypeListener)this.beanListener);
            this.binder.requestInjection((Object)this.beanListener);
        }
        this.beanListener.mediate(key, mediator, watcherType);
    }

    private void bindProviderType(Class<?> providerType) {
        TypeLiteral<?>[] params = QualifiedTypeBinder.getSuperTypeParameters(providerType, Provider.class);
        if (params.length != 1) {
            this.binder.addError(providerType + " has wrong number of type arguments", new Object[0]);
        } else {
            Key<?> key = QualifiedTypeBinder.getBindingKey(params[0], (Annotation)QualifiedTypeBinder.getBindingName(providerType));
            ScopedBindingBuilder sbb = this.binder.bind(key).toProvider(providerType);
            if (providerType.isAnnotationPresent(EagerSingleton.class)) {
                sbb.asEagerSingleton();
            } else if (providerType.isAnnotationPresent(javax.inject.Singleton.class) || providerType.isAnnotationPresent(Singleton.class)) {
                sbb.in(Scopes.SINGLETON);
            }
            Class<?>[] types = QualifiedTypeBinder.getBindingTypes(providerType);
            if (types != null) {
                Class<?>[] classArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> bindingType = classArray[n2];
                    this.binder.bind(key.ofType(bindingType)).to(key);
                    ++n2;
                }
            }
        }
    }

    private void bindQualifiedType(Class<?> qualifiedType) {
        AnnotatedBindingBuilder sbb = this.binder.bind(qualifiedType);
        if (qualifiedType.isAnnotationPresent(EagerSingleton.class)) {
            sbb.asEagerSingleton();
        }
        Named bindingName = QualifiedTypeBinder.getBindingName(qualifiedType);
        Class<?>[] types = QualifiedTypeBinder.getBindingTypes(qualifiedType);
        if (types != null) {
            Key<?> key = QualifiedTypeBinder.getBindingKey(OBJECT_TYPE_LITERAL, (Annotation)bindingName);
            Class<?>[] classArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> bindingType = classArray[n2];
                this.binder.bind(key.ofType(bindingType)).to(qualifiedType);
                ++n2;
            }
        } else {
            this.binder.bind((Key)new WildcardKey(qualifiedType, (Annotation)bindingName)).to(qualifiedType);
        }
    }

    private <T> T newInstance(Class<T> type) {
        try {
            Constructor<T> ctor = type.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            return ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
            this.binder.addError("Error creating instance of: " + type + " reason: " + cause, new Object[0]);
            return null;
        }
        catch (LinkageError e) {
            this.binder.addError("Error creating instance of: " + type + " reason: " + e, new Object[0]);
            return null;
        }
    }

    private static TypeLiteral<?>[] getSuperTypeParameters(Class<?> type, Class<?> superType) {
        return TypeParameters.get(TypeLiteral.get(type).getSupertype(superType));
    }

    private static <T> Key<T> getBindingKey(TypeLiteral<T> bindingType, Annotation qualifier) {
        return qualifier != null ? Key.get(bindingType, (Annotation)qualifier) : Key.get(bindingType);
    }

    private static Named getBindingName(Class<?> qualifiedType) {
        javax.inject.Named jsr330 = qualifiedType.getAnnotation(javax.inject.Named.class);
        if (jsr330 != null) {
            try {
                String name = jsr330.value();
                if (name.length() > 0) {
                    return "default".equals(name) ? null : Names.named((String)name);
                }
            }
            catch (IncompleteAnnotationException incompleteAnnotationException) {}
        } else {
            String name;
            Named guice = qualifiedType.getAnnotation(Named.class);
            if (guice != null && (name = guice.value()).length() > 0) {
                return "default".equals(name) ? null : guice;
            }
        }
        if (qualifiedType.getSimpleName().startsWith("Default")) {
            return null;
        }
        return Names.named((String)qualifiedType.getName());
    }

    private static Class<?>[] getBindingTypes(Class<?> clazz) {
        Class<?> c = clazz;
        while (c != Object.class) {
            Typed typed = c.getAnnotation(Typed.class);
            if (typed != null) {
                return typed.value().length > 0 ? typed.value() : c.getInterfaces();
            }
            c = c.getSuperclass();
        }
        return null;
    }
}

