/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.res.loader;

import java.util.regex.Matcher;
import org.eclipse.scout.rt.client.services.common.icon.IconLocator;
import org.eclipse.scout.rt.client.services.common.icon.IconSpec;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.resource.BinaryResources;
import org.eclipse.scout.rt.ui.html.res.loader.AbstractResourceLoader;
import org.eclipse.scout.rt.ui.html.res.loader.ResourceLoaders;

public class IconLoader
extends AbstractResourceLoader {
    @Override
    public BinaryResource loadResource(String pathInfo) {
        Matcher matcher = ResourceLoaders.ICON_PATTERN.matcher(pathInfo);
        if (!matcher.find()) {
            return null;
        }
        String imageId = matcher.group(1);
        IconSpec iconSpec = IconLocator.instance().getIconSpec(imageId);
        if (iconSpec == null) {
            return null;
        }
        return BinaryResources.create().withFilename(iconSpec.getName()).withContent(iconSpec.getContent()).withLastModified(System.currentTimeMillis()).withCachingAllowed(true).withCacheMaxAge(14400).build();
    }
}

