/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.res.loader;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.nls.NlsLocale;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.resource.BinaryResources;
import org.eclipse.scout.rt.platform.util.IOUtility;
import org.eclipse.scout.rt.server.commons.servlet.HttpClientInfo;
import org.eclipse.scout.rt.server.commons.servlet.cache.HttpCacheKey;
import org.eclipse.scout.rt.server.commons.servlet.cache.HttpCacheObject;
import org.eclipse.scout.rt.server.commons.servlet.cache.HttpResponseHeaderContributor;
import org.eclipse.scout.rt.server.commons.servlet.cache.IHttpResponseInterceptor;
import org.eclipse.scout.rt.shared.SharedConfigProperties;
import org.eclipse.scout.rt.shared.ui.IUiEngineType;
import org.eclipse.scout.rt.shared.ui.UiEngineType;
import org.eclipse.scout.rt.shared.ui.UserAgentUtility;
import org.eclipse.scout.rt.shared.ui.webresource.WebResourceDescriptor;
import org.eclipse.scout.rt.shared.ui.webresource.WebResources;
import org.eclipse.scout.rt.ui.html.res.loader.AbstractResourceLoader;
import org.eclipse.scout.rt.ui.html.res.loader.HtmlDocumentParser;
import org.eclipse.scout.rt.ui.html.res.loader.HtmlDocumentParserParameters;

public class HtmlFileLoader
extends AbstractResourceLoader {
    private static final String THEME_KEY = "ui.theme";
    private static final String LOCALE_KEY = "ui.locale";
    private static final String MINIFY_KEY = "ui.minify";
    private static final String BROWSER_SUPPORTED_KEY = "ui.browserSupported";
    private final String m_theme;
    private final boolean m_minify;
    private final boolean m_cacheEnabled;

    public HtmlFileLoader(String theme, boolean minify, boolean cacheEnabled) {
        this.m_theme = theme;
        this.m_minify = minify;
        this.m_cacheEnabled = cacheEnabled;
    }

    @Override
    public HttpCacheKey createCacheKey(String pathInfo) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        Locale locale = NlsLocale.getOrElse(null);
        if (locale != null) {
            attrs.put(LOCALE_KEY, locale.toString());
        }
        attrs.put(THEME_KEY, this.m_theme);
        attrs.put(MINIFY_KEY, Boolean.toString(this.m_minify));
        if (!this.isBrowserSupported()) {
            attrs.put(BROWSER_SUPPORTED_KEY, Boolean.FALSE.toString());
        }
        return new HttpCacheKey(pathInfo, attrs);
    }

    @Override
    public HttpCacheObject loadResource(HttpCacheKey cacheKey) throws IOException {
        String pathInfo = cacheKey.getResourcePath();
        BinaryResource content = this.loadResource(pathInfo);
        if (content == null) {
            return null;
        }
        HttpCacheObject httpCacheObject = new HttpCacheObject(cacheKey, content);
        httpCacheObject.addHttpResponseInterceptor((IHttpResponseInterceptor)new HttpResponseHeaderContributor("X-UA-Compatible", "IE=edge"){
            private static final long serialVersionUID = 1L;

            public void intercept(HttpServletRequest req, HttpServletResponse resp) {
                HttpClientInfo httpClientInfo = HttpClientInfo.get((HttpServletRequest)req);
                if (httpClientInfo.isMshtml()) {
                    super.intercept(req, resp);
                }
            }
        });
        return httpCacheObject;
    }

    @Override
    public BinaryResource loadResource(String pathInfo) throws IOException {
        URL url = WebResources.resolveWebResource((String)pathInfo, (boolean)this.m_minify, (boolean)this.m_cacheEnabled).map(WebResourceDescriptor::getUrl).orElse(null);
        if (url == null) {
            return null;
        }
        HtmlDocumentParserParameters params = this.createHtmlDocumentParserParameters(pathInfo);
        HtmlDocumentParser parser = this.createHtmlDocumentParser(params);
        byte[] parsedDocument = parser.parseDocument(IOUtility.readFromUrl((URL)url));
        return BinaryResources.create().withFilename(pathInfo).withCharset(StandardCharsets.UTF_8).withContent(parsedDocument).withLastModifiedNow().withCachingAllowed(true).build();
    }

    public boolean isBrowserSupported() {
        IUiEngineType uiEngineType = UserAgentUtility.getCurrentUserAgent().getUiEngineType();
        return !UiEngineType.IE.equals((Object)uiEngineType) && !UiEngineType.EDGE.equals((Object)uiEngineType);
    }

    public HtmlDocumentParserParameters createHtmlDocumentParserParameters(String htmlPath) {
        return new HtmlDocumentParserParameters(htmlPath, this.m_theme, this.m_minify, this.m_cacheEnabled, (String)CONFIG.getPropertyValue(SharedConfigProperties.ExternalBaseUrlProperty.class), this.isBrowserSupported());
    }

    protected HtmlDocumentParser createHtmlDocumentParser(HtmlDocumentParserParameters params) {
        return new HtmlDocumentParser(params);
    }
}

