/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.res.loader;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.config.PlatformConfigProperties;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.util.IOUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.server.commons.servlet.cache.GlobalHttpResourceCache;
import org.eclipse.scout.rt.server.commons.servlet.cache.IHttpResourceCache;
import org.eclipse.scout.rt.shared.ui.webresource.ScriptResourceIndexes;
import org.eclipse.scout.rt.shared.ui.webresource.WebResourceDescriptor;
import org.eclipse.scout.rt.shared.ui.webresource.WebResources;
import org.eclipse.scout.rt.ui.html.UiThemeHelper;
import org.eclipse.scout.rt.ui.html.res.loader.HtmlDocumentParserParameters;
import org.eclipse.scout.rt.ui.html.res.loader.WebResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlDocumentParser {
    private static final Logger LOG = LoggerFactory.getLogger(HtmlDocumentParser.class);
    protected static final String ENTRY_POINT_VALUE_REGEX = "[^\"~]*";
    protected static final Pattern PATTERN_INCLUDE_TAG = Pattern.compile("<scout:include\\s+template=\"([^\"]*)\"\\s*/?>", 34);
    protected static final Pattern PATTERN_MESSAGE_TAG = Pattern.compile("<scout:message(.*?)\\s*/?>", 34);
    protected static final Pattern PATTERN_STYLESHEET_TAG = Pattern.compile("<scout:stylesheet\\s+src=\"([^\"]*)\"\\s*/?>", 34);
    protected static final Pattern PATTERN_SCRIPT_TAG = Pattern.compile("<scout:script\\s+src=\"([^\"]*)\"\\s*/?>", 34);
    protected static final Pattern PATTERN_SCRIPTS_TAG = Pattern.compile("<scout:scripts\\s+entrypoint=\"([^\"~]*)\"\\s*/?>", 34);
    protected static final Pattern PATTERN_STYLESHEETS_TAG = Pattern.compile("<scout:stylesheets\\s+entrypoint=\"([^\"~]*)\"\\s*/?>", 34);
    protected static final Pattern PATTERN_BASE_TAG = Pattern.compile("<scout:base\\s*/?>", 34);
    protected static final Pattern PATTERN_VERSION_TAG = Pattern.compile("<scout:version\\s*/?>", 34);
    protected static final Pattern PATTERN_UNKNOWN_TAG = Pattern.compile("<scout:(\"[^\"]*\"|[^>]*?)*>", 34);
    protected static final Pattern PATTERN_KEY_VALUE = Pattern.compile("([^\\s]+)=\"([^\"]*)\"");
    public static final String SCRIPT_TAG_PREFIX = "<script src=\"";
    public static final String SCRIPT_TAG_SUFFIX = "\"></script>";
    public static final String STYLESHEET_TAG_PREFIX = "<link rel=\"stylesheet\" type=\"text/css\" href=\"";
    public static final String STYLESHEET_TAG_SUFFIX = "\">";
    protected final HtmlDocumentParserParameters m_params;
    protected final IHttpResourceCache m_cache;
    protected String m_workingContent;

    public HtmlDocumentParser(HtmlDocumentParserParameters params) {
        this.m_params = params;
        this.m_cache = (IHttpResourceCache)BEANS.get(GlobalHttpResourceCache.class);
    }

    public byte[] parseDocument(byte[] document) {
        this.m_workingContent = new String(document, StandardCharsets.UTF_8);
        this.replaceAllTags();
        return this.m_workingContent.getBytes(StandardCharsets.UTF_8);
    }

    protected void replaceAllTags() {
        this.replaceIncludeTags();
        this.replaceBaseTags();
        this.replaceVersionTags();
        this.replaceMessageTags();
        this.replaceStylesheetsTags();
        this.replaceStylesheetTags();
        this.replaceScriptsTags();
        this.replaceScriptTags();
        this.stripUnknownTags();
    }

    protected void replaceScriptTags(Pattern pattern, String tagPrefix, String tagSuffix) {
        this.m_workingContent = pattern.matcher(this.m_workingContent).replaceAll(r -> tagPrefix + this.createExternalPath(r.group(1)) + tagSuffix);
    }

    protected String createExternalPath(String internalPath) {
        String theme = UiThemeHelper.get().isDefaultTheme(this.m_params.getTheme()) ? null : this.m_params.getTheme();
        return new WebResourceLoader(this.m_params.isMinify(), false, theme).resolveResource(internalPath).map(WebResourceDescriptor::getResolvedPath).orElse(internalPath);
    }

    protected void replaceStylesheetTags() {
        this.replaceScriptTags(PATTERN_STYLESHEET_TAG, STYLESHEET_TAG_PREFIX, STYLESHEET_TAG_SUFFIX);
    }

    protected void replaceScriptTags() {
        this.replaceScriptTags(PATTERN_SCRIPT_TAG, SCRIPT_TAG_PREFIX, SCRIPT_TAG_SUFFIX);
    }

    protected void replaceScriptsTags() {
        if (!this.m_params.isBrowserSupported()) {
            this.m_workingContent = PATTERN_SCRIPTS_TAG.matcher(this.m_workingContent).replaceAll("<script src=\"legacy-browsers.js\"></script>");
            return;
        }
        this.replaceEntryPointTags(PATTERN_SCRIPTS_TAG, ".js", SCRIPT_TAG_PREFIX, SCRIPT_TAG_SUFFIX);
    }

    protected void replaceStylesheetsTags() {
        this.replaceEntryPointTags(PATTERN_STYLESHEETS_TAG, ".css", STYLESHEET_TAG_PREFIX, STYLESHEET_TAG_SUFFIX);
    }

    protected void replaceEntryPointTags(Pattern pattern, String fileSuffixFilter, String tagPrefix, String tagSuffix) {
        this.m_workingContent = pattern.matcher(this.m_workingContent).replaceAll(r -> this.buildScriptTagsForEntryPoint(r.group(1), fileSuffixFilter, tagPrefix, tagSuffix));
    }

    protected String buildScriptTagsForEntryPoint(String entryPoint, String fileSuffixFilter, String tagPrefix, String tagSuffix) {
        return this.getAssetsForEntryPoint(entryPoint).filter(script -> script.toLowerCase().endsWith(fileSuffixFilter)).map(path -> tagPrefix + this.createExternalPath((String)path) + tagSuffix).collect(Collectors.joining("\n"));
    }

    protected Stream<String> getAssetsForEntryPoint(String entryPoint) {
        return ScriptResourceIndexes.getAssetsForEntryPoint((String)entryPoint, (boolean)this.m_params.isMinify(), (boolean)this.m_params.isCacheEnabled()).stream();
    }

    protected void replaceBaseTags() {
        Object basePath = this.m_params.getBasePath();
        if (StringUtility.isNullOrEmpty((CharSequence)basePath)) {
            basePath = "/";
        } else if (((String)basePath).lastIndexOf(47) != ((String)basePath).length() - 1) {
            basePath = (String)basePath + "/";
        }
        String baseTag = "<base href=\"" + (String)basePath + STYLESHEET_TAG_SUFFIX;
        this.m_workingContent = PATTERN_BASE_TAG.matcher(this.m_workingContent).replaceAll(baseTag);
    }

    protected void replaceVersionTags() {
        String version = (String)CONFIG.getPropertyValue(PlatformConfigProperties.ApplicationVersionProperty.class);
        String versionTag = "<scout-version data-value=\"" + version + "\"></scout-version>";
        this.m_workingContent = PATTERN_VERSION_TAG.matcher(this.m_workingContent).replaceAll(versionTag);
    }

    protected void replaceIncludeTags() {
        this.m_workingContent = PATTERN_INCLUDE_TAG.matcher(this.m_workingContent).replaceAll(r -> {
            String includeName = r.group(1);
            URL includeUrl = this.resolveInclude(includeName);
            if (includeUrl == null) {
                throw new ProcessingException("Could not resolve include '{}'.", new Object[]{includeName});
            }
            try {
                byte[] includeContent = IOUtility.readFromUrl((URL)includeUrl);
                String replacement = new String(includeContent, StandardCharsets.UTF_8);
                LOG.trace("Resolved include '{}'", (Object)includeName);
                return "\n" + replacement.trim() + "\n";
            }
            catch (IOException e) {
                throw new ProcessingException("Error reading include '{}'.", new Object[]{includeName, e});
            }
        });
    }

    protected URL resolveInclude(String includeName) {
        return WebResources.resolveWebResource((String)includeName, (boolean)this.m_params.isMinify(), (boolean)this.m_params.isCacheEnabled()).map(WebResourceDescriptor::getUrl).orElse(null);
    }

    protected void replaceMessageTags() {
        this.m_workingContent = PATTERN_MESSAGE_TAG.matcher(this.m_workingContent).replaceAll(this::replaceMessageTag);
    }

    /*
     * Exception decompiling
     */
    protected String replaceMessageTag(MatchResult r) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[6] lbl84 : CaseStatement: default:\u000a, @NONE, blocks:[6] lbl84 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String toJavaScriptString(String text) {
        text = text.replaceAll("'", "\\\\'");
        text = text.replaceAll("(\r\n|\n)", "\\\\n");
        return "'" + text + "'";
    }

    protected void stripUnknownTags() {
        this.m_workingContent = PATTERN_UNKNOWN_TAG.matcher(this.m_workingContent).replaceAll(r -> {
            LOG.warn("Removing unknown or improperly formatted scout tag from '{}': {}", (Object)this.m_params.getHtmlPath(), (Object)r.group());
            return "";
        });
    }
}

