/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.res.loader;

import jakarta.servlet.http.HttpServletRequest;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.server.commons.servlet.cache.HttpCacheKey;
import org.eclipse.scout.rt.server.commons.servlet.cache.HttpCacheObject;
import org.eclipse.scout.rt.server.commons.servlet.cache.IHttpResourceCache;
import org.eclipse.scout.rt.server.commons.servlet.cache.IHttpResponseInterceptor;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceHolder;
import org.eclipse.scout.rt.ui.html.res.IBinaryResourceProvider;
import org.eclipse.scout.rt.ui.html.res.loader.AbstractResourceLoader;
import org.eclipse.scout.rt.ui.html.res.loader.DynamicResourceInfo;

public class DynamicResourceLoader
extends AbstractResourceLoader {
    private final HttpServletRequest m_req;

    public DynamicResourceLoader(HttpServletRequest req) {
        super(null);
        this.m_req = req;
    }

    @Override
    public IHttpResourceCache getCache(HttpCacheKey cacheKey) {
        DynamicResourceInfo info = this.createDynamicResourceInfo(cacheKey);
        if (info == null) {
            return null;
        }
        return info.getUiSession().getHttpResourceCache();
    }

    protected DynamicResourceInfo createDynamicResourceInfo(HttpCacheKey cacheKey) {
        return DynamicResourceInfo.fromPath(this.getRequest(), cacheKey.getResourcePath());
    }

    @Override
    public HttpCacheObject loadResource(HttpCacheKey cacheKey) {
        DynamicResourceInfo info = this.createDynamicResourceInfo(cacheKey);
        if (info == null) {
            return null;
        }
        IBinaryResourceProvider provider = this.getBinaryResourceProvider(info.getUiSession(), info.getJsonAdapterId());
        if (provider == null) {
            return null;
        }
        BinaryResourceHolder localResourceHolder = provider.provideBinaryResource(info.getFileName());
        if (localResourceHolder == null || localResourceHolder.get() == null) {
            return null;
        }
        BinaryResource localResource = localResourceHolder.get();
        BinaryResource httpResource = localResource.createAlias(cacheKey.getResourcePath());
        HttpCacheObject httpCacheObject = new HttpCacheObject(cacheKey, httpResource);
        for (IHttpResponseInterceptor interceptor : localResourceHolder.getHttpResponseInterceptors()) {
            httpCacheObject.addHttpResponseInterceptor(interceptor);
        }
        return httpCacheObject;
    }

    @Override
    public BinaryResource loadResource(String pathInfo) {
        throw new UnsupportedOperationException();
    }

    protected IBinaryResourceProvider getBinaryResourceProvider(IUiSession uiSession, String adapterId) {
        IJsonAdapter<?> jsonAdapter = uiSession.getJsonAdapter(adapterId);
        if (!(jsonAdapter instanceof IBinaryResourceProvider)) {
            return null;
        }
        return (IBinaryResourceProvider)((Object)jsonAdapter);
    }

    public HttpServletRequest getRequest() {
        return this.m_req;
    }
}

