/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.res.loader;

import jakarta.servlet.http.HttpServletRequest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.rt.platform.util.IOUtility;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.UiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;

public class DynamicResourceInfo {
    public static final String PATH_PREFIX = "dynamic";
    public static final Pattern PATTERN_DYNAMIC_ADAPTER_RESOURCE_PATH = Pattern.compile("^/?dynamic/([^/]*)/([^/]*)/(.*)$");
    private final String m_adapterId;
    private final String m_fileName;
    private final IUiSession m_uiSession;

    public DynamicResourceInfo(IJsonAdapter<?> jsonAdapter, String fileName) {
        this(jsonAdapter.getUiSession(), jsonAdapter.getId(), fileName);
    }

    public DynamicResourceInfo(IUiSession uiSession, String adapterId, String fileName) {
        this.m_adapterId = adapterId;
        this.m_fileName = fileName;
        this.m_uiSession = uiSession;
    }

    public String toPath() {
        String encodedFilename = IOUtility.urlEncode((String)this.getFileName());
        encodedFilename = encodedFilename.replace("%2F", "/");
        return "dynamic/" + this.getUiSession().getUiSessionId() + "/" + this.getJsonAdapterId() + "/" + encodedFilename;
    }

    public IUiSession getUiSession() {
        return this.m_uiSession;
    }

    public String getJsonAdapterId() {
        return this.m_adapterId;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public static DynamicResourceInfo fromPath(IJsonAdapter<?> jsonAdapter, String path) {
        DynamicResourcePathComponents parts = DynamicResourcePathComponents.fromPath(path);
        if (parts == null) {
            return null;
        }
        if (!jsonAdapter.getUiSession().getUiSessionId().equals(parts.getUiSessionId())) {
            return null;
        }
        if (!jsonAdapter.getId().equals(parts.getAdapterId())) {
            return null;
        }
        return new DynamicResourceInfo(jsonAdapter, parts.getFilename());
    }

    public static DynamicResourceInfo fromPath(IUiSession uiSession, String path) {
        DynamicResourcePathComponents parts = DynamicResourcePathComponents.fromPath(path);
        if (parts == null) {
            return null;
        }
        if (!uiSession.getUiSessionId().equals(parts.getUiSessionId())) {
            return null;
        }
        IJsonAdapter<?> jsonAdapter = uiSession.getJsonAdapter(parts.getAdapterId());
        if (jsonAdapter == null) {
            return null;
        }
        return new DynamicResourceInfo(jsonAdapter, parts.getFilename());
    }

    public static DynamicResourceInfo fromPath(HttpServletRequest req, String path) {
        DynamicResourcePathComponents components = DynamicResourcePathComponents.fromPath(path);
        if (components == null) {
            return null;
        }
        IUiSession uiSession = UiSession.get(req, components.getUiSessionId());
        if (uiSession == null) {
            return null;
        }
        return new DynamicResourceInfo(uiSession, components.getAdapterId(), components.getFilename());
    }

    protected static class DynamicResourcePathComponents {
        String uiSessionId;
        String adapterId;
        String filename;

        DynamicResourcePathComponents(String uiSessionId, String adapterId, String filename) {
            this.uiSessionId = uiSessionId;
            this.adapterId = adapterId;
            this.filename = filename;
        }

        public String getUiSessionId() {
            return this.uiSessionId;
        }

        public String getAdapterId() {
            return this.adapterId;
        }

        public String getFilename() {
            return this.filename;
        }

        public static DynamicResourcePathComponents fromPath(String path) {
            if (path == null) {
                return null;
            }
            Matcher m = PATTERN_DYNAMIC_ADAPTER_RESOURCE_PATH.matcher(path);
            if (!m.matches()) {
                return null;
            }
            String uiSessionId = m.group(1);
            String adapterId = m.group(2);
            String filename = m.group(3);
            return new DynamicResourcePathComponents(uiSessionId, adapterId, filename);
        }
    }
}

