/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.res.loader;

import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.rt.platform.util.IOUtility;

public class BinaryRefResourceInfo {
    public static final Pattern PATTERN_BINARY_REF_RESOURCE_PATH = Pattern.compile("^/?binref/([^/]*/.*)$");
    private final String m_binaryRef;

    public BinaryRefResourceInfo(String binaryRef) {
        this.m_binaryRef = binaryRef;
    }

    public String toPath() {
        String binaryRef = IOUtility.urlEncode((String)this.getBinaryRef());
        return "binref" + ((binaryRef = binaryRef.replace("%2F", "/")).startsWith("/") ? "" : "/") + binaryRef;
    }

    public URI toBinaryRefUri() {
        return URI.create("binref:" + (this.getBinaryRef().startsWith("/") ? "" : "/") + this.getBinaryRef());
    }

    public String getBinaryRef() {
        return this.m_binaryRef;
    }

    public static BinaryRefResourceInfo fromPath(String path) {
        BinaryRefResourcePathComponents parts = BinaryRefResourcePathComponents.fromPath(path);
        if (parts == null) {
            return null;
        }
        return new BinaryRefResourceInfo(parts.getBinaryRef());
    }

    protected static class BinaryRefResourcePathComponents {
        String m_binaryRef;

        BinaryRefResourcePathComponents(String binaryRef) {
            this.m_binaryRef = binaryRef;
        }

        public String getBinaryRef() {
            return this.m_binaryRef;
        }

        public static BinaryRefResourcePathComponents fromPath(String path) {
            if (path == null) {
                return null;
            }
            Matcher m = PATTERN_BINARY_REF_RESOURCE_PATH.matcher(path);
            if (!m.matches()) {
                return null;
            }
            String binaryRef = m.group(1);
            return new BinaryRefResourcePathComponents(binaryRef);
        }
    }
}

