/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.res;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Adler32;
import org.eclipse.scout.rt.client.services.common.icon.IconLocator;
import org.eclipse.scout.rt.client.services.common.icon.IconSpec;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.resource.BinaryResourceUtility;
import org.eclipse.scout.rt.platform.util.Pair;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceHolder;
import org.eclipse.scout.rt.ui.html.res.IBinaryResourceProvider;
import org.eclipse.scout.rt.ui.html.res.loader.BinaryRefResourceInfo;
import org.eclipse.scout.rt.ui.html.res.loader.DynamicResourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BinaryResourceUrlUtility {
    private static final Logger LOG = LoggerFactory.getLogger(BinaryResourceUrlUtility.class);
    public static final Pattern ICON_REGEX_PATTERN = Pattern.compile("([\"'])iconId:([^\"']+)\\1", 2);
    public static final Pattern BINARY_RESOURCE_REGEX_PATTERN = Pattern.compile("([\"'])binaryResource:([^\"']+)\\1", 2);
    public static final Pattern BINARY_REF_REGEX_PATTERN = Pattern.compile("([\"'])binref:([^\"']+)\\1", 2);

    private BinaryResourceUrlUtility() {
    }

    public static String createIconUrl(String iconId) {
        if (!StringUtility.hasText((CharSequence)iconId) || "null".equals(iconId)) {
            return null;
        }
        if (iconId.startsWith("font:")) {
            return iconId;
        }
        if (iconId.startsWith("url:")) {
            return StringUtility.removePrefixes((String)iconId, (String[])new String[]{"url:"});
        }
        IconSpec iconSpec = IconLocator.instance().getIconSpec(iconId);
        if (iconSpec != null) {
            return "icon/" + iconSpec.getName();
        }
        LOG.warn("iconId '{}' could not be resolved", (Object)iconId);
        return null;
    }

    public static String replaceIconIdHandlerWithUrl(String str) {
        if (str == null) {
            return null;
        }
        Matcher m = ICON_REGEX_PATTERN.matcher(str);
        StringBuilder ret = new StringBuilder();
        while (m.find()) {
            m.appendReplacement(ret, m.group(1) + BinaryResourceUrlUtility.createIconUrl(m.group(2)) + m.group(1));
        }
        m.appendTail(ret);
        return ret.toString();
    }

    public static String createDynamicAdapterResourceUrl(IJsonAdapter<?> jsonAdapter, BinaryResource binaryResource) {
        if (!BinaryResourceUrlUtility.checkDynamicAdapterResourceUrlArguments(jsonAdapter, binaryResource)) {
            return null;
        }
        return new DynamicResourceInfo(jsonAdapter, BinaryResourceUrlUtility.getFilenameWithFingerprint(binaryResource)).toPath();
    }

    public static String createDynamicAdapterResourceUrl(IJsonAdapter<?> jsonAdapter, String filename) {
        if (!BinaryResourceUrlUtility.checkDynamicAdapterResourceUrlArguments(jsonAdapter, filename)) {
            return null;
        }
        return new DynamicResourceInfo(jsonAdapter, filename).toPath();
    }

    public static String createBinaryRefResourceUrl(String binaryRef) {
        if (!BinaryResourceUrlUtility.checkBinaryRefResourceUrlArguments(binaryRef)) {
            return null;
        }
        return new BinaryRefResourceInfo(binaryRef).toPath();
    }

    private static boolean checkBinaryRefResourceUrlArguments(Object arg) {
        return arg != null;
    }

    public static String getFilenameWithFingerprint(IJsonAdapter<?> jsonAdapter, String path) {
        if (!BinaryResourceUrlUtility.checkDynamicAdapterResourceUrlArguments(jsonAdapter, path)) {
            return null;
        }
        DynamicResourceInfo info = DynamicResourceInfo.fromPath(jsonAdapter, path);
        if (info == null) {
            return null;
        }
        return info.getFileName();
    }

    public static String getFilenameWithFingerprint(BinaryResource binaryResource) {
        return BinaryResourceUtility.createFilenameWithFingerprint((BinaryResource)binaryResource);
    }

    private static boolean checkDynamicAdapterResourceUrlArguments(IJsonAdapter<?> jsonAdapter, Object arg) {
        if (jsonAdapter == null) {
            return false;
        }
        if (!(jsonAdapter instanceof IBinaryResourceProvider)) {
            LOG.warn("adapter {} is not implementing {}", jsonAdapter, (Object)IBinaryResourceProvider.class.getName());
            return false;
        }
        return arg != null;
    }

    public static String replaceBinaryResourceHandlerWithUrl(IJsonAdapter<?> jsonAdapter, String str) {
        if (str == null) {
            return null;
        }
        Matcher m = BINARY_RESOURCE_REGEX_PATTERN.matcher(str);
        StringBuilder ret = new StringBuilder();
        while (m.find()) {
            m.appendReplacement(ret, m.group(1) + BinaryResourceUrlUtility.createDynamicAdapterResourceUrl(jsonAdapter, m.group(2)) + m.group(1));
        }
        m.appendTail(ret);
        return ret.toString();
    }

    public static String replaceBinaryRefHandlerWithUrl(String str) {
        if (str == null) {
            return null;
        }
        Matcher m = BINARY_REF_REGEX_PATTERN.matcher(str);
        StringBuilder ret = new StringBuilder();
        while (m.find()) {
            m.appendReplacement(ret, m.group(1) + BinaryResourceUrlUtility.createBinaryRefResourceUrl(m.group(2)) + m.group(1));
        }
        m.appendTail(ret);
        return ret.toString();
    }

    public static String replaceImageUrls(IJsonAdapter<?> jsonAdapter, String str) {
        str = BinaryResourceUrlUtility.replaceIconIdHandlerWithUrl(str);
        str = BinaryResourceUrlUtility.replaceBinaryRefHandlerWithUrl(str);
        return BinaryResourceUrlUtility.replaceBinaryResourceHandlerWithUrl(jsonAdapter, str);
    }

    public static BinaryResourceHolder provideBinaryResource(String filenameWithFingerprint, Function<String, BinaryResource> attachmentProvider) {
        Pair filenameAndFingerprint = BinaryResourceUtility.extractFilenameWithFingerprint((String)filenameWithFingerprint);
        String filename = (String)filenameAndFingerprint.getLeft();
        BinaryResource attachment = attachmentProvider.apply(filename);
        return attachment == null ? null : new BinaryResourceHolder(attachment);
    }

    public static BinaryResource extractBinaryResource(Object raw, String prefix, String fileExtension) {
        if (raw instanceof BinaryResource) {
            return (BinaryResource)raw;
        }
        if (raw instanceof byte[]) {
            Adler32 crc = new Adler32();
            crc.update((byte[])raw);
            return new BinaryResource(StringUtility.join((String)"-", (Object[])new Object[]{prefix, crc.getValue(), ((byte[])raw).length}) + "." + fileExtension, (byte[])raw);
        }
        return null;
    }
}

