/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.management;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.servlet.http.HttpSession;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.management.ObjectName;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.CreateImmediately;
import org.eclipse.scout.rt.platform.jmx.MBeanUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.shared.ISession;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.management.ISessionMonitorMBean;

@ApplicationScoped
@CreateImmediately
public class SessionMonitorMBean
implements ISessionMonitorMBean {
    protected static final Object MARKER_VALUE = new Object();
    protected Map<WeakReference<HttpSession>, Object> m_httpSessionRefs = new ConcurrentHashMap<WeakReference<HttpSession>, Object>();
    protected Map<WeakReference<IUiSession>, Object> m_uiSessionRefs = new ConcurrentHashMap<WeakReference<IUiSession>, Object>();
    protected Map<WeakReference<IClientSession>, Object> m_clientSessionRefs = new ConcurrentHashMap<WeakReference<IClientSession>, Object>();

    protected ObjectName jmxObjectName() {
        return MBeanUtility.toJmxName((String)"org.eclipse.scout.rt.ui.html", (String)"Sessions");
    }

    @PostConstruct
    protected void postConstruct() {
        MBeanUtility.register((ObjectName)this.jmxObjectName(), (Object)this);
    }

    @PreDestroy
    protected void preDestroy() {
        MBeanUtility.unregister((ObjectName)this.jmxObjectName());
    }

    public void weakRegister(HttpSession httpSession) {
        this.m_httpSessionRefs.put(new WeakReference<HttpSession>(httpSession), MARKER_VALUE);
    }

    public void weakRegister(IUiSession uiSession) {
        this.m_uiSessionRefs.put(new WeakReference<IUiSession>(uiSession), MARKER_VALUE);
    }

    public void weakRegister(IClientSession clientSession) {
        this.m_clientSessionRefs.put(new WeakReference<IClientSession>(clientSession), MARKER_VALUE);
    }

    @Override
    public int getNumHttpSessions() {
        return (int)this.m_httpSessionRefs.keySet().stream().map(Reference::get).filter(Objects::nonNull).count();
    }

    @Override
    public int getNumUiSessions() {
        return (int)this.m_uiSessionRefs.keySet().stream().map(Reference::get).filter(Objects::nonNull).count();
    }

    @Override
    public int getNumClientSessions() {
        return (int)this.m_clientSessionRefs.keySet().stream().map(Reference::get).filter(Objects::nonNull).count();
    }

    @Override
    public List<String> getSessionTable() {
        List<ISessionMonitorMBean.SessionDetail> details = this.getSessionDetails();
        ArrayList<String> strings = new ArrayList<String>(1 + details.size());
        strings.add(ISessionMonitorMBean.SessionDetail.toCsvHeader());
        for (ISessionMonitorMBean.SessionDetail d : details) {
            strings.add(d.toCsvRow());
        }
        return strings;
    }

    @Override
    public List<ISessionMonitorMBean.SessionDetail> getSessionDetails() {
        Map<String, IClientSession> clients = this.m_clientSessionRefs.keySet().stream().map(Reference::get).filter(Objects::nonNull).collect(Collectors.toMap(ISession::getId, c -> c));
        Map<String, List<IUiSession>> clientToUis = this.m_uiSessionRefs.keySet().stream().map(Reference::get).filter(Objects::nonNull).collect(Collectors.groupingBy(uiSession -> (String)ObjectUtility.nvl((Object)uiSession.getClientSessionId(), (Object)"[Unmapped]")));
        clients.values().stream().forEach(clientSession -> {
            List list = clientToUis.computeIfAbsent(clientSession.getId(), clientSessionId -> Collections.singletonList(null));
        });
        ArrayList<ISessionMonitorMBean.SessionDetail> list = new ArrayList<ISessionMonitorMBean.SessionDetail>();
        clientToUis.forEach((clientSessionId, uiSessions) -> uiSessions.forEach(uiSession -> {
            boolean bl = list.add(this.createSessionInfo((IUiSession)uiSession, (IClientSession)clients.get(clientSessionId)));
        }));
        Comparator<ISessionMonitorMBean.SessionDetail> comp = Comparator.comparing(ISessionMonitorMBean.SessionDetail::getHttpSessionId).thenComparing(ISessionMonitorMBean.SessionDetail::getUiSessionId).thenComparing(ISessionMonitorMBean.SessionDetail::getClientSessionId);
        Collections.sort(list, comp);
        return list;
    }

    private ISessionMonitorMBean.SessionDetail createSessionInfo(IUiSession uiSession, IClientSession clientSession) {
        String httpSessionId = "";
        String uiSessionId = "";
        String clientSessionId = "";
        String userId = "";
        long lastAccessed = 0L;
        String uiState = "";
        String clientState = "";
        if (uiSession != null) {
            httpSessionId = uiSession.getHttpSessionId();
            uiSessionId = uiSession.getUiSessionId();
            lastAccessed = uiSession.getLastAccessedTime();
            uiState = uiSession.isDisposed() ? "Disposed" : (uiSession.isInitialized() ? "Active" : "Preregistered");
        }
        if (clientSession != null) {
            clientSessionId = clientSession.getId();
            userId = clientSession.getUserId();
            clientState = clientSession.isStopping() ? (clientSession.isActive() ? "Stopping" : "Stopped") : (clientSession.isActive() ? "Active" : "Starting");
        }
        return new ISessionMonitorMBean.SessionDetail(httpSessionId, uiSessionId, clientSessionId, userId, uiState, clientState, lastAccessed);
    }
}

