/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.ui.AbstractEventBuffer;
import org.eclipse.scout.rt.client.ui.IEventHistory;
import org.eclipse.scout.rt.client.ui.IModelEvent;
import org.eclipse.scout.rt.client.ui.MouseButton;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.ITreeContextMenu;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.tree.AutoCheckStyle;
import org.eclipse.scout.rt.client.ui.basic.tree.CheckableStyle;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeAdapter;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeListener;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeUtility;
import org.eclipse.scout.rt.client.ui.dnd.ResourceListTransferObject;
import org.eclipse.scout.rt.client.ui.dnd.TransferObject;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.visitor.DepthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.IDepthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.TreeVisitResult;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.UiException;
import org.eclipse.scout.rt.ui.html.json.AbstractJsonWidget;
import org.eclipse.scout.rt.ui.html.json.FilteredJsonAdapterIds;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonObjectUtility;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.action.DisplayableActionFilter;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterProperty;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterPropertyConfig;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterPropertyConfigBuilder;
import org.eclipse.scout.rt.ui.html.json.menu.IJsonContextMenuOwner;
import org.eclipse.scout.rt.ui.html.json.menu.JsonContextMenu;
import org.eclipse.scout.rt.ui.html.json.tree.IChildNodeIndexLookup;
import org.eclipse.scout.rt.ui.html.json.tree.JsonTreeEvent;
import org.eclipse.scout.rt.ui.html.json.tree.JsonTreeListener;
import org.eclipse.scout.rt.ui.html.json.tree.JsonTreeListeners;
import org.eclipse.scout.rt.ui.html.json.tree.TreeEventFilter;
import org.eclipse.scout.rt.ui.html.json.tree.TreeEventFilterCondition;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceUrlUtility;
import org.eclipse.scout.rt.ui.html.res.IBinaryResourceConsumer;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonTree<TREE extends ITree>
extends AbstractJsonWidget<TREE>
implements IJsonContextMenuOwner,
IBinaryResourceConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(JsonTree.class);
    public static final String EVENT_NODES_INSERTED = "nodesInserted";
    public static final String EVENT_NODES_UPDATED = "nodesUpdated";
    public static final String EVENT_NODES_DELETED = "nodesDeleted";
    public static final String EVENT_ALL_CHILD_NODES_DELETED = "allChildNodesDeleted";
    public static final String EVENT_NODES_SELECTED = "nodesSelected";
    public static final String EVENT_NODE_CLICK = "nodeClick";
    public static final String EVENT_NODE_ACTION = "nodeAction";
    public static final String EVENT_NODE_EXPANDED = "nodeExpanded";
    public static final String EVENT_NODE_CHANGED = "nodeChanged";
    public static final String EVENT_CHILD_NODE_ORDER_CHANGED = "childNodeOrderChanged";
    public static final String EVENT_NODES_CHECKED = "nodesChecked";
    public static final String EVENT_REQUEST_FOCUS = "requestFocus";
    public static final String EVENT_SCROLL_TO_SELECTION = "scrollToSelection";
    public static final String PROP_NODE_ID = "nodeId";
    public static final String PROP_NODE_IDS = "nodeIds";
    public static final String PROP_COMMON_PARENT_NODE_ID = "commonParentNodeId";
    public static final String PROP_NODE = "node";
    public static final String PROP_NODES = "nodes";
    public static final String PROP_EXPANDED = "expanded";
    public static final String PROP_EXPANDED_LAZY = "expandedLazy";
    public static final String PROP_SELECTED_NODES = "selectedNodes";
    private TreeListener m_treeListener;
    private final Map<String, ITreeNode> m_treeNodes;
    private final Map<ITreeNode, String> m_treeNodeIds;
    private final Map<ITreeNode, Set<ITreeNode>> m_childNodes;
    private final Map<ITreeNode, ITreeNode> m_parentNodes;
    private final TreeEventFilter m_treeEventFilter;
    private final AbstractEventBuffer<TreeEvent> m_eventBuffer;
    private JsonContextMenu<IContextMenu> m_jsonContextMenu;
    private final JsonTreeListeners m_listeners = new JsonTreeListeners();

    public JsonTree(TREE model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
        this.m_treeNodes = new HashMap<String, ITreeNode>();
        this.m_treeNodeIds = new HashMap<ITreeNode, String>();
        this.m_childNodes = new HashMap<ITreeNode, Set<ITreeNode>>();
        this.m_parentNodes = new HashMap<ITreeNode, ITreeNode>();
        this.m_treeEventFilter = new TreeEventFilter(this);
        this.m_eventBuffer = model.createEventBuffer();
    }

    @Override
    public String getObjectType() {
        return "Tree";
    }

    public JsonContextMenu<IContextMenu> getJsonContextMenu() {
        return this.m_jsonContextMenu;
    }

    @Override
    public void init() {
        super.init();
        IEventHistory eventHistory = ((ITree)this.getModel()).getEventHistory();
        if (eventHistory != null) {
            for (TreeEvent event : eventHistory.getRecentEvents()) {
                this.processBufferedEvent(event);
            }
        }
    }

    @Override
    protected void initJsonProperties(TREE model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<TREE>("title", (ITree)model){

            @Override
            protected String modelValue() {
                return ((ITree)this.getModel()).getTitle();
            }
        });
        this.putJsonProperty(new JsonProperty<TREE>("iconId", (ITree)model){

            @Override
            protected String modelValue() {
                return ((ITree)this.getModel()).getIconId();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return BinaryResourceUrlUtility.createIconUrl((String)value);
            }
        });
        this.putJsonProperty(new JsonProperty<TREE>("checkable", (ITree)model){

            @Override
            protected Boolean modelValue() {
                return ((ITree)this.getModel()).isCheckable();
            }
        });
        this.putJsonProperty(new JsonProperty<TREE>("multiCheck", (ITree)model){

            @Override
            protected Boolean modelValue() {
                return ((ITree)this.getModel()).isMultiCheck();
            }
        });
        this.putJsonProperty(new JsonProperty<TREE>("lazyExpandingEnabled", (ITree)model){

            @Override
            protected Boolean modelValue() {
                return ((ITree)this.getModel()).isLazyExpandingEnabled();
            }
        });
        this.putJsonProperty(new JsonProperty<TREE>("autoCheckChildren", (ITree)model){

            @Override
            protected Boolean modelValue() {
                return ((ITree)this.getModel()).isAutoCheckChildNodes();
            }
        });
        this.putJsonProperty(new JsonProperty<TREE>("autoCheckStyle", (ITree)model){

            protected AutoCheckStyle modelValue() {
                return ((ITree)this.getModel()).getAutoCheckStyle();
            }
        });
        this.putJsonProperty(new JsonProperty<TREE>(EVENT_SCROLL_TO_SELECTION, (ITree)model){

            @Override
            protected Boolean modelValue() {
                return ((ITree)this.getModel()).isScrollToSelection();
            }
        });
        this.putJsonProperty(new JsonProperty<TREE>("dropType", (ITree)model){

            @Override
            protected Integer modelValue() {
                return ((ITree)this.getModel()).getDropType();
            }
        });
        this.putJsonProperty(new JsonProperty<TREE>("dropMaximumSize", (ITree)model){

            @Override
            protected Long modelValue() {
                return ((ITree)this.getModel()).getDropMaximumSize();
            }
        });
        this.putJsonProperty(new JsonAdapterProperty<TREE>("keyStrokes", (ITree)model, this.getUiSession()){

            @Override
            protected JsonAdapterPropertyConfig createConfig() {
                return new JsonAdapterPropertyConfigBuilder().filter(new DisplayableActionFilter()).build();
            }

            @Override
            protected List<IKeyStroke> modelValue() {
                return ((ITree)this.getModel()).getKeyStrokes();
            }
        });
        this.putJsonProperty(new JsonProperty<TREE>("displayStyle", (ITree)model){

            @Override
            protected String modelValue() {
                return ((ITree)this.getModel()).getDisplayStyle();
            }
        });
        this.putJsonProperty(new JsonProperty<TREE>("toggleBreadcrumbStyleEnabled", (ITree)model){

            @Override
            protected Boolean modelValue() {
                return ((ITree)this.getModel()).isToggleBreadcrumbStyleEnabled();
            }
        });
        this.putJsonProperty(new JsonProperty<TREE>("checkableStyle", (ITree)model){

            protected CheckableStyle modelValue() {
                return ((ITree)this.getModel()).getCheckableStyle();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return ((CheckableStyle)value).name().toLowerCase();
            }
        });
        this.putJsonProperty(new JsonProperty<TREE>("textFilterEnabled", (ITree)model){

            @Override
            protected Boolean modelValue() {
                return ((ITree)this.getModel()).isTextFilterEnabled();
            }
        });
    }

    @Override
    protected void attachChildAdapters() {
        super.attachChildAdapters();
        this.m_jsonContextMenu = this.createJsonContextMenu();
        this.m_jsonContextMenu.init();
        this.attachNodes(this.getTopLevelNodes(), true);
    }

    protected JsonContextMenu<IContextMenu> createJsonContextMenu() {
        return new JsonContextMenu<ITreeContextMenu>(((ITree)this.getModel()).getContextMenu(), this);
    }

    @Override
    protected void disposeChildAdapters() {
        this.disposeAllNodes();
        this.m_jsonContextMenu.dispose();
        super.disposeChildAdapters();
    }

    @Override
    protected void attachModel() {
        super.attachModel();
        if (this.m_treeListener != null) {
            throw new IllegalStateException();
        }
        this.m_treeListener = new P_TreeListener();
        ((ITree)this.getModel()).addUITreeListener(this.m_treeListener, new Integer[0]);
    }

    @Override
    protected void detachModel() {
        super.detachModel();
        if (this.m_treeListener == null) {
            throw new IllegalStateException();
        }
        ((ITree)this.getModel()).removeTreeListener(this.m_treeListener, new Integer[0]);
        this.m_treeListener = null;
    }

    protected void attachNodeInternal(ITreeNode node) {
        this.getOrCreateNodeId(node);
        Set<ITreeNode> children = this.getChildNodes(node.getParentNode());
        children.add(node);
        this.m_childNodes.put(node.getParentNode(), children);
        this.m_parentNodes.put(node, node.getParentNode());
    }

    protected void attachNode(ITreeNode node, boolean attachChildren) {
        if (!this.isNodeAccepted(node)) {
            return;
        }
        this.attachNodeInternal(node);
        if (attachChildren) {
            this.attachNodes(node.getChildNodes(), true);
        }
    }

    protected void attachNodes(Collection<ITreeNode> nodes, boolean attachChildren) {
        nodes = this.getChildrenIfInvisibleRootNode(nodes);
        for (ITreeNode node : nodes) {
            this.attachNode(node, attachChildren);
        }
    }

    protected void disposeAllNodes() {
        this.m_treeNodeIds.clear();
        this.m_treeNodes.clear();
        this.m_childNodes.clear();
        this.m_parentNodes.clear();
    }

    protected void disposeNode(ITreeNode node, boolean disposeChildren, Set<ITreeNode> disposedNodes) {
        if (disposeChildren) {
            this.disposeNodes(this.getChildNodes(node), true, disposedNodes);
        }
        String nodeId = this.m_treeNodeIds.get(node);
        this.m_treeNodeIds.remove(node);
        this.m_treeNodes.remove(nodeId);
        this.m_childNodes.remove(node);
        this.m_parentNodes.remove(node);
        disposedNodes.add(node);
    }

    protected Set<ITreeNode> getChildNodes(ITreeNode node) {
        Set<ITreeNode> children = this.m_childNodes.get(node);
        if (children == null) {
            return new HashSet<ITreeNode>();
        }
        return children;
    }

    protected ITreeNode getParentNode(ITreeNode node) {
        return this.m_parentNodes.get(node);
    }

    protected void unlinkFromParentNode(ITreeNode node) {
        ITreeNode parentNode = this.getParentNode(node);
        Set<ITreeNode> childrenOfParent = this.getChildNodes(parentNode);
        childrenOfParent.remove(node);
    }

    protected void disposeNodes(Collection<ITreeNode> nodes, boolean disposeChildren, Set<ITreeNode> disposedNodes) {
        for (ITreeNode node : nodes) {
            this.disposeNode(node, disposeChildren, disposedNodes);
        }
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        IChildNodeIndexLookup childIndexes = this.createChildNodeIndexLookup();
        JSONArray jsonNodes = this.treeNodesToJson(this.getTopLevelNodes(), childIndexes);
        this.putProperty(json, PROP_NODES, jsonNodes);
        this.putProperty(json, PROP_SELECTED_NODES, this.nodeIdsToJson(((ITree)this.getModel()).getSelectedNodes(), true, true));
        this.putProperty(json, "menus", this.getJsonContextMenu().childActionsToJson());
        return json;
    }

    protected IChildNodeIndexLookup createChildNodeIndexLookup() {
        IdentityHashMap indexMap = new IdentityHashMap();
        return node -> {
            ITreeNode parentNode = node.getParentNode();
            if (parentNode == null) {
                return -1;
            }
            Integer indexOrNull = (Integer)indexMap.get(node);
            if (indexOrNull != null) {
                return indexOrNull;
            }
            int childNodeIndex = 0;
            for (ITreeNode childNode : parentNode.getChildNodes()) {
                if (!this.isNodeAccepted(childNode)) continue;
                indexMap.put(childNode, childNodeIndex);
                ++childNodeIndex;
            }
            return (Integer)ObjectUtility.nvl((Object)((Integer)indexMap.get(node)), (Object)-1);
        };
    }

    protected void handleModelTreeEvent(TreeEvent event) {
        if ((event = this.m_treeEventFilter.filter(event)) == null) {
            return;
        }
        this.bufferModelEvent(event);
        this.registerAsBufferedEventsAdapter();
    }

    protected void bufferModelEvent(TreeEvent event) {
        switch (event.getType()) {
            case 400: {
                this.applyFilterChangedEventToUiRec(Collections.singletonList(((ITree)this.getModel()).getRootNode()));
                break;
            }
            default: {
                this.m_eventBuffer.add((IModelEvent)event);
            }
        }
    }

    protected void applyFilterChangedEventToUiRec(List<ITreeNode> nodes) {
        HashMap<ITreeNode, List<ITreeNode>> nodesToInsertByParent = new HashMap<ITreeNode, List<ITreeNode>>();
        HashMap<ITreeNode, List<ITreeNode>> nodesToDeleteByParent = new HashMap<ITreeNode, List<ITreeNode>>();
        this.processFilterChangedEventForUiRec(Collections.singletonList(((ITree)this.getModel()).getRootNode()), nodesToInsertByParent, nodesToDeleteByParent);
        nodesToDeleteByParent.forEach((key, value) -> this.m_eventBuffer.add((IModelEvent)new TreeEvent((ITree)this.getModel(), 30, key, (Collection)value)));
        nodesToInsertByParent.forEach((key, value) -> this.m_eventBuffer.add((IModelEvent)new TreeEvent((ITree)this.getModel(), 10, key, (Collection)value)));
    }

    protected void processFilterChangedEventForUiRec(List<ITreeNode> nodes, Map<ITreeNode, List<ITreeNode>> nodesToInsertByParent, Map<ITreeNode, List<ITreeNode>> nodesToDeleteByParent) {
        for (ITreeNode node : nodes) {
            boolean processChildNodes = true;
            if (!this.isInvisibleRootNode(node) && node.getTree() != null) {
                String existingNodeId = this.optNodeId(node);
                if (node.isFilterAccepted()) {
                    if (existingNodeId == null) {
                        nodesToInsertByParent.computeIfAbsent(node.getParentNode(), k -> new LinkedList()).add(node);
                        processChildNodes = false;
                    }
                } else if (!node.isRejectedByUser()) {
                    if (existingNodeId != null) {
                        nodesToDeleteByParent.computeIfAbsent(node.getParentNode(), k -> new LinkedList()).add(node);
                    }
                    processChildNodes = false;
                }
            }
            if (!processChildNodes) continue;
            this.processFilterChangedEventForUiRec(node.getChildNodes(), nodesToInsertByParent, nodesToDeleteByParent);
        }
    }

    @Override
    public void processBufferedEvents() {
        if (this.m_eventBuffer.isEmpty()) {
            return;
        }
        List coalescedEvents = this.m_eventBuffer.consumeAndCoalesceEvents();
        for (TreeEvent event : coalescedEvents) {
            this.processBufferedEvent(event);
        }
    }

    protected void processBufferedEvent(TreeEvent event) {
        switch (event.getType()) {
            case 10: {
                this.handleModelNodesInserted(event);
                break;
            }
            case 20: {
                this.handleModelNodesUpdated(event);
                break;
            }
            case 30: {
                this.handleModelNodesDeleted(event);
                break;
            }
            case 31: {
                this.handleModelAllChildNodesDeleted(event);
                break;
            }
            case 100: 
            case 101: {
                if (this.isInvisibleRootNode(event.getNode())) break;
                this.handleModelNodeExpanded(event.getNode(), false);
                break;
            }
            case 102: 
            case 103: {
                if (this.isInvisibleRootNode(event.getNode())) {
                    for (ITreeNode childNode : event.getNode().getChildNodes()) {
                        this.handleModelNodeExpanded(childNode, true);
                    }
                    break;
                }
                this.handleModelNodeExpanded(event.getNode(), true);
                break;
            }
            case 40: {
                this.handleModelNodesSelected(event.getNodes());
                break;
            }
            case 870: {
                this.handleModelNodesChecked(event.getNodes());
                break;
            }
            case 850: {
                this.handleModelNodeChanged(event.getNode());
                break;
            }
            case 400: {
                throw new IllegalStateException("Unsupported event type: " + String.valueOf(event));
            }
            case 50: {
                this.handleModelChildNodeOrderChanged(event);
                break;
            }
            case 800: {
                this.handleModelRequestFocus(event);
                break;
            }
            case 830: {
                this.handleModelScrollToSelection(event);
                break;
            }
            default: {
                this.handleModelOtherTreeEvent(event);
            }
        }
    }

    protected void handleModelOtherTreeEvent(TreeEvent event) {
    }

    protected void handleModelNodeExpanded(ITreeNode modelNode, boolean recursive) {
        if (!this.isNodeAccepted(modelNode)) {
            return;
        }
        String nodeId = this.optNodeId(modelNode);
        if (nodeId == null) {
            return;
        }
        JSONObject jsonEvent = new JSONObject();
        this.putProperty(jsonEvent, PROP_NODE_ID, nodeId);
        this.putProperty(jsonEvent, PROP_EXPANDED, modelNode.isExpanded());
        this.putProperty(jsonEvent, PROP_EXPANDED_LAZY, modelNode.isExpandedLazy());
        this.putProperty(jsonEvent, "recursive", recursive);
        this.addActionEvent(EVENT_NODE_EXPANDED, jsonEvent);
    }

    protected void handleModelNodesInserted(TreeEvent event) {
        HashSet<ITreeNode> acceptedNodes = new HashSet<ITreeNode>();
        this.attachNodes(event.getNodes(), true);
        IChildNodeIndexLookup childIndexes = this.createChildNodeIndexLookup();
        JSONArray jsonNodes = this.treeNodesToJson(event.getNodes(), childIndexes, acceptedNodes);
        if (jsonNodes.length() == 0) {
            return;
        }
        JSONObject jsonEvent = new JSONObject();
        this.putProperty(jsonEvent, PROP_NODES, jsonNodes);
        this.putProperty(jsonEvent, PROP_COMMON_PARENT_NODE_ID, this.getOrCreateNodeId(event.getCommonParentNode()));
        this.addActionEvent(EVENT_NODES_INSERTED, jsonEvent);
        this.m_listeners.fireEvent(new JsonTreeEvent(this, 100, acceptedNodes));
    }

    protected void handleModelNodesUpdated(TreeEvent event) {
        JSONArray jsonNodes = new JSONArray();
        for (ITreeNode node : event.getNodes()) {
            String nodeId;
            if (!this.isNodeAccepted(node) || (nodeId = this.optNodeId(node)) == null) continue;
            JSONObject jsonNode = new JSONObject();
            this.putProperty(jsonNode, "id", nodeId);
            this.putProperty(jsonNode, "leaf", node.isLeaf());
            this.putProperty(jsonNode, "enabled", node.isEnabled());
            this.putProperty(jsonNode, "lazyExpandingEnabled", node.isLazyExpandingEnabled());
            jsonNodes.put((Object)jsonNode);
        }
        if (jsonNodes.length() == 0) {
            return;
        }
        JSONObject jsonEvent = new JSONObject();
        this.putProperty(jsonEvent, PROP_NODES, jsonNodes);
        this.putProperty(jsonEvent, PROP_COMMON_PARENT_NODE_ID, this.optNodeId(event.getCommonParentNode()));
        this.addActionEvent(EVENT_NODES_UPDATED, jsonEvent);
    }

    protected void handleModelNodesDeleted(TreeEvent event) {
        Collection nodes = event.getNodes();
        JSONObject jsonEvent = new JSONObject();
        this.putProperty(jsonEvent, PROP_COMMON_PARENT_NODE_ID, this.optNodeId(event.getCommonParentNode()));
        if (event.getCommonParentNode() != null && this.getFilteredNodeCount(event.getCommonParentNode()) == 0) {
            this.addActionEvent(EVENT_ALL_CHILD_NODES_DELETED, jsonEvent);
        } else {
            JSONArray jsonNodeIds = this.nodeIdsToJson(nodes, false, false);
            if (jsonNodeIds.length() > 0) {
                this.putProperty(jsonEvent, PROP_NODE_IDS, jsonNodeIds);
                this.addActionEvent(EVENT_NODES_DELETED, jsonEvent);
            }
        }
        for (ITreeNode node : nodes) {
            this.unlinkFromParentNode(node);
        }
        HashSet<ITreeNode> disposedNodes = new HashSet<ITreeNode>();
        this.disposeNodes(nodes, true, disposedNodes);
        this.m_listeners.fireEvent(new JsonTreeEvent(this, 200, disposedNodes));
    }

    protected void handleModelAllChildNodesDeleted(TreeEvent event) {
        JSONObject jsonEvent = new JSONObject();
        this.putProperty(jsonEvent, PROP_COMMON_PARENT_NODE_ID, this.getNodeId(event.getCommonParentNode()));
        this.addActionEvent(EVENT_ALL_CHILD_NODES_DELETED, jsonEvent);
        for (ITreeNode node : event.getChildNodes()) {
            this.unlinkFromParentNode(node);
        }
        HashSet<ITreeNode> disposedNodes = new HashSet<ITreeNode>();
        this.disposeNodes(event.getChildNodes(), true, disposedNodes);
        this.m_listeners.fireEvent(new JsonTreeEvent(this, 200, disposedNodes));
    }

    protected void handleModelNodesSelected(Collection<ITreeNode> modelNodes) {
        JSONArray jsonNodeIds = this.nodeIdsToJson(modelNodes, true, false);
        JSONObject jsonEvent = new JSONObject();
        this.putProperty(jsonEvent, PROP_NODE_IDS, jsonNodeIds);
        this.addActionEvent(EVENT_NODES_SELECTED, jsonEvent);
    }

    protected void handleModelNodesChecked(Collection<ITreeNode> modelNodes) {
        JSONArray jsonNodes = new JSONArray();
        for (ITreeNode node : modelNodes) {
            this.addJsonNodesChecked(jsonNodes, node);
        }
        if (jsonNodes.length() == 0) {
            return;
        }
        JSONObject jsonEvent = new JSONObject();
        this.putProperty(jsonEvent, PROP_NODES, jsonNodes);
        this.addActionEvent(EVENT_NODES_CHECKED, jsonEvent);
    }

    protected void addJsonNodesChecked(JSONArray jsonNodes, ITreeNode node) {
        if (!this.isNodeAccepted(node)) {
            return;
        }
        String nodeId = this.optNodeId(node);
        if (nodeId == null) {
            return;
        }
        jsonNodes.put((Object)this.nodeCheckedToJson(nodeId, node));
    }

    protected JSONObject nodeCheckedToJson(String nodeId, ITreeNode node) {
        JSONObject json = new JSONObject();
        this.putProperty(json, "id", nodeId);
        this.putProperty(json, "checked", node.isChecked());
        return json;
    }

    protected Collection<ITreeNode> collectChildNodesCheckedRec(ITreeNode node) {
        P_ChildNodesVisitor visitor = new P_ChildNodesVisitor();
        TreeUtility.visitNodes((Collection)node.getChildNodes(), (IDepthFirstTreeVisitor)visitor);
        return visitor.getNodes();
    }

    protected void handleModelNodeChanged(ITreeNode modelNode) {
        if (!this.isNodeAccepted(modelNode)) {
            return;
        }
        String nodeId = this.optNodeId(modelNode);
        if (nodeId == null) {
            return;
        }
        JSONObject jsonEvent = new JSONObject();
        this.putProperty(jsonEvent, PROP_NODE_ID, nodeId);
        this.putCellProperties(jsonEvent, modelNode);
        this.addActionEvent(EVENT_NODE_CHANGED, jsonEvent);
    }

    protected void handleModelChildNodeOrderChanged(TreeEvent event) {
        JSONObject jsonEvent = new JSONObject();
        jsonEvent.put("parentNodeId", (Object)this.getNodeId(event.getCommonParentNode()));
        boolean hasNodeIds = false;
        for (ITreeNode childNode : event.getChildNodes()) {
            String childNodeId;
            if (!this.isNodeAccepted(childNode) || (childNodeId = this.optNodeId(childNode)) == null) continue;
            jsonEvent.append("childNodeIds", (Object)childNodeId);
            hasNodeIds = true;
        }
        if (hasNodeIds) {
            this.addActionEvent(EVENT_CHILD_NODE_ORDER_CHANGED, jsonEvent);
        }
    }

    protected void handleModelRequestFocus(TreeEvent event) {
        this.addActionEvent(EVENT_REQUEST_FOCUS).protect();
    }

    protected void handleModelScrollToSelection(TreeEvent event) {
        this.addActionEvent(EVENT_SCROLL_TO_SELECTION).protect();
    }

    @Override
    public void handleModelContextMenuChanged(FilteredJsonAdapterIds<?> filteredAdapters) {
        this.addPropertyChangeEvent("menus", filteredAdapters);
    }

    @Override
    public void consumeBinaryResource(List<BinaryResource> binaryResources, Map<String, String> uploadProperties) {
        if ((((ITree)this.getModel()).getDropType() & 1) == 1) {
            String nodeId;
            ResourceListTransferObject transferObject = new ResourceListTransferObject(binaryResources);
            ITreeNode node = null;
            if (uploadProperties != null && uploadProperties.containsKey(PROP_NODE_ID) && !StringUtility.isNullOrEmpty((CharSequence)(nodeId = uploadProperties.get(PROP_NODE_ID)))) {
                node = this.getTreeNodeForNodeId(nodeId);
            }
            ((ITree)this.getModel()).getUIFacade().fireNodeDropActionFromUI(node, (TransferObject)transferObject);
        }
    }

    @Override
    public long getMaximumUploadSize() {
        return ((ITree)this.getModel()).getDropMaximumSize();
    }

    protected JSONArray nodeIdsToJson(Collection<ITreeNode> modelNodes, boolean autoCreateNodeId) {
        return this.nodeIdsToJson(modelNodes, true, autoCreateNodeId);
    }

    protected JSONArray nodeIdsToJson(Collection<ITreeNode> modelNodes, boolean checkNodeAccepted, boolean autoCreateNodeId) {
        JSONArray jsonNodeIds = new JSONArray();
        for (ITreeNode node : modelNodes) {
            String nodeId;
            if (checkNodeAccepted && !this.isNodeAccepted(node)) continue;
            if (autoCreateNodeId) {
                nodeId = this.getOrCreateNodeId(node);
            } else {
                nodeId = this.optNodeId(node);
                if (nodeId == null) continue;
            }
            if (nodeId == null) continue;
            jsonNodeIds.put((Object)nodeId);
        }
        return jsonNodeIds;
    }

    public String getOrCreateNodeId(ITreeNode node) {
        if (node == null) {
            return null;
        }
        if (this.isInvisibleRootNode(node)) {
            return null;
        }
        String id = this.m_treeNodeIds.get(node);
        if (id != null) {
            return id;
        }
        id = this.getUiSession().createUniqueId();
        this.m_treeNodes.put(id, node);
        this.m_treeNodeIds.put(node, id);
        return id;
    }

    public String getNodeId(ITreeNode node) {
        if (node == null) {
            return null;
        }
        if (this.isInvisibleRootNode(node)) {
            return null;
        }
        String nodeId = this.m_treeNodeIds.get(node);
        if (nodeId == null) {
            throw new UiException("Unknown node: " + String.valueOf(node));
        }
        return nodeId;
    }

    public String optNodeId(ITreeNode node) {
        if (node == null) {
            return null;
        }
        if (this.isInvisibleRootNode(node)) {
            return null;
        }
        return this.m_treeNodeIds.get(node);
    }

    protected boolean isInvisibleRootNode(ITreeNode node) {
        if (!((ITree)this.getModel()).isRootNodeVisible()) {
            return node == ((ITree)this.getModel()).getRootNode();
        }
        return false;
    }

    protected List<ITreeNode> getTopLevelNodes() {
        ITreeNode rootNode = ((ITree)this.getModel()).getRootNode();
        if (((ITree)this.getModel()).isRootNodeVisible()) {
            return CollectionUtility.arrayList((Object)rootNode);
        }
        return rootNode.getChildNodes();
    }

    protected void putCellProperties(JSONObject json, ITreeNode node) {
        ICell cell = node.getCell();
        json.put("text", (Object)cell.getText());
        json.put("iconId", (Object)BinaryResourceUrlUtility.createIconUrl(cell.getIconId()));
        json.put("cssClass", (Object)cell.getCssClass());
        json.put("tooltipText", (Object)cell.getTooltipText());
        json.put("foregroundColor", (Object)cell.getForegroundColor());
        json.put("backgroundColor", (Object)cell.getBackgroundColor());
        json.put("font", cell.getFont() == null ? null : cell.getFont().toPattern());
        json.put("htmlEnabled", cell.isHtmlEnabled());
    }

    protected void putChildNodeIndex(JSONObject json, ITreeNode node, IChildNodeIndexLookup childIndexes) {
        int childNodeIndex = childIndexes.childNodeIndexOf(node);
        if (childNodeIndex >= 0) {
            this.putProperty(json, "childNodeIndex", childNodeIndex);
        }
    }

    protected JSONArray treeNodesToJson(Collection<ITreeNode> nodes, IChildNodeIndexLookup childIndexes) {
        return this.treeNodesToJson(nodes, childIndexes, new HashSet<ITreeNode>());
    }

    protected JSONArray treeNodesToJson(Collection<ITreeNode> nodes, IChildNodeIndexLookup childIndexes, Set<ITreeNode> acceptedNodes) {
        nodes = this.getChildrenIfInvisibleRootNode(nodes);
        JSONArray jsonNodes = new JSONArray();
        for (ITreeNode node : nodes) {
            if (!this.isNodeAccepted(node)) continue;
            jsonNodes.put((Object)this.treeNodeToJson(node, childIndexes, acceptedNodes));
            acceptedNodes.add(node);
        }
        return jsonNodes;
    }

    protected Collection<ITreeNode> getChildrenIfInvisibleRootNode(Collection<ITreeNode> nodes) {
        if (nodes.size() != 1) {
            return nodes;
        }
        ITreeNode node = nodes.stream().findFirst().get();
        if (this.isInvisibleRootNode(node)) {
            nodes = node.getChildNodes();
        }
        return nodes;
    }

    protected JSONObject treeNodeToJson(ITreeNode node, IChildNodeIndexLookup childIndexes, Set<ITreeNode> acceptedNodes) {
        JSONObject json = new JSONObject();
        this.putProperty(json, "id", this.getOrCreateNodeId(node));
        this.putProperty(json, PROP_EXPANDED, node.isExpanded());
        this.putProperty(json, PROP_EXPANDED_LAZY, node.isExpandedLazy());
        this.putProperty(json, "lazyExpandingEnabled", node.isLazyExpandingEnabled());
        this.putProperty(json, "leaf", node.isLeaf());
        this.putProperty(json, "checked", node.isChecked());
        this.putProperty(json, "enabled", node.isEnabled());
        this.putProperty(json, "iconId", BinaryResourceUrlUtility.createIconUrl(node.getCell().getIconId()));
        this.putProperty(json, "initialExpanded", node.isInitialExpanded());
        this.putChildNodeIndex(json, node, childIndexes);
        this.putCellProperties(json, node);
        JSONArray jsonChildNodes = new JSONArray();
        if (node.getChildNodeCount() > 0) {
            for (ITreeNode childNode : node.getChildNodes()) {
                if (!this.isNodeAccepted(childNode)) continue;
                acceptedNodes.add(childNode);
                jsonChildNodes.put((Object)this.treeNodeToJson(childNode, childIndexes, acceptedNodes));
            }
        }
        this.putProperty(json, "childNodes", jsonChildNodes);
        JsonObjectUtility.filterDefaultValues(json, "TreeNode");
        return json;
    }

    public ITreeNode optTreeNodeForNodeId(String nodeId) {
        return this.m_treeNodes.get(nodeId);
    }

    public ITreeNode getTreeNodeForNodeId(String nodeId) {
        ITreeNode node = this.optTreeNodeForNodeId(nodeId);
        if (node == null) {
            throw new UiException("No node found for id " + nodeId);
        }
        return node;
    }

    public List<ITreeNode> extractTreeNodes(JSONObject json) {
        JSONArray nodeIds = json.getJSONArray(PROP_NODE_IDS);
        return this.extractTreeNodes(nodeIds);
    }

    public List<ITreeNode> extractTreeNodes(JSONArray nodeIds) {
        ArrayList<ITreeNode> nodes = new ArrayList<ITreeNode>(nodeIds.length());
        int i = 0;
        while (i < nodeIds.length()) {
            ITreeNode node = this.optTreeNodeForNodeId(nodeIds.getString(i));
            if (node != null) {
                nodes.add(node);
            }
            ++i;
        }
        return nodes;
    }

    @Override
    public void handleUiEvent(JsonEvent event) {
        if (EVENT_NODE_CLICK.equals(event.getType())) {
            this.handleUiNodeClick(event);
        } else if (EVENT_NODE_ACTION.equals(event.getType())) {
            this.handleUiNodeAction(event);
        } else if (EVENT_NODES_SELECTED.equals(event.getType())) {
            this.handleUiNodesSelected(event);
        } else if (EVENT_NODE_EXPANDED.equals(event.getType())) {
            this.handleUiNodeExpanded(event);
        } else if (EVENT_NODES_CHECKED.equals(event.getType())) {
            this.handleUiNodesChecked(event);
        } else {
            super.handleUiEvent(event);
        }
    }

    protected void handleUiNodesChecked(JsonEvent event) {
        CheckedInfo checkedInfo = this.jsonToCheckedInfo(event.getData());
        this.addTreeEventFilterCondition(870).setCheckedNodes(checkedInfo.getCheckedNodes(), checkedInfo.getUncheckedNodes());
        if (!checkedInfo.getCheckedNodes().isEmpty()) {
            ((ITree)this.getModel()).getUIFacade().setNodesCheckedFromUI(checkedInfo.getCheckedNodes(), true);
        }
        if (!checkedInfo.getUncheckedNodes().isEmpty()) {
            ((ITree)this.getModel()).getUIFacade().setNodesCheckedFromUI(checkedInfo.getUncheckedNodes(), false);
        }
    }

    protected void handleUiNodeClick(JsonEvent event) {
        String nodeId = event.getData().getString(PROP_NODE_ID);
        ITreeNode node = this.optTreeNodeForNodeId(nodeId);
        if (node == null) {
            LOG.info("Requested tree-node with ID {} doesn't exist. Skip nodeClicked event", (Object)nodeId);
            return;
        }
        ((ITree)this.getModel()).getUIFacade().fireNodeClickFromUI(node, MouseButton.Left);
    }

    protected void handleUiNodeAction(JsonEvent event) {
        String nodeId = event.getData().getString(PROP_NODE_ID);
        ITreeNode node = this.optTreeNodeForNodeId(nodeId);
        if (node == null) {
            LOG.info("Requested tree-node with ID {} doesn't exist. Skip nodeAction event", (Object)nodeId);
            return;
        }
        ((ITree)this.getModel()).getUIFacade().fireNodeActionFromUI(node);
    }

    protected void handleUiNodesSelected(JsonEvent event) {
        JSONArray nodeIds = event.getData().getJSONArray(PROP_NODE_IDS);
        List<ITreeNode> nodes = this.extractTreeNodes(nodeIds);
        if (nodes.isEmpty() && nodeIds.length() > 0) {
            return;
        }
        if (nodes.size() == nodeIds.length()) {
            this.addTreeEventFilterCondition(40).setNodes(nodes);
        }
        ((ITree)this.getModel()).getUIFacade().setNodesSelectedFromUI(nodes);
    }

    protected void handleUiNodeExpanded(JsonEvent event) {
        String nodeId = event.getData().getString(PROP_NODE_ID);
        ITreeNode node = this.optTreeNodeForNodeId(nodeId);
        if (node == null) {
            LOG.info("Requested tree-node with ID {} doesn't exist. Skip nodeExpanded event", (Object)nodeId);
            return;
        }
        boolean expanded = event.getData().getBoolean(PROP_EXPANDED);
        boolean lazy = event.getData().getBoolean(PROP_EXPANDED_LAZY);
        int eventType = expanded ? 100 : 101;
        this.addTreeEventFilterCondition(eventType).setNodes(CollectionUtility.arrayList((Object)node));
        ((ITree)this.getModel()).getUIFacade().setNodeExpandedFromUI(node, expanded, lazy);
    }

    @Override
    protected void handleUiPropertyChange(String propertyName, JSONObject data) {
        if ("displayStyle".equals(propertyName)) {
            String displayStyle = data.getString(propertyName);
            this.addPropertyEventFilterCondition(propertyName, displayStyle);
            ((ITree)this.getModel()).getUIFacade().setDisplayStyleFromUI(displayStyle);
        } else {
            super.handleUiPropertyChange(propertyName, data);
        }
    }

    public boolean isNodeAccepted(ITreeNode node) {
        if (this.isInvisibleRootNode(node)) {
            return false;
        }
        if (node.isStatusDeleted()) {
            return false;
        }
        if (node.isFilterAccepted()) {
            return true;
        }
        return node.isRejectedByUser();
    }

    protected int getFilteredNodeCount(ITreeNode parentNode) {
        if (((ITree)this.getModel()).getNodeFilters().isEmpty()) {
            return parentNode.getChildNodeCount();
        }
        int filteredNodeCount = 0;
        for (ITreeNode node : parentNode.getChildNodes()) {
            if (!node.isFilterAccepted() && !node.isRejectedByUser()) continue;
            ++filteredNodeCount;
        }
        return filteredNodeCount;
    }

    protected AbstractEventBuffer<TreeEvent> eventBuffer() {
        return this.m_eventBuffer;
    }

    protected final TreeEventFilter getTreeEventFilter() {
        return this.m_treeEventFilter;
    }

    protected TreeEventFilterCondition addTreeEventFilterCondition(int treeEventType) {
        TreeEventFilterCondition condition = new TreeEventFilterCondition(treeEventType);
        this.m_treeEventFilter.addCondition(condition);
        return condition;
    }

    @Override
    public void cleanUpEventFilters() {
        super.cleanUpEventFilters();
        this.m_treeEventFilter.removeAllConditions();
    }

    protected CheckedInfo jsonToCheckedInfo(JSONObject data) {
        JSONArray jsonNodes = data.optJSONArray(PROP_NODES);
        CheckedInfo checkInfo = new CheckedInfo();
        int i = 0;
        while (i < jsonNodes.length()) {
            JSONObject jsonObject = jsonNodes.optJSONObject(i);
            ITreeNode row = this.m_treeNodes.get(jsonObject.getString(PROP_NODE_ID));
            checkInfo.getAllNodes().add(row);
            if (jsonObject.optBoolean("checked")) {
                checkInfo.getCheckedNodes().add(row);
            } else {
                checkInfo.getUncheckedNodes().add(row);
            }
            ++i;
        }
        return checkInfo;
    }

    public JsonTreeListeners listeners() {
        return this.m_listeners;
    }

    public void addListener(JsonTreeListener listener, Integer ... eventTypes) {
        this.listeners().add(listener, false, eventTypes);
    }

    public void removeListener(JsonTreeListener listener, Integer ... eventTypes) {
        this.listeners().remove(listener, eventTypes);
    }

    protected static class CheckedInfo {
        private final List<ITreeNode> m_allNodes = new ArrayList<ITreeNode>();
        private final List<ITreeNode> m_checkedNodes = new ArrayList<ITreeNode>();
        private final List<ITreeNode> m_uncheckedNodes = new ArrayList<ITreeNode>();

        protected CheckedInfo() {
        }

        public List<ITreeNode> getAllNodes() {
            return this.m_allNodes;
        }

        public List<ITreeNode> getCheckedNodes() {
            return this.m_checkedNodes;
        }

        public List<ITreeNode> getUncheckedNodes() {
            return this.m_uncheckedNodes;
        }
    }

    protected class P_ChildNodesVisitor
    extends DepthFirstTreeVisitor<ITreeNode> {
        private final Set<ITreeNode> m_nodes = new HashSet<ITreeNode>();

        protected P_ChildNodesVisitor() {
        }

        public TreeVisitResult preVisit(ITreeNode node, int level, int index) {
            this.m_nodes.add(node);
            return TreeVisitResult.CONTINUE;
        }

        public Set<ITreeNode> getNodes() {
            return this.m_nodes;
        }
    }

    protected class P_TreeListener
    extends TreeAdapter {
        protected P_TreeListener() {
        }

        public void treeChanged(TreeEvent e) {
            ModelJobs.assertModelThread();
            JsonTree.this.handleModelTreeEvent(e);
        }
    }
}

