/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.tile;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.client.ui.MouseButton;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.ITileGridContextMenu;
import org.eclipse.scout.rt.client.ui.form.fields.LogicalGridLayoutConfig;
import org.eclipse.scout.rt.client.ui.tile.ITile;
import org.eclipse.scout.rt.client.ui.tile.ITileGrid;
import org.eclipse.scout.rt.client.ui.tile.TileGridLayoutConfig;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.AbstractJsonWidget;
import org.eclipse.scout.rt.ui.html.json.FilteredJsonAdapterIds;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterProperty;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterPropertyConfig;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterPropertyConfigBuilder;
import org.eclipse.scout.rt.ui.html.json.menu.IJsonContextMenuOwner;
import org.eclipse.scout.rt.ui.html.json.menu.JsonContextMenu;
import org.eclipse.scout.rt.ui.html.json.tile.JsonTileGridLayoutConfig;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonTileGrid<T extends ITileGrid<? extends ITile>>
extends AbstractJsonWidget<T>
implements IJsonContextMenuOwner {
    private static final Logger LOG = LoggerFactory.getLogger(JsonTileGrid.class);
    public static final String EVENT_TILE_CLICK = "tileClick";
    public static final String EVENT_TILE_ACTION = "tileAction";
    private JsonContextMenu<IContextMenu> m_jsonContextMenu;

    public JsonTileGrid(T model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "TileGrid";
    }

    @Override
    protected void attachChildAdapters() {
        super.attachChildAdapters();
        this.m_jsonContextMenu = new JsonContextMenu<ITileGridContextMenu>(((ITileGrid)this.getModel()).getContextMenu(), this);
        this.m_jsonContextMenu.init();
    }

    @Override
    protected void disposeChildAdapters() {
        this.getJsonContextMenu().dispose();
        super.disposeChildAdapters();
    }

    @Override
    protected void initJsonProperties(T model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonAdapterProperty<T>("tiles", (ITileGrid)model, this.getUiSession()){

            @Override
            protected List<? extends ITile> modelValue() {
                return ((ITileGrid)this.getModel()).getTiles();
            }
        });
        this.putJsonProperty(new JsonAdapterProperty<T>("selectedTiles", (ITileGrid)model, this.getUiSession()){

            @Override
            protected List<? extends ITile> modelValue() {
                return ((ITileGrid)this.getModel()).getSelectedTiles();
            }

            @Override
            protected JsonAdapterPropertyConfig createConfig() {
                return new JsonAdapterPropertyConfigBuilder().disposeOnChange(false).build();
            }
        });
        this.putJsonProperty(new JsonAdapterProperty<T>("filteredTiles", (ITileGrid)model, this.getUiSession()){

            @Override
            protected List<? extends ITile> modelValue() {
                return ((ITileGrid)this.getModel()).getFilteredTiles();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                if (((ITileGrid)this.getModel()).getFilters().size() == 0) {
                    return null;
                }
                return super.prepareValueForToJson(value);
            }

            @Override
            protected JsonAdapterPropertyConfig createConfig() {
                return new JsonAdapterPropertyConfigBuilder().disposeOnChange(false).build();
            }
        });
        this.putJsonProperty(new JsonProperty<ITileGrid>("gridColumnCount", model){

            @Override
            protected Integer modelValue() {
                return ((ITileGrid)this.getModel()).getGridColumnCount();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("selectable", (ITileGrid)model){

            @Override
            protected Boolean modelValue() {
                return ((ITileGrid)this.getModel()).isSelectable();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("multiSelect", (ITileGrid)model){

            @Override
            protected Boolean modelValue() {
                return ((ITileGrid)this.getModel()).isMultiSelect();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("withPlaceholders", (ITileGrid)model){

            @Override
            protected Boolean modelValue() {
                return ((ITileGrid)this.getModel()).isWithPlaceholders();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("scrollable", (ITileGrid)model){

            @Override
            protected Boolean modelValue() {
                return ((ITileGrid)this.getModel()).isScrollable();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("logicalGrid", (ITileGrid)model){

            @Override
            protected String modelValue() {
                return ((ITileGrid)this.getModel()).getLogicalGrid();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("layoutConfig", (ITileGrid)model){

            protected TileGridLayoutConfig modelValue() {
                return ((ITileGrid)this.getModel()).getLayoutConfig();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return new JsonTileGridLayoutConfig((LogicalGridLayoutConfig)((TileGridLayoutConfig)value)).toJson();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("virtual", (ITileGrid)model){

            @Override
            protected Boolean modelValue() {
                return ((ITileGrid)this.getModel()).isVirtual();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("animateTileRemoval", (ITileGrid)model){

            @Override
            protected Boolean modelValue() {
                return ((ITileGrid)this.getModel()).isAnimateTileRemoval();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("animateTileInsertion", (ITileGrid)model){

            @Override
            protected Boolean modelValue() {
                return ((ITileGrid)this.getModel()).isAnimateTileInsertion();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("textFilterEnabled", (ITileGrid)model){

            @Override
            protected Boolean modelValue() {
                return ((ITileGrid)this.getModel()).isTextFilterEnabled();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("wrappable", (ITileGrid)model){

            @Override
            protected Boolean modelValue() {
                return ((ITileGrid)this.getModel()).isWrappable();
            }
        });
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        json.put("menus", (Object)this.getJsonContextMenu().childActionsToJson());
        return json;
    }

    @Override
    public void handleUiEvent(JsonEvent event) {
        if (EVENT_TILE_CLICK.equals(event.getType())) {
            this.handleUiTileClick(event);
        } else if (EVENT_TILE_ACTION.equals(event.getType())) {
            this.handleUiTileAction(event);
        } else {
            super.handleUiEvent(event);
        }
    }

    @Override
    protected void handleUiPropertyChange(String propertyName, JSONObject data) {
        if ("selectedTiles".equals(propertyName)) {
            this.handleUiSelectedTiles(data);
        } else {
            super.handleUiPropertyChange(propertyName, data);
        }
    }

    protected void handleUiSelectedTiles(JSONObject data) {
        JSONArray tileIds = data.getJSONArray("selectedTiles");
        List<ITile> tiles = this.extractTiles(tileIds);
        if (tiles.isEmpty() && tileIds.length() > 0) {
            return;
        }
        if (tiles.size() == tileIds.length()) {
            this.addPropertyEventFilterCondition("selectedTiles", tiles);
        }
        ((ITileGrid)this.getModel()).getUIFacade().setSelectedTilesFromUI(tiles);
    }

    protected List<ITile> extractTiles(JSONArray tileIds) {
        ArrayList<ITile> tiles = new ArrayList<ITile>(tileIds.length());
        int i = 0;
        while (i < tileIds.length()) {
            ITile tile = this.optTile(tileIds.getString(i));
            if (tile != null) {
                tiles.add(tile);
            }
            ++i;
        }
        return tiles;
    }

    protected void handleUiTileClick(JsonEvent event) {
        ITile tile = this.extractTile(event.getData());
        if (tile == null) {
            LOG.info("Requested tile doesn't exist anymore -> skip tileClick event");
            return;
        }
        MouseButton mouseButton = this.extractMouseButton(event.getData());
        ((ITileGrid)this.getModel()).getUIFacade().handleTileClickFromUI(tile, mouseButton);
    }

    protected MouseButton extractMouseButton(JSONObject json) {
        int mouseButton = json.getInt("mouseButton");
        switch (mouseButton) {
            case 1: {
                return MouseButton.Left;
            }
            case 3: {
                return MouseButton.Right;
            }
        }
        return MouseButton.Unknown;
    }

    protected void handleUiTileAction(JsonEvent event) {
        ITile tile = this.extractTile(event.getData());
        if (tile == null) {
            LOG.info("Requested tile doesn't exist anymore -> skip tileAction event");
            return;
        }
        ((ITileGrid)this.getModel()).getUIFacade().handleTileActionFromUI(tile);
    }

    protected ITile extractTile(JSONObject json) {
        return this.optTile(json.getString("tile"));
    }

    protected ITile getTile(String tileId) {
        Object model = this.getUiSession().getJsonAdapter(tileId).getModel();
        if (!(model instanceof ITile)) {
            throw new IllegalStateException("Id does not belong to a tile. Id: " + tileId);
        }
        return (ITile)model;
    }

    protected ITile optTile(String tileId) {
        IJsonAdapter<?> adapter = this.getUiSession().getJsonAdapter(tileId);
        if (adapter == null) {
            return null;
        }
        Object model = adapter.getModel();
        if (model == null) {
            return null;
        }
        if (!(model instanceof ITile)) {
            throw new IllegalStateException("Id does not belong to a tile. Id: " + tileId);
        }
        return (ITile)model;
    }

    @Override
    public void handleModelContextMenuChanged(FilteredJsonAdapterIds<?> filteredAdapters) {
        this.addPropertyChangeEvent("menus", filteredAdapters);
    }

    public JsonContextMenu<IContextMenu> getJsonContextMenu() {
        return this.m_jsonContextMenu;
    }
}

