/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.table.userfilter;

import java.math.BigDecimal;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.userfilter.ColumnUserFilterState;
import org.eclipse.scout.rt.client.ui.basic.table.userfilter.NumberColumnUserFilterState;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.ui.html.json.table.userfilter.JsonColumnUserFilter;
import org.json.JSONObject;

public class JsonNumberColumnUserFilter
extends JsonColumnUserFilter<NumberColumnUserFilterState> {
    public JsonNumberColumnUserFilter(NumberColumnUserFilterState filterState) {
        super(filterState);
    }

    @Override
    public String getObjectType() {
        return "NumberColumnUserFilter";
    }

    protected String bigDecimalToJson(BigDecimal number) {
        if (number == null) {
            return null;
        }
        return number.toString();
    }

    protected BigDecimal toBigDecimal(String numberString) {
        if (StringUtility.isNullOrEmpty((CharSequence)numberString)) {
            return null;
        }
        return new BigDecimal(numberString);
    }

    @Override
    public ColumnUserFilterState createFilterStateFromJson(IColumn<?> column, JSONObject json) {
        NumberColumnUserFilterState filterState = new NumberColumnUserFilterState(column);
        filterState.setSelectedValues(this.createSelectedValuesFromJson(json));
        filterState.setNumberFrom(this.toBigDecimal(json.optString("numberFrom")));
        filterState.setNumberTo(this.toBigDecimal(json.optString("numberTo")));
        return filterState;
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        json.put("numberFrom", (Object)this.bigDecimalToJson(((NumberColumnUserFilterState)this.getFilterState()).getNumberFrom()));
        json.put("numberTo", (Object)this.bigDecimalToJson(((NumberColumnUserFilterState)this.getFilterState()).getNumberTo()));
        return json;
    }
}

