/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.table.userfilter;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.userfilter.ColumnUserFilterState;
import org.eclipse.scout.rt.ui.html.json.table.userfilter.JsonTableUserFilter;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonColumnUserFilter<T extends ColumnUserFilterState>
extends JsonTableUserFilter<T> {
    public JsonColumnUserFilter(T filter) {
        super(filter);
    }

    @Override
    public String getObjectType() {
        return "ColumnUserFilter";
    }

    @Override
    public boolean isValid() {
        return this.getJsonTable().getColumnId(((ColumnUserFilterState)this.getFilterState()).getColumn()) != null;
    }

    public ColumnUserFilterState createFilterStateFromJson(IColumn<?> column, JSONObject json) {
        ColumnUserFilterState filterState = new ColumnUserFilterState(column);
        filterState.setSelectedValues(this.createSelectedValuesFromJson(json));
        return filterState;
    }

    protected Set<Object> createSelectedValuesFromJson(JSONObject json) {
        JSONArray jsonSelectedValues = json.getJSONArray("selectedValues");
        HashSet<Object> selectedValues = new HashSet<Object>();
        int i = 0;
        while (i < jsonSelectedValues.length()) {
            if (jsonSelectedValues.isNull(i)) {
                selectedValues.add(null);
            } else {
                selectedValues.add(jsonSelectedValues.get(i));
            }
            ++i;
        }
        return selectedValues;
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        ColumnUserFilterState filterState = (ColumnUserFilterState)this.getFilterState();
        IColumn modelColumn = filterState.getColumn();
        json.put("column", (Object)this.getJsonTable().getColumnId(modelColumn));
        json.put("selectedValues", (Object)new JSONArray((Collection)filterState.getSelectedValues()));
        return json;
    }

    public String toString() {
        return this.getObjectType() + ", " + String.valueOf(((ColumnUserFilterState)this.getFilterState()).getColumn());
    }
}

