/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.table;

import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.ui.html.json.basic.cell.ICellValueReader;
import org.eclipse.scout.rt.ui.html.json.table.JsonColumn;
import org.json.JSONObject;

public class TableCellValueReader
implements ICellValueReader {
    private final JsonColumn<?> m_jsonColumn;
    private final ICell m_cell;

    public TableCellValueReader(JsonColumn<?> jsonColumn, ICell cell) {
        if (jsonColumn == null) {
            throw new IllegalArgumentException("Argument 'jsonColumn' must not be null");
        }
        if (cell == null) {
            throw new IllegalArgumentException("Argument 'cell' must not be null");
        }
        this.m_jsonColumn = jsonColumn;
        this.m_cell = cell;
    }

    @Override
    public Object read() {
        Object cellValue = this.m_jsonColumn.cellValueToJson(this.m_cell.getValue());
        if (cellValue == null && this.m_jsonColumn.isValueRequired()) {
            return JSONObject.NULL;
        }
        if (cellValue != null && !String.valueOf(cellValue).equals(this.m_cell.getText())) {
            return cellValue;
        }
        return null;
    }
}

