/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.table;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.client.context.ClientRunContext;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.services.common.clipboard.IClipboardService;
import org.eclipse.scout.rt.client.ui.AbstractEventBuffer;
import org.eclipse.scout.rt.client.ui.IEventHistory;
import org.eclipse.scout.rt.client.ui.IModelEvent;
import org.eclipse.scout.rt.client.ui.MouseButton;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.ITableContextMenu;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.CheckableStyle;
import org.eclipse.scout.rt.client.ui.basic.table.GroupingStyle;
import org.eclipse.scout.rt.client.ui.basic.table.HierarchicalStyle;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.ITableTileGridMediator;
import org.eclipse.scout.rt.client.ui.basic.table.ITableUIFacade;
import org.eclipse.scout.rt.client.ui.basic.table.ITileTableHeader;
import org.eclipse.scout.rt.client.ui.basic.table.TableAdapter;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.TableListener;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.INumberColumn;
import org.eclipse.scout.rt.client.ui.basic.table.controls.ITableControl;
import org.eclipse.scout.rt.client.ui.basic.userfilter.IUserFilterState;
import org.eclipse.scout.rt.client.ui.dnd.ResourceListTransferObject;
import org.eclipse.scout.rt.client.ui.dnd.TextTransferObject;
import org.eclipse.scout.rt.client.ui.dnd.TransferObject;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.security.ACCESS;
import org.eclipse.scout.rt.shared.security.CopyToClipboardPermission;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.UiException;
import org.eclipse.scout.rt.ui.html.json.AbstractJsonWidget;
import org.eclipse.scout.rt.ui.html.json.FilteredJsonAdapterIds;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonEventType;
import org.eclipse.scout.rt.ui.html.json.JsonObjectUtility;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.JsonStatus;
import org.eclipse.scout.rt.ui.html.json.MainJsonObjectFactory;
import org.eclipse.scout.rt.ui.html.json.action.DisplayableActionFilter;
import org.eclipse.scout.rt.ui.html.json.basic.cell.JsonCell;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterProperty;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterPropertyConfig;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterPropertyConfigBuilder;
import org.eclipse.scout.rt.ui.html.json.menu.IJsonContextMenuOwner;
import org.eclipse.scout.rt.ui.html.json.menu.JsonContextMenu;
import org.eclipse.scout.rt.ui.html.json.table.JsonColumn;
import org.eclipse.scout.rt.ui.html.json.table.JsonTableEvent;
import org.eclipse.scout.rt.ui.html.json.table.JsonTableListener;
import org.eclipse.scout.rt.ui.html.json.table.JsonTableListeners;
import org.eclipse.scout.rt.ui.html.json.table.TableEventFilter;
import org.eclipse.scout.rt.ui.html.json.table.TableEventFilterCondition;
import org.eclipse.scout.rt.ui.html.json.table.userfilter.IUserFilterStateFactory;
import org.eclipse.scout.rt.ui.html.json.table.userfilter.JsonTableUserFilter;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceHolder;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceMediator;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceUrlUtility;
import org.eclipse.scout.rt.ui.html.res.IBinaryResourceConsumer;
import org.eclipse.scout.rt.ui.html.res.IBinaryResourceProvider;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonTable<T extends ITable>
extends AbstractJsonWidget<T>
implements IJsonContextMenuOwner,
IBinaryResourceConsumer,
IBinaryResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(JsonTable.class);
    public static final String EVENT_ROW_CLICK = "rowClick";
    public static final String EVENT_ROW_ACTION = "rowAction";
    public static final String EVENT_ROWS_SELECTED = "rowsSelected";
    public static final String EVENT_ROWS_INSERTED = "rowsInserted";
    public static final String EVENT_ROWS_UPDATED = "rowsUpdated";
    public static final String EVENT_ROWS_DELETED = "rowsDeleted";
    public static final String EVENT_ALL_ROWS_DELETED = "allRowsDeleted";
    public static final String EVENT_SORT = "sort";
    public static final String EVENT_GROUP = "group";
    public static final String EVENT_COLUMN_AGGR_FUNC_CHANGED = "aggregationFunctionChanged";
    public static final String EVENT_COLUMN_MOVED = "columnMoved";
    public static final String EVENT_COLUMN_RESIZED = "columnResized";
    public static final String EVENT_RELOAD = "reload";
    public static final String EVENT_RESET_COLUMNS = "resetColumns";
    public static final String EVENT_ROWS_CHECKED = "rowsChecked";
    public static final String EVENT_ROWS_EXPANDED = "rowsExpanded";
    public static final String EVENT_COLUMN_ORDER_CHANGED = "columnOrderChanged";
    public static final String EVENT_COLUMN_STRUCTURE_CHANGED = "columnStructureChanged";
    public static final String EVENT_COLUMN_HEADERS_UPDATED = "columnHeadersUpdated";
    public static final String EVENT_COLUMN_BACKGROUND_EFFECT_CHANGED = "columnBackgroundEffectChanged";
    public static final String EVENT_COLUMN_ORGANIZE_ACTION = "columnOrganizeAction";
    public static final String EVENT_REQUEST_FOCUS_IN_CELL = "requestFocusInCell";
    public static final String EVENT_START_CELL_EDIT = "startCellEdit";
    public static final String EVENT_END_CELL_EDIT = "endCellEdit";
    public static final String EVENT_PREPARE_CELL_EDIT = "prepareCellEdit";
    public static final String EVENT_COMPLETE_CELL_EDIT = "completeCellEdit";
    public static final String EVENT_CANCEL_CELL_EDIT = "cancelCellEdit";
    public static final String EVENT_REQUEST_FOCUS = "requestFocus";
    public static final String EVENT_SCROLL_TO_SELECTION = "scrollToSelection";
    public static final String EVENT_CLIPBOARD_EXPORT = "clipboardExport";
    public static final String EVENT_FILTER_ADDED = "filterAdded";
    public static final String EVENT_FILTER_REMOVED = "filterRemoved";
    public static final String EVENT_FILTERS_CHANGED = "filtersChanged";
    public static final String EVENT_FILTER = "filter";
    public static final String PROP_ROWS = "rows";
    public static final String PROP_ROW_IDS = "rowIds";
    public static final String PROP_ROW_ID = "rowId";
    public static final String PROP_EXPANDED = "expanded";
    public static final String PROP_COLUMN_ID = "columnId";
    public static final String PROP_COLUMN_IDS = "columnIds";
    public static final String PROP_COLUMNS = "columns";
    public static final String PROP_COLUMN_ADDABLE = "columnAddable";
    public static final String PROP_SELECTED_ROWS = "selectedRows";
    public static final String PROP_FILTERS = "filters";
    public static final String PROP_HAS_RELOAD_HANDLER = "hasReloadHandler";
    private TableListener m_tableListener;
    private final Map<String, ITableRow> m_tableRows;
    private final Map<ITableRow, String> m_tableRowIds;
    private final Map<String, IColumn<?>> m_columns;
    private final TableEventFilter m_tableEventFilter;
    private final Map<IColumn<?>, JsonColumn<?>> m_jsonColumns;
    private final AbstractEventBuffer<TableEvent> m_eventBuffer;
    private JsonContextMenu<IContextMenu> m_jsonContextMenu;
    private final BinaryResourceMediator m_binaryResourceMediator;
    private final JsonTableListeners m_listeners = new JsonTableListeners();

    public JsonTable(T model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
        this.m_tableRows = new HashMap<String, ITableRow>();
        this.m_tableRowIds = new HashMap<ITableRow, String>();
        this.m_columns = new HashMap();
        this.m_tableEventFilter = new TableEventFilter(this);
        this.m_jsonColumns = new HashMap();
        this.m_eventBuffer = model.createEventBuffer();
        this.m_binaryResourceMediator = this.createBinaryResourceMediator();
    }

    protected BinaryResourceMediator createBinaryResourceMediator() {
        return new BinaryResourceMediator(this);
    }

    @Override
    public String getObjectType() {
        return "Table";
    }

    public JsonContextMenu<IContextMenu> getJsonContextMenu() {
        return this.m_jsonContextMenu;
    }

    public BinaryResourceMediator getBinaryResourceMediator() {
        return this.m_binaryResourceMediator;
    }

    @Override
    public void init() {
        super.init();
        IEventHistory eventHistory = ((ITable)this.getModel()).getEventHistory();
        if (eventHistory != null) {
            for (TableEvent event : eventHistory.getRecentEvents()) {
                this.processEvent(event);
            }
        }
    }

    @Override
    protected void initJsonProperties(T model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<ITable>("multiSelect", model){

            @Override
            protected Boolean modelValue() {
                return ((ITable)this.getModel()).isMultiSelect();
            }
        });
        this.putJsonProperty(new JsonProperty<ITable>("multiCheck", model){

            @Override
            protected Boolean modelValue() {
                return ((ITable)this.getModel()).isMultiCheck();
            }
        });
        this.putJsonProperty(new JsonProperty<ITable>("multilineText", model){

            @Override
            protected Boolean modelValue() {
                return ((ITable)this.getModel()).isMultilineText();
            }
        });
        this.putJsonProperty(new JsonProperty<ITable>("checkable", model){

            @Override
            protected Boolean modelValue() {
                return ((ITable)this.getModel()).isCheckable();
            }
        });
        this.putJsonProperty(new JsonProperty<ITable>("compact", model){

            @Override
            protected Boolean modelValue() {
                return ((ITable)this.getModel()).isCompact();
            }
        });
        this.putJsonProperty(new JsonProperty<ITable>("rowIconVisible", model){

            @Override
            protected Boolean modelValue() {
                return ((ITable)this.getModel()).isRowIconVisible();
            }
        });
        this.putJsonProperty(new JsonProperty<ITable>("rowIconColumnWidth", model){

            @Override
            protected Integer modelValue() {
                return ((ITable)this.getModel()).getRowIconColumnWidth();
            }
        });
        this.putJsonProperty(new JsonProperty<ITable>("headerVisible", model){

            @Override
            protected Boolean modelValue() {
                return ((ITable)this.getModel()).isHeaderVisible();
            }
        });
        this.putJsonProperty(new JsonProperty<ITable>("headerEnabled", model){

            @Override
            protected Boolean modelValue() {
                return ((ITable)this.getModel()).isHeaderEnabled();
            }
        });
        this.putJsonProperty(new JsonProperty<ITable>("headerMenusEnabled", model){

            @Override
            protected Boolean modelValue() {
                return ((ITable)this.getModel()).isHeaderMenusEnabled();
            }
        });
        this.putJsonProperty(new JsonProperty<ITable>("keyboardNavigation", model){

            @Override
            protected Boolean modelValue() {
                return ((ITable)this.getModel()).hasKeyboardNavigation();
            }
        });
        this.putJsonProperty(new JsonProperty<ITable>("autoResizeColumns", model){

            @Override
            protected Boolean modelValue() {
                return ((ITable)this.getModel()).isAutoResizeColumns();
            }
        });
        this.putJsonProperty(new JsonProperty<ITable>(EVENT_SCROLL_TO_SELECTION, model){

            @Override
            protected Boolean modelValue() {
                return ((ITable)this.getModel()).isScrollToSelection();
            }
        });
        this.putJsonProperty(new JsonProperty<ITable>("tableStatusVisible", model){

            @Override
            protected Boolean modelValue() {
                return ((ITable)this.getModel()).isTableStatusVisible();
            }
        });
        this.putJsonProperty(new JsonProperty<ITable>("tableStatus", model){

            protected IStatus modelValue() {
                return ((ITable)this.getModel()).getTableStatus();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return JsonStatus.toJson((IStatus)value);
            }
        });
        this.putJsonProperty(new JsonAdapterProperty<ITable>("tableControls", model, this.getUiSession()){

            @Override
            protected JsonAdapterPropertyConfig createConfig() {
                return new JsonAdapterPropertyConfigBuilder().filter(new DisplayableActionFilter()).build();
            }

            @Override
            protected List<ITableControl> modelValue() {
                return ((ITable)this.getModel()).getTableControls();
            }
        });
        this.putJsonProperty(new JsonProperty<ITable>("dropType", model){

            @Override
            protected Integer modelValue() {
                return ((ITable)this.getModel()).getDropType();
            }
        });
        this.putJsonProperty(new JsonProperty<ITable>("dropMaximumSize", model){

            @Override
            protected Long modelValue() {
                return ((ITable)this.getModel()).getDropMaximumSize();
            }
        });
        this.putJsonProperty(new JsonProperty<ITable>("sortEnabled", model){

            @Override
            protected Boolean modelValue() {
                return ((ITable)this.getModel()).isSortEnabled();
            }
        });
        this.putJsonProperty(new JsonProperty<ITable>("uiSortPossible", model){

            @Override
            protected Boolean modelValue() {
                return ((ITable)this.getModel()).isUiSortPossible();
            }
        });
        this.putJsonProperty(new JsonProperty<ITable>("loading", model){

            @Override
            protected Boolean modelValue() {
                return ((ITable)this.getModel()).isLoading();
            }
        });
        this.putJsonProperty(new JsonProperty<ITable>("groupingStyle", model){

            protected GroupingStyle modelValue() {
                return ((ITable)this.getModel()).getGroupingStyle();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return ((GroupingStyle)value).name().toLowerCase();
            }
        });
        this.putJsonProperty(new JsonProperty<ITable>("estimatedRowCount", model){

            @Override
            protected Long modelValue() {
                return ((ITable)this.getModel()).getEstimatedRowCount();
            }
        });
        this.putJsonProperty(new JsonProperty<ITable>("maxRowCount", model){

            @Override
            protected Integer modelValue() {
                return ((ITable)this.getModel()).getMaxRowCount();
            }
        });
        this.putJsonProperty(new JsonProperty<ITable>("hierarchicalStyle", model){

            protected HierarchicalStyle modelValue() {
                return ((ITable)this.getModel()).getHierarchicalStyle();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return ((HierarchicalStyle)value).name().toLowerCase();
            }
        });
        this.putJsonProperty(new JsonAdapterProperty<ITable>("keyStrokes", model, this.getUiSession()){

            @Override
            protected JsonAdapterPropertyConfig createConfig() {
                return new JsonAdapterPropertyConfigBuilder().filter(new DisplayableActionFilter()).build();
            }

            @Override
            protected List<IKeyStroke> modelValue() {
                return ((ITable)this.getModel()).getKeyStrokes();
            }
        });
        this.putJsonProperty(new JsonProperty<ITable>("contextColumn", model){

            @Override
            protected Object modelValue() {
                return ((ITable)this.getModel()).getContextColumn();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                if (value == null) {
                    return null;
                }
                JsonColumn<?> jsonColumn = JsonTable.this.m_jsonColumns.get(value);
                if (jsonColumn == null) {
                    JsonTable.this.logContextColumnInconsistency(value);
                    return null;
                }
                return jsonColumn.getId();
            }
        });
        this.putJsonProperty(new JsonProperty<ITable>("checkableStyle", model){

            protected CheckableStyle modelValue() {
                return ((ITable)this.getModel()).getCheckableStyle();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return ((CheckableStyle)value).name().toLowerCase();
            }
        });
        this.putJsonProperty(new JsonProperty<ITable>("truncatedCellTooltipEnabled", model){

            @Override
            protected Boolean modelValue() {
                return ((ITable)this.getModel()).isTruncatedCellTooltipEnabled().getBooleanValue();
            }
        });
        this.putJsonProperty(new JsonProperty<ITable>("tileMode", model){

            @Override
            protected Boolean modelValue() {
                return ((ITable)this.getModel()).isTileMode();
            }
        });
        this.putJsonProperty(new JsonAdapterProperty<ITable>("tileTableHeader", model, this.getUiSession()){

            protected ITileTableHeader modelValue() {
                return ((ITable)this.getModel()).getTileTableHeader();
            }
        });
        this.putJsonProperty(new JsonAdapterProperty<ITable>("tableTileGridMediator", model, this.getUiSession()){

            protected ITableTileGridMediator modelValue() {
                return ((ITable)this.getModel()).getTableTileGridMediator();
            }
        });
        this.putJsonProperty(new JsonProperty<ITable>("textFilterEnabled", model){

            @Override
            protected Boolean modelValue() {
                return ((ITable)this.getModel()).isTextFilterEnabled();
            }
        });
    }

    @Override
    protected void attachChildAdapters() {
        super.attachChildAdapters();
        this.attachColumns();
        this.attachRows();
        this.m_jsonContextMenu = new JsonContextMenu<ITableContextMenu>(((ITable)this.getModel()).getContextMenu(), this);
        this.m_jsonContextMenu.init();
    }

    protected void attachRows() {
        List rows = ((ITable)this.getModel()).getRows();
        for (ITableRow row : rows) {
            if (!this.isRowAccepted(row)) continue;
            this.getOrCreateRowId(row);
        }
    }

    protected void attachColumns() {
        int offset = 0;
        for (IColumn column : ((ITable)this.getModel()).getColumns()) {
            if (!column.isVisible() || column.isCompacted()) {
                ++offset;
                continue;
            }
            String id = this.getUiSession().createUniqueId();
            JsonColumn jsonColumn = (JsonColumn)MainJsonObjectFactory.get().createJsonObject(column);
            jsonColumn.setId(id);
            jsonColumn.setColumnIndexOffset(offset);
            jsonColumn.setJsonTable(this);
            this.m_jsonColumns.put(column, jsonColumn);
            this.m_columns.put(id, column);
        }
    }

    protected void disposeAllColumns() {
        this.m_jsonColumns.clear();
        this.m_columns.clear();
    }

    protected void disposeColumn(IColumn<?> column) {
        JsonColumn<?> jsonColumn = this.m_jsonColumns.get(column);
        this.m_jsonColumns.remove(column);
        if (jsonColumn != null) {
            this.m_columns.remove(jsonColumn.getId());
        }
    }

    protected void disposeColumns(Collection<IColumn<?>> columns) {
        for (IColumn<?> column : columns) {
            this.disposeColumn(column);
        }
    }

    protected void disposeAllRows() {
        this.m_tableRowIds.clear();
        this.m_tableRows.clear();
    }

    protected void disposeRow(ITableRow row) {
        String rowId = this.m_tableRowIds.get(row);
        this.m_tableRowIds.remove(row);
        this.m_tableRows.remove(rowId);
    }

    protected void disposeRows(Collection<ITableRow> rows) {
        for (ITableRow row : rows) {
            this.disposeRow(row);
        }
    }

    @Override
    protected void disposeChildAdapters() {
        if (ModelJobs.isModelThread()) {
            ((ITable)this.getModel()).getUIFacade().cancelCellEditFromUI();
        } else {
            ClientRunContext clientRunContext = ClientRunContexts.copyCurrent((boolean)true).withSession(this.getUiSession().getClientSession(), true);
            ModelJobs.schedule(() -> ((ITableUIFacade)((ITable)this.getModel()).getUIFacade()).cancelCellEditFromUI(), (JobInput)ModelJobs.newInput((ClientRunContext)clientRunContext).withName("Cancelling cell editor", new Object[0]).withExceptionHandling(null, false));
        }
        this.disposeAllColumns();
        this.disposeAllRows();
        this.getJsonContextMenu().dispose();
        super.disposeChildAdapters();
    }

    @Override
    protected void attachModel() {
        super.attachModel();
        if (this.m_tableListener != null) {
            throw new IllegalStateException();
        }
        this.m_tableListener = new P_TableListener();
        ((ITable)this.getModel()).addUITableListener(this.m_tableListener, new Integer[0]);
    }

    @Override
    protected void detachModel() {
        super.detachModel();
        if (this.m_tableListener == null) {
            throw new IllegalStateException();
        }
        ((ITable)this.getModel()).removeTableListener(this.m_tableListener, new Integer[0]);
        this.m_tableListener = null;
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        json.put(PROP_COLUMNS, (Object)this.columnsToJson(this.getColumnsInViewOrder()));
        json.put(PROP_COLUMN_ADDABLE, ((ITable)this.getModel()).getTableOrganizer().isColumnAddable());
        json.put(PROP_ROWS, (Object)this.tableRowsToJson(((ITable)this.getModel()).getRows()));
        json.put("menus", (Object)this.getJsonContextMenu().childActionsToJson());
        json.put(PROP_SELECTED_ROWS, (Object)this.rowIdsToJson(((ITable)this.getModel()).getSelectedRows()));
        if (((ITable)this.getModel()).getUserFilterManager() != null) {
            json.put(PROP_FILTERS, (Object)this.filtersToJson(((ITable)this.getModel()).getUserFilterManager().getFilters()));
        }
        json.put(PROP_HAS_RELOAD_HANDLER, ((ITable)this.getModel()).getReloadHandler() != null);
        return json;
    }

    protected JSONArray tableRowsToJson(Collection<ITableRow> rows) {
        return this.tableRowsToJson(rows, new HashSet<ITableRow>());
    }

    protected JSONArray tableRowsToJson(Collection<ITableRow> rows, Set<ITableRow> acceptedRows) {
        JSONArray jsonRows = new JSONArray();
        for (ITableRow row : rows) {
            if (!this.isRowAccepted(row)) continue;
            jsonRows.put((Object)this.tableRowToJson(row));
            acceptedRows.add(row);
        }
        return jsonRows;
    }

    @Override
    public void handleUiEvent(JsonEvent event) {
        if (EVENT_ROW_CLICK.equals(event.getType())) {
            this.handleUiRowClick(event);
        } else if (EVENT_ROW_ACTION.equals(event.getType())) {
            this.handleUiRowAction(event);
        } else if (EVENT_ROWS_SELECTED.equals(event.getType())) {
            this.handleUiRowsSelected(event);
        } else if (EVENT_RELOAD.equals(event.getType())) {
            this.handleUiReload(event);
        } else if (EVENT_RESET_COLUMNS.equals(event.getType())) {
            this.handleUiResetColumns(event);
        } else if (EVENT_SORT.equals(event.getType())) {
            this.handleUiSort(event);
        } else if (EVENT_GROUP.equals(event.getType())) {
            this.handleUiGroup(event);
        } else if (EVENT_COLUMN_MOVED.equals(event.getType())) {
            this.handleUiColumnMoved(event);
        } else if (EVENT_COLUMN_RESIZED.equals(event.getType())) {
            this.handleUiColumnResized(event);
        } else if (JsonEventType.APP_LINK_ACTION.matches(event.getType())) {
            this.handleUiAppLinkAction(event);
        } else if (EVENT_ROWS_CHECKED.equals(event.getType())) {
            this.handleUiRowChecked(event);
        } else if (EVENT_ROWS_EXPANDED.equals(event.getType())) {
            this.handleUiRowsExpanded(event);
        } else if (EVENT_PREPARE_CELL_EDIT.equals(event.getType())) {
            this.handleUiPrepareCellEdit(event);
        } else if (EVENT_COMPLETE_CELL_EDIT.equals(event.getType())) {
            this.handleUiCompleteCellEdit(event);
        } else if (EVENT_CANCEL_CELL_EDIT.equals(event.getType())) {
            this.handleUiCancelCellEdit(event);
        } else if (EVENT_CLIPBOARD_EXPORT.equals(event.getType())) {
            this.handleUiClipboardExport(event);
        } else if (EVENT_FILTER_ADDED.equals(event.getType())) {
            this.handleUiFilterAdded(event);
        } else if (EVENT_FILTER_REMOVED.equals(event.getType())) {
            this.handleUiFilterRemoved(event);
        } else if (EVENT_FILTER.equals(event.getType())) {
            this.handleUiFilter(event);
        } else if (EVENT_COLUMN_AGGR_FUNC_CHANGED.equals(event.getType())) {
            this.handleColumnAggregationFunctionChanged(event);
        } else if (EVENT_COLUMN_BACKGROUND_EFFECT_CHANGED.equals(event.getType())) {
            this.handleColumnBackgroundEffectChanged(event);
        } else if (EVENT_COLUMN_ORGANIZE_ACTION.equals(event.getType())) {
            this.handleUiColumnOrganizeAction(event);
        } else {
            super.handleUiEvent(event);
        }
    }

    @Override
    protected void handleUiPropertyChange(String propertyName, JSONObject data) {
        if ("contextColumn".equals(propertyName)) {
            String contextColumnId = data.optString(propertyName);
            IColumn<?> column = this.optColumn(contextColumnId);
            this.addPropertyEventFilterCondition(propertyName, column);
            ((ITable)this.getModel()).getUIFacade().setContextColumnFromUI(column);
        } else {
            super.handleUiPropertyChange(propertyName, data);
        }
    }

    protected void handleUiColumnOrganizeAction(JsonEvent event) {
        JSONObject data = event.getData();
        String action = data.getString("action");
        IColumn<?> column = this.extractColumn(data);
        switch (action) {
            case "add": {
                ((ITable)this.getModel()).getUIFacade().fireOrganizeColumnAddFromUI(column);
                break;
            }
            case "remove": {
                ((ITable)this.getModel()).getUIFacade().fireOrganizeColumnRemoveFromUI(column);
                break;
            }
            case "modify": {
                ((ITable)this.getModel()).getUIFacade().fireOrganizeColumnModifyFromUI(column);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    protected void handleUiRowClick(JsonEvent event) {
        ITableRow tableRow = this.extractTableRow(event.getData());
        if (tableRow == null) {
            LOG.info("Requested table-row doesn't exist anymore -> skip rowClicked event");
            return;
        }
        MouseButton mouseButton = this.extractMouseButton(event.getData());
        ((ITable)this.getModel()).getUIFacade().fireRowClickFromUI(tableRow, mouseButton);
    }

    protected MouseButton extractMouseButton(JSONObject json) {
        int mouseButton = json.getInt("mouseButton");
        switch (mouseButton) {
            case 1: {
                return MouseButton.Left;
            }
            case 3: {
                return MouseButton.Right;
            }
        }
        return MouseButton.Unknown;
    }

    protected void handleUiRowChecked(JsonEvent event) {
        CheckedInfo checkedInfo = this.jsonToCheckedInfo(event.getData());
        this.addTableEventFilterCondition(850).setCheckedRows(checkedInfo.getCheckedRows(), checkedInfo.getUncheckedRows());
        if (!checkedInfo.getCheckedRows().isEmpty()) {
            ((ITable)this.getModel()).getUIFacade().setCheckedRowsFromUI(checkedInfo.getCheckedRows(), true);
        }
        if (!checkedInfo.getUncheckedRows().isEmpty()) {
            ((ITable)this.getModel()).getUIFacade().setCheckedRowsFromUI(checkedInfo.getUncheckedRows(), false);
        }
    }

    protected void handleUiRowsExpanded(JsonEvent event) {
        ArrayList<ITableRow> expandedRows = new ArrayList<ITableRow>();
        ArrayList<ITableRow> collapsedRows = new ArrayList<ITableRow>();
        ArrayList<ITableRow> rows = new ArrayList<ITableRow>();
        JSONArray jsonRows = event.getData().optJSONArray(PROP_ROWS);
        if (jsonRows != null) {
            int i = 0;
            while (i < jsonRows.length()) {
                JSONObject jsonRow = jsonRows.getJSONObject(i);
                ITableRow row = this.optTableRow(jsonRow.getString(PROP_ROW_ID));
                if (row != null) {
                    rows.add(row);
                    if (jsonRow.optBoolean(PROP_EXPANDED)) {
                        expandedRows.add(row);
                    } else {
                        collapsedRows.add(row);
                    }
                }
                ++i;
            }
        }
        this.addTableEventFilterCondition(860).setRows(rows);
        if (!expandedRows.isEmpty()) {
            ((ITable)this.getModel()).getUIFacade().setExpandedRowsFromUI(expandedRows, true);
        }
        if (!collapsedRows.isEmpty()) {
            ((ITable)this.getModel()).getUIFacade().setExpandedRowsFromUI(collapsedRows, false);
        }
    }

    protected void handleUiRowsSelected(JsonEvent event) {
        JSONArray rowIds = event.getData().getJSONArray(PROP_ROW_IDS);
        List<ITableRow> tableRows = this.extractTableRows(rowIds);
        if (tableRows.isEmpty() && rowIds.length() > 0) {
            return;
        }
        if (tableRows.size() == rowIds.length()) {
            this.addTableEventFilterCondition(103).setRows(tableRows);
        }
        ((ITable)this.getModel()).getUIFacade().setSelectedRowsFromUI(tableRows);
    }

    protected void handleUiReload(JsonEvent event) {
        String reloadReason = event.getData().optString("reloadReason", "unspecified");
        ((ITable)this.getModel()).getUIFacade().fireTableReloadFromUI(reloadReason);
    }

    protected void handleUiResetColumns(JsonEvent event) {
        ((ITable)this.getModel()).getUIFacade().fireTableResetFromUI();
    }

    protected void handleUiSort(JsonEvent event) {
        if (!event.getData().optBoolean("sortingRequested")) {
            this.addTableEventFilterCondition(200);
        }
        this.fireSortFromUi(event.getData());
    }

    protected void handleUiSortRows(JsonEvent event) {
        this.fireSortFromUi(event.getData());
    }

    protected void fireSortFromUi(JSONObject data) {
        IColumn<?> column = this.extractColumn(data);
        boolean sortingRemoved = data.optBoolean("sortingRemoved");
        if (sortingRemoved) {
            ((ITable)this.getModel()).getUIFacade().fireSortColumnRemovedFromUI(column);
        } else {
            boolean multiSort = data.optBoolean("multiSort");
            boolean sortAscending = data.getBoolean("sortAscending");
            ((ITable)this.getModel()).getUIFacade().fireHeaderSortFromUI(column, multiSort, sortAscending);
        }
    }

    protected void handleUiGroup(JsonEvent event) {
        if (!event.getData().optBoolean("groupingRequested")) {
            this.addTableEventFilterCondition(200);
        }
        this.fireGroupFromUi(event.getData());
    }

    protected void fireGroupFromUi(JSONObject data) {
        IColumn<?> column = this.extractColumn(data);
        boolean groupingRemoved = data.optBoolean("groupingRemoved");
        if (groupingRemoved) {
            ((ITable)this.getModel()).getUIFacade().fireGroupColumnRemovedFromUI(column);
        } else {
            boolean multiGroup = data.optBoolean("multiGroup");
            boolean groupAscending = data.getBoolean("groupAscending");
            ((ITable)this.getModel()).getUIFacade().fireHeaderGroupFromUI(column, multiGroup, groupAscending);
        }
    }

    protected void handleColumnAggregationFunctionChanged(JsonEvent event) {
        this.addTableEventFilterCondition(950);
        IColumn<?> column = this.extractColumn(event.getData());
        Assertions.assertInstance(column, INumberColumn.class, (String)"Aggregation can only be specified on numeric columns", (Object[])new Object[0]);
        ((ITable)this.getModel()).getUIFacade().fireAggregationFunctionChanged((INumberColumn)column, event.getData().getString("aggregationFunction"));
    }

    protected void handleColumnBackgroundEffectChanged(JsonEvent event) {
        this.addTableEventFilterCondition(960);
        IColumn<?> column = this.extractColumn(event.getData());
        Assertions.assertInstance(column, INumberColumn.class, (String)"BackgroundEffect can only be specified on numeric columns", (Object[])new Object[0]);
        ((ITable)this.getModel()).getUIFacade().setColumnBackgroundEffect((INumberColumn)column, event.getData().optString("backgroundEffect", null));
    }

    protected void handleUiColumnMoved(JsonEvent event) {
        IColumn<?> column = this.extractColumn(event.getData());
        int viewIndex = event.getData().getInt("index");
        List<IColumn<?>> columns = this.getColumnsInViewOrder();
        columns.remove(column);
        columns.add(viewIndex, column);
        this.addTableEventFilterCondition(770).setColumns(columns);
        ((ITable)this.getModel()).getUIFacade().fireColumnMovedFromUI(column, viewIndex);
    }

    protected void handleUiColumnResized(JsonEvent event) {
        IColumn<?> column = this.extractColumn(event.getData());
        if (column == null) {
            LOG.info("Requested column doesn't exist anymore -> skip columnResized event");
            return;
        }
        int width = event.getData().getInt("width");
        ((ITable)this.getModel()).getUIFacade().setColumnWidthFromUI(column, width);
    }

    protected void handleUiRowAction(JsonEvent event) {
        ITableRow tableRow = this.extractTableRow(event.getData());
        IColumn<?> column = this.extractColumn(event.getData());
        ((ITable)this.getModel()).getUIFacade().setContextColumnFromUI(column);
        ((ITable)this.getModel()).getUIFacade().fireRowActionFromUI(tableRow);
    }

    protected void handleUiAppLinkAction(JsonEvent event) {
        IColumn<?> column = this.extractColumn(event.getData());
        String ref = event.getData().optString("ref", null);
        if (column != null) {
            ((ITable)this.getModel()).getUIFacade().setContextColumnFromUI(column);
        }
        ((ITable)this.getModel()).getUIFacade().fireAppLinkActionFromUI(ref);
    }

    protected void handleUiPrepareCellEdit(JsonEvent event) {
        ITableRow row = this.extractTableRow(event.getData());
        if (row == null) {
            LOG.info("Requested table-row doesn't exist anymore. Skip prepareCellEdit event");
            return;
        }
        IColumn<?> column = this.extractColumn(event.getData());
        ((ITable)this.getModel()).getUIFacade().prepareCellEditFromUI(row, column);
    }

    protected void startCellEdit(ITableRow row, IColumn<?> column, IFormField field) {
        if (row == null || !this.isRowAccepted(row)) {
            return;
        }
        if (field == null) {
            return;
        }
        Object jsonField = this.attachAdapter(field);
        LOG.debug("Created new field adapter for cell editing. Adapter: {}", jsonField);
        JSONObject json = new JSONObject();
        json.put(PROP_COLUMN_ID, (Object)this.getColumnId(column));
        json.put(PROP_ROW_ID, (Object)this.getTableRowId(row));
        json.put("fieldId", (Object)jsonField.getId());
        this.addActionEvent(EVENT_START_CELL_EDIT, (IJsonAdapter<?>)jsonField, json).protect();
    }

    protected void handleUiCompleteCellEdit(JsonEvent event) {
        ((ITable)this.getModel()).getUIFacade().completeCellEditFromUI();
    }

    protected void handleUiCancelCellEdit(JsonEvent event) {
        ((ITable)this.getModel()).getUIFacade().cancelCellEditFromUI();
    }

    protected void endCellEdit(IFormField field) {
        Object jsonField = this.getAdapter(field);
        if (jsonField == null) {
            LOG.info("No field adapter found for cell-editor " + String.valueOf(field) + ". Maybe the editor or the corresponding form had been closed during completeCellEdit.");
            return;
        }
        JSONObject json = new JSONObject();
        json.put("fieldId", (Object)jsonField.getId());
        this.addActionEvent(EVENT_END_CELL_EDIT, (IJsonAdapter<?>)jsonField, json).protect();
        jsonField.dispose();
    }

    protected void handleUiClipboardExport(JsonEvent event) {
        if (!ACCESS.check((Permission)new CopyToClipboardPermission())) {
            return;
        }
        TransferObject scoutTransferable = ((ITable)this.getModel()).getUIFacade().fireRowsCopyRequestFromUI();
        if (scoutTransferable instanceof TextTransferObject) {
            try {
                ((IClipboardService)BEANS.get(IClipboardService.class)).setContents(scoutTransferable);
            }
            catch (RuntimeException e) {
                throw new UiException("Unable to copy to clipboard.", e);
            }
        }
    }

    protected void handleUiFilterAdded(JsonEvent event) {
        JSONObject data = event.getData();
        IUserFilterState filterState = this.createFilterState(data);
        if (filterState == null) {
            return;
        }
        TableEventFilterCondition condition = this.addTableEventFilterCondition(900);
        condition.setUserFilter(filterState);
        ((ITable)this.getModel()).getUIFacade().fireFilterAddedFromUI(filterState);
    }

    protected IUserFilterState createFilterState(JSONObject data) {
        for (IUserFilterStateFactory factory : BEANS.all(IUserFilterStateFactory.class)) {
            IUserFilterState userFilterState = factory.createUserFilterState(this, data);
            if (userFilterState == null) continue;
            return userFilterState;
        }
        return null;
    }

    protected IUserFilterState getFilterState(JSONObject data) {
        String type = data.getString("filterType");
        if ("column".equals(type)) {
            IColumn<?> column = this.extractColumn(data);
            return ((ITable)this.getModel()).getUserFilterManager().getFilter((Object)column.getColumnId());
        }
        return ((ITable)this.getModel()).getUserFilterManager().getFilter((Object)type);
    }

    protected void handleUiFilterRemoved(JsonEvent event) {
        IUserFilterState filter = this.getFilterState(event.getData());
        if (filter == null) {
            return;
        }
        TableEventFilterCondition condition = this.addTableEventFilterCondition(910);
        condition.setUserFilter(filter);
        ((ITable)this.getModel()).getUIFacade().fireFilterRemovedFromUI(filter);
    }

    protected void handleUiFilter(JsonEvent event) {
        if (event.getData().optBoolean("remove")) {
            ((ITable)this.getModel()).getUIFacade().removeFilteredRowsFromUI();
        } else {
            List<ITableRow> tableRows = this.extractTableRows(event.getData());
            ((ITable)this.getModel()).getUIFacade().setFilteredRowsFromUI(tableRows);
        }
    }

    protected JSONObject tableRowToJson(ITableRow row) {
        JSONArray jsonCells = new JSONArray();
        for (IColumn column : ((ITable)this.getModel()).getColumnSet().getColumns()) {
            if (!column.isVisible() || column.isCompacted()) continue;
            jsonCells.put(this.cellToJson(row, column));
        }
        JSONObject jsonRow = new JSONObject();
        this.putProperty(jsonRow, "id", this.getOrCreateRowId(row));
        this.putProperty(jsonRow, "parentRow", this.getOrCreateRowId(((ITable)this.getModel()).findParentRow(row)));
        this.putProperty(jsonRow, "cells", jsonCells);
        this.putProperty(jsonRow, "checked", row.isChecked());
        this.putProperty(jsonRow, "enabled", row.isEnabled());
        this.putProperty(jsonRow, PROP_EXPANDED, row.isExpanded());
        this.putProperty(jsonRow, "iconId", BinaryResourceUrlUtility.createIconUrl(row.getIconId()));
        this.putProperty(jsonRow, "cssClass", row.getCssClass());
        if (row.getCustomValue("geoLocationCustomValuesId") != null) {
            JSONObject geoLocations = new JSONObject((Map)row.getCustomValue("geoLocationCustomValuesId"));
            this.putProperty(jsonRow, "geoLocationValues", geoLocations);
        }
        this.putProperty(jsonRow, "compactValue", BinaryResourceUrlUtility.replaceImageUrls(this, row.getCompactValue()));
        JsonObjectUtility.filterDefaultValues(jsonRow, "TableRow");
        return jsonRow;
    }

    protected Object cellToJson(ITableRow row, IColumn<?> column) {
        ICell cell = row.getCell(column);
        JsonColumn<?> jsonColumn = this.m_jsonColumns.get(column);
        if (jsonColumn == null) {
            throw new ProcessingException("No JsonColumn for column " + String.valueOf(column), new Object[0]);
        }
        JsonCell jsonCell = jsonColumn.createJsonCell(cell, this);
        return jsonCell.toJsonOrString();
    }

    protected JSONArray columnsToJson(Collection<IColumn<?>> columns) {
        JSONArray jsonColumns = new JSONArray();
        for (IColumn<?> column : columns) {
            JsonColumn<?> jsonColumn = this.m_jsonColumns.get(column);
            JSONObject json = jsonColumn.toJson();
            JsonObjectUtility.filterDefaultValues(json, jsonColumn.getObjectTypeVariant());
            jsonColumns.put((Object)json);
        }
        return jsonColumns;
    }

    @Override
    public BinaryResourceHolder provideBinaryResource(String filename) {
        BinaryResource attachment = ((ITable)this.getModel()).getAttachment(filename);
        return attachment == null ? this.getBinaryResourceMediator().getBinaryResourceHolder(filename) : new BinaryResourceHolder(attachment);
    }

    protected List<IColumn<?>> getColumnsInViewOrder() {
        return ((ITable)this.getModel()).getColumnSet().getVisibleColumns().stream().filter(column -> !column.isCompacted()).collect(Collectors.toList());
    }

    protected String getOrCreateRowId(ITableRow row) {
        if (row == null) {
            return null;
        }
        String id = this.m_tableRowIds.get(row);
        if (id == null) {
            id = this.getUiSession().createUniqueId();
            this.m_tableRows.put(id, row);
            this.m_tableRowIds.put(row, id);
        }
        return id;
    }

    protected JSONArray rowIdsToJson(Collection<ITableRow> modelRows) {
        JSONArray jsonRowIds = new JSONArray();
        for (ITableRow row : modelRows) {
            String rowId;
            if (!this.isRowAccepted(row) || (rowId = this.getTableRowId(row)) == null) continue;
            jsonRowIds.put((Object)rowId);
        }
        return jsonRowIds;
    }

    protected boolean isRowAccepted(ITableRow row) {
        if (row.getTable() == null || row.isStatusDeleted()) {
            return false;
        }
        if (row.isFilterAccepted()) {
            return true;
        }
        return row.isRejectedByUser();
    }

    public List<ITableRow> extractTableRows(JSONObject json) {
        JSONArray rowIds = json.getJSONArray(PROP_ROW_IDS);
        return this.extractTableRows(rowIds);
    }

    public List<ITableRow> extractTableRows(JSONArray rowIds) {
        ArrayList<ITableRow> rows = new ArrayList<ITableRow>(rowIds.length());
        int i = 0;
        while (i < rowIds.length()) {
            ITableRow tableRow = this.optTableRow((String)rowIds.get(i));
            if (tableRow != null) {
                rows.add(tableRow);
            }
            ++i;
        }
        return rows;
    }

    protected ITableRow extractTableRow(JSONObject json) {
        return this.optTableRow(json.getString(PROP_ROW_ID));
    }

    protected IColumn<?> extractColumn(JSONObject json) {
        String columnId = json.optString(PROP_COLUMN_ID, null);
        if (columnId == null) {
            return null;
        }
        return this.optColumn(columnId);
    }

    protected JsonColumn<?> extractJsonColumn(JSONObject json) {
        IColumn<?> column = this.extractColumn(json);
        return this.getJsonColumn(column);
    }

    protected JSONArray columnIdsToJson(Collection<IColumn<?>> columns) {
        JSONArray jsonColumnIds = new JSONArray();
        for (IColumn<?> column : columns) {
            jsonColumnIds.put((Object)this.getColumnId(column));
        }
        return jsonColumnIds;
    }

    public IColumn<?> optColumn(String columnId) {
        return this.m_columns.get(columnId);
    }

    public IColumn<?> getColumn(String columnId) {
        IColumn<?> column = this.m_columns.get(columnId);
        if (column == null) {
            throw new UiException("No column found for id " + columnId);
        }
        return column;
    }

    protected JsonColumn<?> getJsonColumn(IColumn<?> column) {
        if (column == null) {
            return null;
        }
        return this.m_jsonColumns.get(column);
    }

    public String getColumnId(IColumn<?> column) {
        JsonColumn<?> jsonColumn = this.getJsonColumn(column);
        if (jsonColumn == null) {
            return null;
        }
        return jsonColumn.getId();
    }

    public ITableRow optTableRow(String rowId) {
        return this.m_tableRows.get(rowId);
    }

    public ITableRow getTableRow(String rowId) {
        ITableRow row = this.optTableRow(rowId);
        if (row == null) {
            throw new UiException("No table-row found for ID " + rowId);
        }
        return row;
    }

    public String getTableRowId(ITableRow row) {
        if (row == null) {
            return null;
        }
        return this.m_tableRowIds.get(row);
    }

    protected JSONArray filtersToJson(Collection<IUserFilterState> filters) {
        JSONArray jsonFilters = new JSONArray();
        for (IUserFilterState filter : filters) {
            JsonTableUserFilter jsonFilter = (JsonTableUserFilter)MainJsonObjectFactory.get().createJsonObject(filter);
            jsonFilter.setJsonTable(this);
            if (jsonFilter.isValid()) {
                jsonFilters.put((Object)jsonFilter.toJson());
                continue;
            }
            LOG.info("Filter is not valid, maybe column is invisible. {}", (Object)jsonFilter);
        }
        return jsonFilters;
    }

    protected void handleModelTableEvent(TableEvent event) {
        if ((event = this.m_tableEventFilter.filter(event)) == null) {
            return;
        }
        this.bufferModelEvent(event);
        this.registerAsBufferedEventsAdapter();
    }

    protected void bufferModelEvent(TableEvent event) {
        switch (event.getType()) {
            case 1: {
                this.bufferColumnStructureChanged(event);
                break;
            }
            case 780: {
                this.bufferColumnHeadersUpdated(event);
                break;
            }
            default: {
                this.m_eventBuffer.add((IModelEvent)event);
            }
        }
    }

    protected void bufferColumnStructureChanged(TableEvent event) {
        this.m_eventBuffer.add((IModelEvent)event);
        this.m_eventBuffer.add((IModelEvent)new TableEvent((ITable)this.getModel(), 105));
        if (((ITable)this.getModel()).getUserFilterManager() != null && !((ITable)this.getModel()).getUserFilterManager().getFilters().isEmpty()) {
            this.m_eventBuffer.add((IModelEvent)new TableEvent((ITable)this.getModel(), 900));
        }
        this.m_eventBuffer.add((IModelEvent)new TableEvent((ITable)this.getModel(), 100, ((ITable)this.getModel()).getRows()));
        if (((ITable)this.getModel()).getSelectedRowCount() > 0) {
            this.m_eventBuffer.add((IModelEvent)new TableEvent((ITable)this.getModel(), 103, ((ITable)this.getModel()).getSelectedRows()));
        }
    }

    protected void bufferColumnHeadersUpdated(TableEvent event) {
        this.m_eventBuffer.add((IModelEvent)event);
        if (((ITable)this.getModel()).isCompact()) {
            this.m_eventBuffer.add((IModelEvent)new TableEvent((ITable)this.getModel(), 101, ((ITable)this.getModel()).getRows()));
        }
    }

    protected void preprocessBufferedEvents() {
        TableEvent event;
        List bufferInternal = this.m_eventBuffer.getBufferInternal();
        HashMap<ITableRow, Integer> rowsContainedInActualInsertEvents = new HashMap<ITableRow, Integer>();
        int i = 0;
        while (i < bufferInternal.size()) {
            event = (TableEvent)bufferInternal.get(i);
            if (event.getType() == 100) {
                for (ITableRow r : event.getRows()) {
                    rowsContainedInActualInsertEvents.put(r, i);
                }
            }
            ++i;
        }
        i = 0;
        while (i < bufferInternal.size()) {
            event = (TableEvent)bufferInternal.get(i);
            if (event.getType() == 210) {
                ArrayList<ITableRow> rowsToInsert = new ArrayList<ITableRow>();
                ArrayList<ITableRow> rowsToDelete = new ArrayList<ITableRow>();
                ArrayList<ITableRow> rowsToIgnoreForOrderChanged = new ArrayList<ITableRow>();
                for (ITableRow row : ((ITable)this.getModel()).getRows()) {
                    String existingRowId = this.getTableRowId(row);
                    if (row.isFilterAccepted()) {
                        if (rowsContainedInActualInsertEvents.containsKey(row) && (Integer)rowsContainedInActualInsertEvents.get(row) > i) {
                            rowsToIgnoreForOrderChanged.add(row);
                            continue;
                        }
                        if (existingRowId != null) continue;
                        rowsToInsert.add(row);
                        continue;
                    }
                    if (row.isRejectedByUser() || existingRowId == null) continue;
                    rowsToDelete.add(row);
                }
                bufferInternal.set(i, new TableEvent((ITable)this.getModel(), 100, rowsToInsert));
                if (!rowsToInsert.isEmpty()) {
                    ArrayList rowOrderChangedRows = CollectionUtility.arrayList((Collection)((ITable)this.getModel()).getRows());
                    rowOrderChangedRows.removeAll(rowsToIgnoreForOrderChanged);
                    bufferInternal.add(i + 1, new TableEvent((ITable)this.getModel(), 200, (List)rowOrderChangedRows));
                }
                int j = i - 1;
                while (j >= 0) {
                    ((TableEvent)bufferInternal.get(j)).removeRows(rowsToInsert);
                    --j;
                }
                bufferInternal.add(0, new TableEvent((ITable)this.getModel(), 102, rowsToDelete));
                ++i;
            }
            ++i;
        }
    }

    @Override
    public void processBufferedEvents() {
        if (this.m_eventBuffer.isEmpty()) {
            return;
        }
        this.preprocessBufferedEvents();
        List coalescedEvents = this.m_eventBuffer.consumeAndCoalesceEvents();
        for (TableEvent event : coalescedEvents) {
            this.processEvent(event);
        }
    }

    protected void processEvent(TableEvent event) {
        switch (event.getType()) {
            case 100: {
                this.handleModelRowsInserted(event.getRows());
                break;
            }
            case 101: {
                this.handleModelRowsUpdated(event.getRows());
                break;
            }
            case 102: {
                this.handleModelRowsDeleted(event.getRows());
                break;
            }
            case 105: {
                this.handleModelAllRowsDeleted();
                break;
            }
            case 103: {
                this.handleModelRowsSelected(event.getRows());
                break;
            }
            case 200: {
                this.handleModelRowOrderChanged(event.getRows());
                break;
            }
            case 1: {
                this.handleModelColumnStructureChanged();
                break;
            }
            case 770: {
                this.handleModelColumnOrderChanged();
                break;
            }
            case 780: {
                this.handleModelColumnHeadersUpdated(event.getColumns());
                break;
            }
            case 850: {
                this.handleModelRowsChecked(event.getRows());
                break;
            }
            case 860: {
                this.handleModelRowsExpanded(event.getRows());
                break;
            }
            case 210: {
                throw new IllegalStateException("Unsupported event type: " + String.valueOf(event));
            }
            case 800: {
                this.handleModelRequestFocus(event);
                break;
            }
            case 830: {
                this.handleModelScrollToSelection(event);
                break;
            }
            case 900: 
            case 910: {
                this.handleModelUserFilterChange(event);
                break;
            }
            case 950: {
                this.handleModelColumnAggregationChanged(event);
                break;
            }
            case 960: {
                this.handleModelColumnBackgroundEffectChanged(event);
                break;
            }
            case 805: {
                this.handleModelRequestFocusInCell(event);
                break;
            }
            case 807: {
                this.handleModelStartCellEdit(event);
                break;
            }
            case 808: {
                this.handleModelEndCellEdit(event);
            }
        }
    }

    protected void handleModelRowsInserted(Collection<ITableRow> modelRows) {
        HashSet<ITableRow> acceptedRows = new HashSet<ITableRow>();
        JSONArray jsonRows = this.tableRowsToJson(modelRows, acceptedRows);
        if (jsonRows.length() == 0) {
            return;
        }
        JSONObject jsonEvent = new JSONObject();
        this.putProperty(jsonEvent, PROP_ROWS, jsonRows);
        this.addActionEvent(EVENT_ROWS_INSERTED, jsonEvent);
        this.m_listeners.fireEvent(new JsonTableEvent(this, 100, acceptedRows));
    }

    protected void handleModelRowsUpdated(Collection<ITableRow> modelRows) {
        JSONArray jsonRows = this.tableRowsToJson(modelRows);
        if (jsonRows.length() == 0) {
            return;
        }
        JSONObject jsonEvent = new JSONObject();
        this.putProperty(jsonEvent, PROP_ROWS, jsonRows);
        this.addActionEvent(EVENT_ROWS_UPDATED, jsonEvent);
    }

    protected void handleModelRowsDeleted(Collection<ITableRow> modelRows) {
        if (modelRows.isEmpty()) {
            return;
        }
        if (this.getFilteredRowCount() == 0) {
            this.handleModelAllRowsDeleted();
            return;
        }
        HashSet<ITableRow> disposedRows = new HashSet<ITableRow>();
        JSONArray jsonRowIds = new JSONArray();
        for (ITableRow row : modelRows) {
            String rowId = this.getTableRowId(row);
            if (rowId == null) continue;
            jsonRowIds.put((Object)rowId);
            this.disposeRow(row);
            disposedRows.add(row);
        }
        if (jsonRowIds.length() == 0) {
            return;
        }
        JSONObject jsonEvent = new JSONObject();
        jsonEvent.put(PROP_ROW_IDS, (Object)jsonRowIds);
        this.addActionEvent(EVENT_ROWS_DELETED, jsonEvent);
        this.m_listeners.fireEvent(new JsonTableEvent(this, 200, disposedRows));
    }

    protected int getFilteredRowCount() {
        if (((ITable)this.getModel()).getRowFilters().isEmpty()) {
            return ((ITable)this.getModel()).getRowCount();
        }
        int filteredRowCount = 0;
        for (ITableRow row : ((ITable)this.getModel()).getRows()) {
            if (!row.isFilterAccepted() && !row.isRejectedByUser()) continue;
            ++filteredRowCount;
        }
        return filteredRowCount;
    }

    protected void handleModelAllRowsDeleted() {
        if (this.m_tableRows.isEmpty()) {
            return;
        }
        ArrayList<ITableRow> disposedRows = null;
        if (this.m_listeners.list(200).size() > 0) {
            disposedRows = new ArrayList<ITableRow>(this.m_tableRows.values());
        }
        this.m_tableRows.clear();
        this.m_tableRowIds.clear();
        this.addActionEvent(EVENT_ALL_ROWS_DELETED);
        this.m_listeners.fireEvent(new JsonTableEvent(this, 200, disposedRows));
    }

    protected void handleModelRowsSelected(Collection<ITableRow> modelRows) {
        JSONObject jsonEvent = new JSONObject();
        this.putProperty(jsonEvent, PROP_ROW_IDS, this.rowIdsToJson(modelRows));
        this.addActionEvent(EVENT_ROWS_SELECTED, jsonEvent);
    }

    protected void handleModelRowsChecked(Collection<ITableRow> modelRows) {
        JSONArray jsonRows = new JSONArray();
        for (ITableRow row : modelRows) {
            if (!this.isRowAccepted(row)) continue;
            JSONObject jsonRow = new JSONObject();
            this.putProperty(jsonRow, "id", this.getTableRowId(row));
            this.putProperty(jsonRow, "checked", row.isChecked());
            jsonRows.put((Object)jsonRow);
        }
        if (jsonRows.length() == 0) {
            return;
        }
        JSONObject jsonEvent = new JSONObject();
        this.putProperty(jsonEvent, PROP_ROWS, jsonRows);
        this.addActionEvent(EVENT_ROWS_CHECKED, jsonEvent);
    }

    protected void handleModelRowsExpanded(List<ITableRow> rows) {
        JSONArray jsonRows = new JSONArray();
        rows.stream().filter(this::isRowAccepted).map(row -> {
            JSONObject jsonRow = new JSONObject();
            this.putProperty(jsonRow, "id", this.getTableRowId((ITableRow)row));
            this.putProperty(jsonRow, PROP_EXPANDED, row.isExpanded());
            return jsonRow;
        }).forEach(arg_0 -> ((JSONArray)jsonRows).put(arg_0));
        JSONObject jsonEvent = new JSONObject();
        this.putProperty(jsonEvent, PROP_ROWS, jsonRows);
        this.addActionEvent(EVENT_ROWS_EXPANDED, jsonEvent);
    }

    protected void handleModelRowOrderChanged(Collection<ITableRow> modelRows) {
        JSONArray jsonRowIds = new JSONArray();
        ArrayList<String> rowIds = new ArrayList<String>();
        for (ITableRow row : modelRows) {
            if (!this.isRowAccepted(row)) continue;
            String rowId = this.getTableRowId(row);
            jsonRowIds.put((Object)rowId);
            rowIds.add(rowId);
        }
        if (jsonRowIds.length() < this.m_tableRows.size()) {
            ArrayList<String> missingRowIds = new ArrayList<String>(this.m_tableRows.keySet());
            missingRowIds.removeAll(rowIds);
            for (String id : missingRowIds) {
                jsonRowIds.put((Object)id);
            }
        }
        if (jsonRowIds.length() == 0) {
            return;
        }
        JSONObject jsonEvent = new JSONObject();
        this.putProperty(jsonEvent, PROP_ROW_IDS, jsonRowIds);
        this.addActionEvent("rowOrderChanged", jsonEvent);
    }

    protected void handleModelColumnStructureChanged() {
        this.disposeAllColumns();
        this.attachColumns();
        JSONObject jsonEvent = new JSONObject();
        this.putProperty(jsonEvent, PROP_COLUMNS, this.columnsToJson(this.getColumnsInViewOrder()));
        this.addActionEvent(EVENT_COLUMN_STRUCTURE_CHANGED, jsonEvent);
        this.addPropertyChangeEvent(PROP_COLUMN_ADDABLE, (Object)((ITable)this.getModel()).getTableOrganizer().isColumnAddable());
    }

    protected void handleModelColumnOrderChanged() {
        List<IColumn<?>> filteredColumns = this.filterAttachedColumns(this.getColumnsInViewOrder());
        if (filteredColumns.isEmpty()) {
            return;
        }
        JSONObject jsonEvent = new JSONObject();
        this.putProperty(jsonEvent, PROP_COLUMN_IDS, this.columnIdsToJson(filteredColumns));
        this.addActionEvent(EVENT_COLUMN_ORDER_CHANGED, jsonEvent);
    }

    protected void handleModelColumnHeadersUpdated(Collection<IColumn<?>> columns) {
        JSONObject jsonEvent = new JSONObject();
        Collection<IColumn<?>> visibleColumns = this.filterVisibleColumns(columns);
        List<IColumn<?>> filteredColumns = this.filterAttachedColumns(visibleColumns);
        if (filteredColumns.isEmpty()) {
            return;
        }
        this.putProperty(jsonEvent, PROP_COLUMNS, this.columnsToJson(filteredColumns));
        this.addActionEvent(EVENT_COLUMN_HEADERS_UPDATED, jsonEvent);
    }

    protected void handleModelRequestFocus(TableEvent event) {
        this.addActionEvent(EVENT_REQUEST_FOCUS).protect();
    }

    protected void handleModelScrollToSelection(TableEvent event) {
        this.addActionEvent(EVENT_SCROLL_TO_SELECTION).protect();
    }

    protected void handleModelUserFilterChange(TableEvent event) {
        Collection filters = ((ITable)this.getModel()).getUserFilterManager().getFilters();
        JSONObject jsonEvent = new JSONObject();
        jsonEvent.put(PROP_FILTERS, (Object)this.filtersToJson(filters));
        this.addActionEvent(EVENT_FILTERS_CHANGED, jsonEvent);
    }

    protected void handleModelColumnAggregationChanged(TableEvent event) {
        JSONObject jsonEvent = new JSONObject();
        JSONArray eventParts = new JSONArray();
        for (IColumn c : event.getColumns()) {
            Assertions.assertInstance((Object)c, INumberColumn.class, (String)"ColumnAggregation is only supported on NumberColumns", (Object[])new Object[0]);
            JSONObject eventPart = new JSONObject();
            this.putProperty(eventPart, PROP_COLUMN_ID, this.getColumnId(c));
            this.putProperty(eventPart, "aggregationFunction", ((INumberColumn)c).getAggregationFunction());
            eventParts.put((Object)eventPart);
        }
        this.putProperty(jsonEvent, "eventParts", eventParts);
        this.addActionEvent(EVENT_COLUMN_AGGR_FUNC_CHANGED, jsonEvent);
    }

    protected void handleModelColumnBackgroundEffectChanged(TableEvent event) {
        JSONObject jsonEvent = new JSONObject();
        JSONArray eventParts = new JSONArray();
        for (IColumn c : event.getColumns()) {
            Assertions.assertInstance((Object)c, INumberColumn.class, (String)"ColumnBackgroundEffect is only supported on NumberColumns", (Object[])new Object[0]);
            JSONObject eventPart = new JSONObject();
            this.putProperty(eventPart, PROP_COLUMN_ID, this.getColumnId(c));
            this.putProperty(eventPart, "backgroundEffect", ((INumberColumn)c).getBackgroundEffect());
            eventParts.put((Object)eventPart);
        }
        this.putProperty(jsonEvent, "eventParts", eventParts);
        this.addActionEvent(EVENT_COLUMN_BACKGROUND_EFFECT_CHANGED, jsonEvent);
    }

    protected void handleModelRequestFocusInCell(TableEvent event) {
        ITableRow row = (ITableRow)CollectionUtility.firstElement((List)event.getRows());
        if (row == null || !this.isRowAccepted(row)) {
            return;
        }
        JSONObject jsonEvent = new JSONObject();
        this.putProperty(jsonEvent, PROP_ROW_ID, this.getOrCreateRowId(row));
        this.putProperty(jsonEvent, PROP_COLUMN_ID, this.getColumnId((IColumn)CollectionUtility.firstElement((Collection)event.getColumns())));
        this.addActionEvent(EVENT_REQUEST_FOCUS_IN_CELL, jsonEvent).protect();
    }

    protected void handleModelStartCellEdit(TableEvent event) {
        ITableRow row = (ITableRow)CollectionUtility.firstElement((List)event.getRows());
        IColumn column = (IColumn)CollectionUtility.firstElement((Collection)event.getColumns());
        this.startCellEdit(row, column, event.getCellEditor());
    }

    protected void handleModelEndCellEdit(TableEvent event) {
        this.endCellEdit(event.getCellEditor());
    }

    protected Collection<IColumn<?>> filterVisibleColumns(Collection<IColumn<?>> columns) {
        LinkedList visibleColumns = new LinkedList();
        for (IColumn<?> column : columns) {
            if (!column.isVisible() || column.isCompacted()) continue;
            visibleColumns.add(column);
        }
        return visibleColumns;
    }

    protected List<IColumn<?>> filterAttachedColumns(Collection<IColumn<?>> columns) {
        if (columns == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        for (IColumn<?> column : columns) {
            if (!this.m_jsonColumns.containsKey(column)) continue;
            result.add(column);
        }
        return result;
    }

    @Override
    public void handleModelContextMenuChanged(FilteredJsonAdapterIds<?> filteredAdapters) {
        this.addPropertyChangeEvent("menus", filteredAdapters);
    }

    protected Map<String, ITableRow> tableRowsMap() {
        return this.m_tableRows;
    }

    protected Map<ITableRow, String> tableRowIdsMap() {
        return this.m_tableRowIds;
    }

    protected Map<IColumn<?>, JsonColumn<?>> jsonColumns() {
        return this.m_jsonColumns;
    }

    protected AbstractEventBuffer<TableEvent> eventBuffer() {
        return this.m_eventBuffer;
    }

    protected TableEventFilterCondition addTableEventFilterCondition(int tableEventType) {
        TableEventFilterCondition condition = new TableEventFilterCondition(tableEventType);
        this.m_tableEventFilter.addCondition(condition);
        return condition;
    }

    @Override
    public void cleanUpEventFilters() {
        super.cleanUpEventFilters();
        this.m_tableEventFilter.removeAllConditions();
    }

    @Override
    public void consumeBinaryResource(List<BinaryResource> binaryResources, Map<String, String> uploadProperties) {
        if ((((ITable)this.getModel()).getDropType() & 1) == 1) {
            String rowId;
            ResourceListTransferObject transferObject = new ResourceListTransferObject(binaryResources);
            ITableRow row = null;
            if (uploadProperties != null && uploadProperties.containsKey(PROP_ROW_ID) && !StringUtility.isNullOrEmpty((CharSequence)(rowId = uploadProperties.get(PROP_ROW_ID)))) {
                row = this.getTableRow(rowId);
            }
            ((ITable)this.getModel()).getUIFacade().fireRowDropActionFromUI(row, (TransferObject)transferObject);
        }
    }

    @Override
    public long getMaximumUploadSize() {
        return ((ITable)this.getModel()).getDropMaximumSize();
    }

    protected CheckedInfo jsonToCheckedInfo(JSONObject data) {
        JSONArray jsonRows = data.optJSONArray(PROP_ROWS);
        CheckedInfo checkInfo = new CheckedInfo();
        int i = 0;
        while (i < jsonRows.length()) {
            JSONObject jsonObject = jsonRows.optJSONObject(i);
            ITableRow row = this.optTableRow(jsonObject.getString(PROP_ROW_ID));
            if (row != null) {
                checkInfo.getAllRows().add(row);
                if (jsonObject.optBoolean("checked")) {
                    checkInfo.getCheckedRows().add(row);
                } else {
                    checkInfo.getUncheckedRows().add(row);
                }
            }
            ++i;
        }
        return checkInfo;
    }

    public JsonTableListeners listeners() {
        return this.m_listeners;
    }

    public void addListener(JsonTableListener listener, Integer ... eventTypes) {
        this.listeners().add(listener, false, eventTypes);
    }

    public void removeListener(JsonTableListener listener, Integer ... eventTypes) {
        this.listeners().remove(listener, eventTypes);
    }

    protected void logContextColumnInconsistency(Object value) {
        String debugInfo = "\nAdapterId : " + this.getId();
        debugInfo = debugInfo + "\nParent    : " + String.valueOf(this.getParent());
        debugInfo = debugInfo + "\nDisposed  : " + this.isDisposed();
        debugInfo = debugInfo + "\nModel     : " + String.valueOf(this.getModel());
        debugInfo = debugInfo + "\nValue     : " + String.valueOf(value instanceof IColumn ? this.toDebugInfo((IColumn)value) : value);
        debugInfo = debugInfo + "\nCtxColumn : " + this.toDebugInfo(((ITable)this.getModel()).getContextColumn());
        debugInfo = debugInfo + "\nColumns:\n" + ((ITable)this.getModel()).getColumns().stream().map(column -> "  " + this.toDebugInfo((IColumn<?>)column)).collect(Collectors.joining("\n"));
        debugInfo = debugInfo + "\nAdapters:\n" + this.m_jsonColumns.entrySet().stream().map(entry -> "  " + Integer.toHexString(((IColumn)entry.getKey()).hashCode()) + " = " + this.toDebugInfo((JsonColumn)entry.getValue())).collect(Collectors.joining("\n"));
        debugInfo = debugInfo + "\nEvent Buffer";
        if (this.m_eventBuffer.isEmpty()) {
            debugInfo = debugInfo + " is empty";
        } else {
            debugInfo = debugInfo + " contains " + this.m_eventBuffer.size() + " events:\n  - ";
            debugInfo = debugInfo + this.m_eventBuffer.getBufferInternal().stream().map(event -> StringUtility.substring((String)StringUtility.removeNewLines((String)event.toString()), (int)0, (int)250)).collect(Collectors.joining("\n  - "));
        }
        LOG.info("Could not resolve context column, assuming null.\n--- DEBUG INFO --- {}", (Object)debugInfo);
    }

    protected String toDebugInfo(IColumn<?> column) {
        if (column == null) {
            return "null";
        }
        String text = column.getHeaderCell().getText();
        return column.getClass().getName() + "@" + Integer.toHexString(column.hashCode()) + " [" + (String)(text == null ? "null" : "\"" + text + "\"") + " viewIndexHint=" + column.getVisibleColumnIndexHint() + " visible=" + column.isVisible() + " table=" + String.valueOf(column.getTable()) + "]";
    }

    protected String toDebugInfo(JsonColumn<?> jsonColumn) {
        if (jsonColumn == null) {
            return "null";
        }
        return jsonColumn.getClass().getName() + "@" + Integer.toHexString(jsonColumn.hashCode()) + " adapterId: " + jsonColumn.getId() + " model: " + this.toDebugInfo((IColumn<?>)jsonColumn.getColumn());
    }

    protected static class CheckedInfo {
        private final List<ITableRow> m_allRows = new ArrayList<ITableRow>();
        private final List<ITableRow> m_checkedRows = new ArrayList<ITableRow>();
        private final List<ITableRow> m_uncheckedRows = new ArrayList<ITableRow>();

        protected CheckedInfo() {
        }

        public List<ITableRow> getAllRows() {
            return this.m_allRows;
        }

        public List<ITableRow> getCheckedRows() {
            return this.m_checkedRows;
        }

        public List<ITableRow> getUncheckedRows() {
            return this.m_uncheckedRows;
        }
    }

    protected class P_TableListener
    extends TableAdapter {
        protected P_TableListener() {
        }

        public void tableChanged(TableEvent e) {
            ModelJobs.assertModelThread();
            JsonTable.this.handleModelTableEvent(e);
        }
    }
}

