/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.table;

import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractDateColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IDateColumn;
import org.eclipse.scout.rt.client.ui.basic.table.userfilter.ColumnUserFilterState;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.exception.DefaultExceptionTranslator;
import org.eclipse.scout.rt.platform.nls.NlsLocale;
import org.eclipse.scout.rt.ui.html.UiException;
import org.eclipse.scout.rt.ui.html.json.JsonDate;
import org.eclipse.scout.rt.ui.html.json.table.JsonColumn;
import org.eclipse.scout.rt.ui.html.json.table.userfilter.JsonDateColumnUserFilter;
import org.json.JSONObject;

public class JsonDateColumn<T extends IDateColumn>
extends JsonColumn<T> {
    public JsonDateColumn(T model) {
        super(model);
    }

    @Override
    public String getObjectType() {
        return "DateColumn";
    }

    @Override
    protected ColumnUserFilterState createFilterStateFromJson(JSONObject json) {
        return new JsonDateColumnUserFilter(null).createFilterStateFromJson((IColumn<?>)this.getColumn(), json);
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        json.put("hasDate", ((IDateColumn)this.getColumn()).isHasDate());
        json.put("hasTime", ((IDateColumn)this.getColumn()).isHasTime());
        json.put("groupFormat", (Object)((IDateColumn)this.getColumn()).getGroupFormat());
        Locale oldLocale = NlsLocale.getOrElse(null);
        try {
            try {
                NlsLocale.set((Locale)this.getUiSession().getClientSession().getLocale());
                Method method = AbstractDateColumn.class.getDeclaredMethod("getDateFormat", new Class[0]);
                method.setAccessible(true);
                SimpleDateFormat dateFormat = (SimpleDateFormat)method.invoke(this.getColumn(), new Object[0]);
                json.put("format", (Object)dateFormat.toPattern());
            }
            catch (ReflectiveOperationException e) {
                throw new UiException("Failed to create JSON from 'date column'", ((DefaultExceptionTranslator)BEANS.get(DefaultExceptionTranslator.class)).unwrap((Throwable)e));
            }
        }
        finally {
            NlsLocale.set((Locale)oldLocale);
        }
        return json;
    }

    @Override
    public boolean isValueRequired() {
        return true;
    }

    @Override
    public Object cellValueToJson(Object value) {
        Date date = (Date)value;
        if (date != null) {
            return new JsonDate(date).asJsonString(false, ((IDateColumn)this.getColumn()).isHasDate(), ((IDateColumn)this.getColumn()).isHasTime());
        }
        return null;
    }
}

