/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.table;

import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.userfilter.ColumnUserFilterState;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.IJsonObject;
import org.eclipse.scout.rt.ui.html.json.InspectorInfo;
import org.eclipse.scout.rt.ui.html.json.JsonAdapterUtility;
import org.eclipse.scout.rt.ui.html.json.basic.cell.ICellValueReader;
import org.eclipse.scout.rt.ui.html.json.basic.cell.JsonCell;
import org.eclipse.scout.rt.ui.html.json.table.JsonTable;
import org.eclipse.scout.rt.ui.html.json.table.TableCellValueReader;
import org.eclipse.scout.rt.ui.html.json.table.userfilter.JsonTextColumnUserFilter;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceUrlUtility;
import org.json.JSONObject;

public class JsonColumn<T extends IColumn<?>>
implements IJsonObject {
    public static final String OBJECT_TYPE = "Column";
    private String m_id;
    private final T m_column;
    private JsonTable<?> m_jsonTable;
    private int m_indexOffset;
    private static final String PROP_INITIAL_ALWAYS_INCLUDE_SORT_AT_BEGIN = "initialAlwaysIncludeSortAtBegin";
    private static final String PROP_INITIAL_ALWAYS_INCLUDE_SORT_AT_END = "initialAlwaysIncludeSortAtEnd";
    private static final String PROP_REMOVABLE = "removable";
    private static final String PROP_MODIFIABLE = "modifiable";
    private static final String PROP_COMPACTED = "compacted";

    public JsonColumn(T model) {
        this.m_column = model;
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    protected String getObjectTypeVariant() {
        return JsonAdapterUtility.getObjectType(this.getObjectType(), this.m_column);
    }

    public void setColumnIndexOffset(int indexOffset) {
        this.m_indexOffset = indexOffset;
    }

    public boolean isValueRequired() {
        return false;
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put("id", (Object)this.getId());
        json.put("objectType", (Object)this.getObjectTypeVariant());
        T column = this.getColumn();
        json.put("index", column.getColumnIndex() - this.m_indexOffset);
        json.put("text", (Object)column.getHeaderCell().getText());
        json.put("width", column.getWidth());
        json.put("minWidth", column.getMinWidth());
        json.put("autoOptimizeMaxWidth", column.getAutoOptimizeMaxWidth());
        if (column.getInitialWidth() != column.getWidth()) {
            json.put("initialWidth", column.getInitialWidth());
        }
        json.put("horizontalAlignment", column.getHorizontalAlignment());
        if (column.isSortActive()) {
            json.put("sortActive", true);
            json.put("sortAscending", column.isSortAscending());
            json.put("sortIndex", column.getSortIndex());
            json.put("grouped", column.isGroupingActive());
        }
        if (column.getTable().getCheckableColumn() == column) {
            json.put("checkable", true);
        }
        json.put("fixedWidth", column.isFixedWidth());
        json.put("fixedPosition", column.isFixedPosition());
        json.put("autoOptimizeWidth", column.isAutoOptimizeWidth());
        json.put("editable", column.isEditable());
        json.put("mandatory", column.isMandatory());
        json.put("textWrap", column.isTextWrap());
        json.put("htmlEnabled", column.isHtmlEnabled());
        json.put("cssClass", (Object)column.getCssClass());
        json.put("headerCssClass", (Object)column.getHeaderCell().getCssClass());
        json.put("headerHtmlEnabled", column.getHeaderCell().isHtmlEnabled());
        json.put("headerMenuEnabled", column.getHeaderCell().isMenuEnabled());
        json.put("headerBackgroundColor", (Object)column.getHeaderCell().getBackgroundColor());
        json.put("headerForegroundColor", (Object)column.getHeaderCell().getForegroundColor());
        json.put("headerFont", column.getHeaderCell().getFont() != null ? column.getHeaderCell().getFont().toPattern() : null);
        json.put("headerTooltipText", (Object)column.getHeaderCell().getTooltipText());
        json.put("headerTooltipHtmlEnabled", column.getHeaderCell().isTooltipHtmlEnabled());
        json.put("headerIconId", (Object)BinaryResourceUrlUtility.createIconUrl(column.getHeaderCell().getIconId()));
        ((InspectorInfo)BEANS.get(InspectorInfo.class)).put(json, column, this.getUiSession());
        json.put("uiSortPossible", column.isUiSortPossible());
        json.put(PROP_INITIAL_ALWAYS_INCLUDE_SORT_AT_BEGIN, column.isInitialAlwaysIncludeSortAtBegin());
        json.put(PROP_INITIAL_ALWAYS_INCLUDE_SORT_AT_END, column.isInitialAlwaysIncludeSortAtEnd());
        json.put(PROP_REMOVABLE, column.isRemovable());
        json.put(PROP_MODIFIABLE, column.isModifiable());
        json.put("nodeColumnCandidate", column.isNodeColumnCandidate());
        json.put(PROP_COMPACTED, column.isCompacted());
        return json;
    }

    protected ColumnUserFilterState createFilterStateFromJson(JSONObject json) {
        return new JsonTextColumnUserFilter(null).createFilterStateFromJson((IColumn<?>)this.getColumn(), json);
    }

    public Object cellValueToJson(Object value) {
        if (this.isValueRequired()) {
            return value;
        }
        return null;
    }

    protected ICellValueReader createCellValueReader(ICell cell) {
        return new TableCellValueReader(this, cell);
    }

    public JsonCell createJsonCell(ICell cell, IJsonAdapter<?> parentAdapter) {
        return new JsonCell(cell, parentAdapter, this.createCellValueReader(cell));
    }

    public T getColumn() {
        return this.m_column;
    }

    public IUiSession getUiSession() {
        return this.getJsonTable().getUiSession();
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    public void setJsonTable(JsonTable<?> jsonTable) {
        this.m_jsonTable = jsonTable;
    }

    public JsonTable<?> getJsonTable() {
        return this.m_jsonTable;
    }
}

