/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.popup;

import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.popup.IPopup;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.AbstractJsonWidget;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonAdapterRefProperty;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;

public class JsonPopup<T extends IPopup>
extends AbstractJsonWidget<T> {
    private static final String EVENT_CLOSE = "close";

    public JsonPopup(T model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "Popup";
    }

    @Override
    protected void initJsonProperties(T model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonAdapterRefProperty<T>("anchor", (IPopup)model, this.getUiSession().getRootJsonAdapter()){

            protected IWidget modelValue() {
                return ((IPopup)this.getModel()).getAnchor();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("animateOpening", (IPopup)model){

            @Override
            protected Boolean modelValue() {
                return ((IPopup)this.getModel()).isAnimateOpening();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("animateResize", (IPopup)model){

            @Override
            protected Boolean modelValue() {
                return ((IPopup)this.getModel()).isAnimateResize();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("withGlassPane", (IPopup)model){

            @Override
            protected Boolean modelValue() {
                return ((IPopup)this.getModel()).isWithGlassPane();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("scrollType", (IPopup)model){

            @Override
            protected String modelValue() {
                return ((IPopup)this.getModel()).getScrollType();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("trimWidth", (IPopup)model){

            @Override
            protected Boolean modelValue() {
                return ((IPopup)this.getModel()).isTrimWidth();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("trimHeight", (IPopup)model){

            @Override
            protected Boolean modelValue() {
                return ((IPopup)this.getModel()).isTrimHeight();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("horizontalAlignment", (IPopup)model){

            @Override
            protected String modelValue() {
                return ((IPopup)this.getModel()).getHorizontalAlignment();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("verticalAlignment", (IPopup)model){

            @Override
            protected String modelValue() {
                return ((IPopup)this.getModel()).getVerticalAlignment();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("withArrow", (IPopup)model){

            @Override
            protected Boolean modelValue() {
                return ((IPopup)this.getModel()).isWithArrow();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("closeOnAnchorMouseDown", (IPopup)model){

            @Override
            protected Boolean modelValue() {
                return ((IPopup)this.getModel()).isCloseOnAnchorMouseDown();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("closeOnMouseDownOutside", (IPopup)model){

            @Override
            protected Boolean modelValue() {
                return ((IPopup)this.getModel()).isCloseOnMouseDownOutside();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("closeOnOtherPopupOpen", (IPopup)model){

            @Override
            protected Boolean modelValue() {
                return ((IPopup)this.getModel()).isCloseOnOtherPopupOpen();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("horizontalSwitch", (IPopup)model){

            @Override
            protected Boolean modelValue() {
                return ((IPopup)this.getModel()).isHorizontalSwitch();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("verticalSwitch", (IPopup)model){

            @Override
            protected Boolean modelValue() {
                return ((IPopup)this.getModel()).isVerticalSwitch();
            }
        });
    }

    @Override
    public void handleUiEvent(JsonEvent event) {
        if (EVENT_CLOSE.equals(event.getType())) {
            this.handleUiClose(event);
        } else {
            super.handleUiEvent(event);
        }
    }

    protected void handleUiClose(JsonEvent event) {
        ((IPopup)this.getModel()).getUIFacade().firePopupClosingFromUI();
    }
}

