/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.notification;

import org.eclipse.scout.rt.client.ui.notification.INotification;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.AbstractJsonWidget;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonEventType;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.JsonStatus;

public class JsonNotification<NOTIFICATION extends INotification>
extends AbstractJsonWidget<NOTIFICATION> {
    public static final String EVENT_CLOSE = "close";

    public JsonNotification(NOTIFICATION model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "Notification";
    }

    @Override
    protected void initJsonProperties(NOTIFICATION model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<NOTIFICATION>("status", (INotification)model){

            protected IStatus modelValue() {
                return ((INotification)this.getModel()).getStatus();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return JsonStatus.toJson((IStatus)value);
            }
        });
        this.putJsonProperty(new JsonProperty<NOTIFICATION>("closable", (INotification)model){

            @Override
            protected Boolean modelValue() {
                return ((INotification)this.getModel()).isClosable();
            }
        });
        this.putJsonProperty(new JsonProperty<NOTIFICATION>("htmlEnabled", (INotification)model){

            @Override
            protected Boolean modelValue() {
                return ((INotification)this.getModel()).isHtmlEnabled();
            }
        });
    }

    @Override
    public void handleUiEvent(JsonEvent event) {
        if (EVENT_CLOSE.equals(event.getType())) {
            this.handleUiClose();
        } else if (JsonEventType.APP_LINK_ACTION.matches(event.getType())) {
            this.handleUiAppLinkAction(event);
        } else {
            super.handleUiEvent(event);
        }
    }

    protected void handleUiClose() {
        ((INotification)this.getModel()).getUIFacade().fireClosedFromUI();
    }

    protected void handleUiAppLinkAction(JsonEvent event) {
        String ref = event.getData().optString("ref", null);
        ((INotification)this.getModel()).getUIFacade().fireAppLinkActionFromUI(ref);
    }
}

