/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.menu;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.ContextMenuEvent;
import org.eclipse.scout.rt.client.ui.action.menu.root.ContextMenuListener;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.FilteredJsonAdapterIds;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonAdapterUtility;
import org.eclipse.scout.rt.ui.html.json.action.DisplayableActionFilter;
import org.eclipse.scout.rt.ui.html.json.menu.IJsonContextMenuOwner;
import org.json.JSONArray;

public class JsonContextMenu<CONTEXT_MENU extends IContextMenu> {
    private ContextMenuListener m_contextMenuListener;
    private final Set<IJsonAdapter<?>> m_jsonMenuAdapters = new HashSet();
    private final IUiSession m_uiSession;
    private final CONTEXT_MENU m_model;
    private final IJsonAdapter<?> m_parent;
    private final Predicate<IMenu> m_filter;
    private final Consumer<FilteredJsonAdapterIds<?>> m_structureChangeHandler;

    public JsonContextMenu(CONTEXT_MENU model, IJsonAdapter<?> parent) {
        this(model, parent, new DisplayableActionFilter<IMenu>());
    }

    public JsonContextMenu(CONTEXT_MENU model, IJsonAdapter<?> parent, Predicate<IMenu> filter) {
        this(model, parent, filter, null);
    }

    public JsonContextMenu(CONTEXT_MENU model, IJsonAdapter<?> parent, Predicate<IMenu> filter, Consumer<FilteredJsonAdapterIds<?>> structureChangedHandler) {
        if (model == null) {
            throw new IllegalArgumentException("model must not be null");
        }
        this.m_model = model;
        this.m_parent = parent;
        this.m_uiSession = parent.getUiSession();
        this.m_filter = filter;
        if (structureChangedHandler == null) {
            structureChangedHandler = new P_StructureChangedHandler();
        }
        this.m_structureChangeHandler = structureChangedHandler;
    }

    public CONTEXT_MENU getModel() {
        return this.m_model;
    }

    public IUiSession getUiSession() {
        return this.m_uiSession;
    }

    public IJsonAdapter<?> getParent() {
        return this.m_parent;
    }

    public Predicate<IMenu> getFilter() {
        return this.m_filter;
    }

    public void init() {
        this.attachModel();
        this.attachChildAdapters();
    }

    public void dispose() {
        this.detachModel();
    }

    protected void attachModel() {
        if (this.m_contextMenuListener != null) {
            throw new IllegalStateException();
        }
        this.m_contextMenuListener = new P_ContextMenuListener();
        this.getModel().addContextMenuListener(this.m_contextMenuListener);
    }

    protected void detachModel() {
        if (this.m_contextMenuListener == null) {
            throw new IllegalStateException();
        }
        this.getModel().removeContextMenuListener(this.m_contextMenuListener);
        this.m_contextMenuListener = null;
    }

    public JSONArray childActionsToJson() {
        return JsonAdapterUtility.getAdapterIdsForModel(this.getUiSession(), this.getModel().getChildActions(), this.getParent(), this.getFilter());
    }

    public void attachChildAdapters() {
        this.m_jsonMenuAdapters.addAll(this.getParent().attachAdapters(this.getModel().getChildActions(), this.getFilter()));
    }

    public void handleModelContextMenuChanged(ContextMenuEvent event) {
        if (1 == event.getType()) {
            this.handleModelContextMenuStructureChanged(event);
        }
    }

    public void handleModelContextMenuStructureChanged(ContextMenuEvent event) {
        HashSet jsonMenuAdapters = new HashSet(this.m_jsonMenuAdapters);
        for (IJsonAdapter iJsonAdapter : jsonMenuAdapters) {
            if (this.getModel().getChildActions().contains(iJsonAdapter.getModel())) continue;
            iJsonAdapter.dispose();
            this.m_jsonMenuAdapters.remove(iJsonAdapter);
        }
        List list = this.getParent().attachAdapters(this.getModel().getChildActions(), this.getFilter());
        this.m_jsonMenuAdapters.addAll(list);
        FilteredJsonAdapterIds<IMenu> filteredAdapters = new FilteredJsonAdapterIds<IMenu>(list, this.getFilter());
        this.m_structureChangeHandler.accept(filteredAdapters);
    }

    protected class P_ContextMenuListener
    implements ContextMenuListener {
        protected P_ContextMenuListener() {
        }

        public void contextMenuChanged(ContextMenuEvent event) {
            JsonContextMenu.this.handleModelContextMenuChanged(event);
        }
    }

    protected class P_StructureChangedHandler
    implements Consumer<FilteredJsonAdapterIds<?>> {
        protected P_StructureChangedHandler() {
        }

        @Override
        public void accept(FilteredJsonAdapterIds<?> filteredAdapters) {
            IJsonAdapter<?> parent = JsonContextMenu.this.getParent();
            if (!(parent instanceof IJsonContextMenuOwner)) {
                throw new IllegalStateException("Parent is not a context menu owner, context menu changed event cannot be handled. Parent: " + String.valueOf(parent));
            }
            ((IJsonContextMenuOwner)((Object)parent)).handleModelContextMenuChanged(filteredAdapters);
        }
    }
}

