/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.lookup;

import java.util.Collection;
import java.util.function.Function;
import org.eclipse.scout.rt.client.services.lookup.ILookupCallResult;
import org.eclipse.scout.rt.client.services.lookup.IQueryParam;
import org.eclipse.scout.rt.platform.exception.IThrowableWithContextInfo;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.ui.html.json.IJsonObject;
import org.eclipse.scout.rt.ui.html.json.lookup.JsonLookupRow;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonLookupCallResult<T>
implements IJsonObject {
    private final ILookupCallResult<T> m_result;
    private final boolean m_multipleColumns;
    private final Function<T, ?> m_keyMapper;

    public JsonLookupCallResult(ILookupCallResult<T> result) {
        this(result, false, null);
    }

    public JsonLookupCallResult(ILookupCallResult<T> result, boolean multipleColumns, Function<T, ?> keyMapper) {
        Assertions.assertNotNull(result);
        this.m_result = result;
        this.m_multipleColumns = multipleColumns;
        this.m_keyMapper = keyMapper;
    }

    @Override
    public Object toJson() {
        JSONObject json = new JSONObject();
        json.put("lookupRows", (Object)this.lookupRowsToJson(this.m_result.getLookupRows()));
        IQueryParam queryParam = this.m_result.getQueryParam();
        json.put("queryBy", (Object)queryParam.getQueryBy());
        if (queryParam.is(IQueryParam.QueryBy.TEXT)) {
            json.put("text", (Object)queryParam.getText());
        } else if (queryParam.is(IQueryParam.QueryBy.KEY)) {
            json.put("key", this.getKey(queryParam.getKey()));
        } else if (queryParam.is(IQueryParam.QueryBy.REC)) {
            json.put("rec", this.getKey(queryParam.getKey()));
        }
        if (this.m_result.getException() != null) {
            json.put("exception", this.exceptionToJson(this.m_result.getException()));
        }
        return json;
    }

    protected JSONArray lookupRowsToJson(Collection<ILookupRow<T>> lookupRows) {
        if (lookupRows == null) {
            return null;
        }
        JSONArray json = new JSONArray();
        for (ILookupRow<T> lookupRow : lookupRows) {
            json.put(this.lookupRowToJson(lookupRow, this.m_multipleColumns));
        }
        return json;
    }

    protected Object lookupRowToJson(ILookupRow<T> lookupRow, boolean multipleColumns) {
        return JsonLookupRow.toJson(lookupRow, multipleColumns, this.m_keyMapper);
    }

    protected Object getKey(Object key) {
        if (key == null) {
            return null;
        }
        return this.m_keyMapper == null ? key : this.m_keyMapper.apply(key);
    }

    protected Object exceptionToJson(Throwable exception) {
        if (exception instanceof PlatformException) {
            return ((IThrowableWithContextInfo)exception).getDisplayMessage();
        }
        return exception.getMessage();
    }

    public static <T> Object toJson(ILookupCallResult<T> result) {
        return JsonLookupCallResult.toJson(result, false, null);
    }

    public static <T> Object toJson(ILookupCallResult<T> result, boolean multipleColumns, Function<T, ?> keyMapper) {
        if (result == null) {
            return null;
        }
        return new JsonLookupCallResult<T>(result, multipleColumns, keyMapper).toJson();
    }
}

