/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.label;

import org.eclipse.scout.rt.client.ui.label.ILabel;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.AbstractJsonWidget;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonEventType;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceHolder;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceUrlUtility;
import org.eclipse.scout.rt.ui.html.res.IBinaryResourceProvider;

public class JsonLabel<T extends ILabel>
extends AbstractJsonWidget<T>
implements IBinaryResourceProvider {
    public JsonLabel(T model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "Label";
    }

    @Override
    protected void initJsonProperties(T model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<ILabel>("value", model){

            @Override
            protected String modelValue() {
                return ((ILabel)this.getModel()).getValue();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return BinaryResourceUrlUtility.replaceImageUrls(JsonLabel.this, (String)value);
            }
        });
        this.putJsonProperty(new JsonProperty<ILabel>("htmlEnabled", model){

            @Override
            protected Boolean modelValue() {
                return ((ILabel)this.getModel()).isHtmlEnabled();
            }
        });
        this.putJsonProperty(new JsonProperty<ILabel>("scrollable", model){

            @Override
            protected Boolean modelValue() {
                return ((ILabel)this.getModel()).isScrollable();
            }
        });
    }

    @Override
    public void handleUiEvent(JsonEvent event) {
        if (JsonEventType.APP_LINK_ACTION.matches(event.getType())) {
            this.handleUiAppLinkAction(event);
        } else {
            super.handleUiEvent(event);
        }
    }

    protected void handleUiAppLinkAction(JsonEvent event) {
        String ref = event.getData().optString("ref", null);
        ((ILabel)this.getModel()).getUIFacade().fireAppLinkActionFromUI(ref);
    }

    @Override
    public BinaryResourceHolder provideBinaryResource(String filename) {
        BinaryResource attachment = ((ILabel)this.getModel()).getAttachment(filename);
        return attachment == null ? null : new BinaryResourceHolder(attachment);
    }
}

