/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.group;

import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.group.IGroup;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.AbstractJsonWidget;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterProperty;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceUrlUtility;
import org.json.JSONObject;

public class JsonGroup<T extends IGroup>
extends AbstractJsonWidget<T> {
    public JsonGroup(T model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "Group";
    }

    @Override
    protected void initJsonProperties(T model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<T>("collapsed", (IGroup)model){

            @Override
            protected Boolean modelValue() {
                return ((IGroup)this.getModel()).isCollapsed();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("collapsible", (IGroup)model){

            @Override
            protected Boolean modelValue() {
                return ((IGroup)this.getModel()).isCollapsible();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("collapseStyle", (IGroup)model){

            @Override
            protected String modelValue() {
                return ((IGroup)this.getModel()).getCollapseStyle();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("title", (IGroup)model){

            @Override
            protected String modelValue() {
                return ((IGroup)this.getModel()).getTitle();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("titleSuffix", (IGroup)model){

            @Override
            protected String modelValue() {
                return ((IGroup)this.getModel()).getTitleSuffix();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("visible", (IGroup)model){

            @Override
            protected Boolean modelValue() {
                return ((IGroup)this.getModel()).isVisible();
            }
        });
        this.putJsonProperty(new JsonAdapterProperty<T>("header", (IGroup)model, this.getUiSession()){

            protected IWidget modelValue() {
                return ((IGroup)this.getModel()).getHeader();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("headerFocusable", (IGroup)model){

            @Override
            protected Boolean modelValue() {
                return ((IGroup)this.getModel()).isHeaderFocusable();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("headerVisible", (IGroup)model){

            @Override
            protected Boolean modelValue() {
                return ((IGroup)this.getModel()).isHeaderVisible();
            }
        });
        this.putJsonProperty(new JsonAdapterProperty<T>("body", (IGroup)model, this.getUiSession()){

            protected IWidget modelValue() {
                return ((IGroup)this.getModel()).getBody();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("iconId", (IGroup)model){

            @Override
            protected String modelValue() {
                return ((IGroup)this.getModel()).getIconId();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return BinaryResourceUrlUtility.createIconUrl((String)value);
            }
        });
    }

    @Override
    protected void handleUiPropertyChange(String propertyName, JSONObject data) {
        if ("collapsed".equals(propertyName)) {
            boolean collapsed = data.getBoolean(propertyName);
            this.addPropertyEventFilterCondition(propertyName, collapsed);
            ((IGroup)this.getModel()).getUIFacade().setCollapsedFromUI(collapsed);
        } else {
            super.handleUiPropertyChange(propertyName, data);
        }
    }
}

