/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.form.js;

import org.eclipse.scout.rt.client.ui.form.js.IJsForm;
import org.eclipse.scout.rt.dataobject.IDataObject;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.LazyValue;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonDataObjectHelper;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.form.JsonForm;
import org.json.JSONObject;

public class JsonJsForm<IN extends IDataObject, OUT extends IDataObject, T extends IJsForm<IN, OUT>>
extends JsonForm<T> {
    private static final String EVENT_SAVE = "save";
    private static final String EVENT_SEARCH = "search";
    private static final String EVENT_RESET = "reset";
    private final LazyValue<JsonDataObjectHelper> m_jsonDoHelper = new LazyValue(() -> (JsonDataObjectHelper)BEANS.get(JsonDataObjectHelper.class));

    public JsonJsForm(T model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "JsForm";
    }

    @Override
    protected void initJsonProperties(T model) {
        this.putJsonProperty(new JsonProperty<IJsForm<IN, OUT>>("inputData", (IJsForm)model){

            @Override
            protected IN modelValue() {
                return ((IJsForm)this.getModel()).getInputData();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return JsonJsForm.this.jsonDoHelper().dataObjectToJson((IDoEntity)value);
            }
        });
        this.putJsonProperty(new JsonProperty<IJsForm<IN, OUT>>("jsFormObjectType", (IJsForm)model){

            @Override
            protected String modelValue() {
                return ((IJsForm)this.getModel()).getJsFormObjectType();
            }
        });
        this.putJsonProperty(new JsonProperty<IJsForm<IN, OUT>>("jsFormModel", (IJsForm)model){

            protected IDoEntity modelValue() {
                return ((IJsForm)this.getModel()).getJsFormModel();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return JsonJsForm.this.jsonDoHelper().dataObjectToJson((IDoEntity)value);
            }
        });
    }

    protected JsonDataObjectHelper jsonDoHelper() {
        return (JsonDataObjectHelper)this.m_jsonDoHelper.get();
    }

    @Override
    public void handleUiEvent(JsonEvent event) {
        if (EVENT_SAVE.equals(event.getType())) {
            this.handleUiSave(event);
        } else if (EVENT_SEARCH.equals(event.getType())) {
            this.handleUiSearch(event);
        } else if (EVENT_RESET.equals(event.getType())) {
            this.handleUiReset(event);
        } else {
            super.handleUiEvent(event);
        }
    }

    protected void handleUiSave(JsonEvent event) {
        ((IJsForm)this.getModel()).getUIFacade().fireSaveFromUI(this.outputData(event));
    }

    protected void handleUiSearch(JsonEvent event) {
        ((IJsForm)this.getModel()).getUIFacade().fireSearchFromUI(this.outputData(event));
    }

    protected void handleUiReset(JsonEvent event) {
        ((IJsForm)this.getModel()).getUIFacade().fireResetFromUI(this.outputData(event));
    }

    protected OUT outputData(JsonEvent event) {
        JSONObject outputDataJson = event.getData().optJSONObject("outputData");
        return (OUT)this.jsonDoHelper().jsonToDataObject(outputDataJson, ((IJsForm)this.getModel()).getOutputDataType());
    }
}

