/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.form.fields.tabbox;

import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.form.fields.groupbox.JsonGroupBox;

public class JsonTabItem<GROUP_BOX extends IGroupBox>
extends JsonGroupBox<GROUP_BOX> {
    public static final String PROP_MARKED = "marked";
    private boolean m_marked;

    public JsonTabItem(GROUP_BOX model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "TabItem";
    }

    @Override
    protected void initJsonProperties(GROUP_BOX model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<IGroupBox>(PROP_MARKED, model){

            @Override
            protected Boolean modelValue() {
                return JsonTabItem.this.m_marked;
            }
        });
        this.putJsonProperty(new JsonProperty<IGroupBox>("selectionKeystroke", model){

            @Override
            protected String modelValue() {
                return ((IGroupBox)this.getModel()).getSelectionKeyStroke();
            }
        });
    }

    @Override
    protected void attachModel() {
        super.attachModel();
        this.handleModelSaveNeededChanged();
        this.handleModelEmptyChanged();
    }

    @Override
    protected void handleModelPropertyChange(String propertyName, Object oldValue, Object newValue) {
        if ("empty".equals(propertyName)) {
            this.handleModelEmptyChanged();
        } else if ("saveNeeded".equals(propertyName)) {
            this.handleModelSaveNeededChanged();
        } else {
            super.handleModelPropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected boolean updateMarker(int markStrategy) {
        ICompositeField parent = ((IGroupBox)this.getModel()).getParentField();
        if (parent instanceof ITabBox) {
            return ((ITabBox)parent).getMarkStrategy() == markStrategy;
        }
        return false;
    }

    protected void handleModelSaveNeededChanged() {
        if (this.updateMarker(1)) {
            this.m_marked = ((IGroupBox)this.getModel()).isSaveNeeded();
            this.addMarkedPropertyChangeEvent();
        }
    }

    protected void handleModelEmptyChanged() {
        if (this.updateMarker(0)) {
            this.m_marked = !((IGroupBox)this.getModel()).isEmpty();
            this.addMarkedPropertyChangeEvent();
        }
    }

    protected void addMarkedPropertyChangeEvent() {
        this.addPropertyChangeEvent(PROP_MARKED, (Object)this.m_marked);
    }
}

