/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.form.fields.stringfield;

import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.client.ui.dnd.ResourceListTransferObject;
import org.eclipse.scout.rt.client.ui.dnd.TransferObject;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.util.BooleanUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonBasicField;
import org.eclipse.scout.rt.ui.html.res.IBinaryResourceConsumer;
import org.json.JSONObject;

public class JsonStringField<T extends IStringField>
extends JsonBasicField<T>
implements IBinaryResourceConsumer {
    public static final String EVENT_ACTION = "action";
    public static final String EVENT_SELECTION_CHANGE = "selectionChange";
    private static final String PROP_INPUT_OBFUSCATED = "inputObfuscated";
    public static final String OBFUSCATED_DISPLAY_TEXT = "----------";

    public JsonStringField(T model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "StringField";
    }

    @Override
    protected void initJsonProperties(T model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<IStringField>("multilineText", model){

            @Override
            protected Boolean modelValue() {
                return ((IStringField)this.getModel()).isMultilineText();
            }
        });
        this.putJsonProperty(new JsonProperty<IStringField>("inputMasked", model){

            @Override
            protected Boolean modelValue() {
                return ((IStringField)this.getModel()).isInputMasked();
            }
        });
        this.putJsonProperty(new JsonProperty<IStringField>("insertText", model){

            @Override
            protected String modelValue() {
                return (String)((IStringField)this.getModel()).getProperty("insertText");
            }
        });
        this.putJsonProperty(new JsonProperty<IStringField>("wrapText", model){

            @Override
            protected Boolean modelValue() {
                return ((IStringField)this.getModel()).isWrapText();
            }
        });
        this.putJsonProperty(new JsonProperty<IStringField>("format", model){

            @Override
            protected String modelValue() {
                return ((IStringField)this.getModel()).getFormat();
            }
        });
        this.putJsonProperty(new JsonProperty<IStringField>("spellCheckEnabled", model){

            @Override
            protected Boolean modelValue() {
                return ((IStringField)this.getModel()).isSpellCheckEnabled();
            }
        });
        this.putJsonProperty(new JsonProperty<IStringField>("hasAction", model){

            @Override
            protected Boolean modelValue() {
                return ((IStringField)this.getModel()).isHasAction();
            }
        });
        this.putJsonProperty(new JsonProperty<IStringField>("selectionStart", model){

            @Override
            protected Integer modelValue() {
                return ((IStringField)this.getModel()).getSelectionStart();
            }
        });
        this.putJsonProperty(new JsonProperty<IStringField>("selectionEnd", model){

            @Override
            protected Integer modelValue() {
                return ((IStringField)this.getModel()).getSelectionEnd();
            }
        });
        this.putJsonProperty(new JsonProperty<IStringField>("selectionTrackingEnabled", model){

            @Override
            protected Boolean modelValue() {
                return ((IStringField)this.getModel()).isSelectionTrackingEnabled();
            }
        });
        this.putJsonProperty(new JsonProperty<IStringField>("dropType", model){

            @Override
            protected Integer modelValue() {
                return ((IStringField)this.getModel()).getDropType();
            }
        });
        this.putJsonProperty(new JsonProperty<IStringField>("dropMaximumSize", model){

            @Override
            protected Long modelValue() {
                return ((IStringField)this.getModel()).getDropMaximumSize();
            }
        });
        this.putJsonProperty(new JsonProperty<IStringField>("maxLength", model){

            @Override
            protected Integer modelValue() {
                return ((IStringField)this.getModel()).getMaxLength();
            }
        });
        this.putJsonProperty(new JsonProperty<IStringField>("trimText", model){

            @Override
            protected Boolean modelValue() {
                return ((IStringField)this.getModel()).isTrimText();
            }
        });
        this.removeJsonProperty("displayText");
        this.putJsonProperty(new JsonProperty<IStringField>("displayText", model){

            @Override
            protected String modelValue() {
                if (JsonStringField.this.isObfuscateDisplayTextRequired()) {
                    return JsonStringField.OBFUSCATED_DISPLAY_TEXT;
                }
                return ((IStringField)this.getModel()).getDisplayText();
            }
        });
    }

    @Override
    public void handleUiEvent(JsonEvent event) {
        if (EVENT_ACTION.equals(event.getType())) {
            this.handleUiAction();
        } else if (EVENT_SELECTION_CHANGE.equals(event.getType())) {
            this.handleUiSelectionChange(event);
        } else {
            super.handleUiEvent(event);
        }
    }

    protected void handleUiAction() {
        ((IStringField)this.getModel()).getUIFacade().fireActionFromUI();
    }

    protected void handleUiSelectionChange(JsonEvent event) {
        int selectionStart = event.getData().getInt("selectionStart");
        int selectionEnd = event.getData().getInt("selectionEnd");
        this.addPropertyEventFilterCondition("selectionStart", selectionStart);
        this.addPropertyEventFilterCondition("selectionEnd", selectionEnd);
        ((IStringField)this.getModel()).getUIFacade().setSelectionFromUI(selectionStart, selectionEnd);
    }

    @Override
    protected void handleUiAcceptInputWhileTyping(String displayText) {
        ((IStringField)this.getModel()).getUIFacade().setDisplayTextFromUI(displayText);
    }

    @Override
    protected void handleUiAcceptInputAfterTyping(String displayText) {
        ((IStringField)this.getModel()).getUIFacade().parseAndSetValueFromUI(displayText);
    }

    @Override
    public void consumeBinaryResource(List<BinaryResource> binaryResources, Map<String, String> uploadProperties) {
        if ((((IStringField)this.getModel()).getDropType() & 1) == 1) {
            ResourceListTransferObject transferObject = new ResourceListTransferObject(binaryResources);
            ((IStringField)this.getModel()).getUIFacade().fireDropActionFromUi((TransferObject)transferObject);
        }
    }

    @Override
    public long getMaximumUploadSize() {
        return ((IStringField)this.getModel()).getDropMaximumSize();
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        if (this.isObfuscateDisplayTextRequired()) {
            json.put(PROP_INPUT_OBFUSCATED, true);
        }
        return json;
    }

    @Override
    protected void handleModelPropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent event;
        super.handleModelPropertyChange(propertyName, oldValue, newValue);
        if ("value".equals(propertyName) && this.isObfuscateDisplayTextRequired() && this.filterPropertyChangeEvent(event = new PropertyChangeEvent(this.getModel(), "displayText", null, ((IStringField)this.getModel()).getDisplayText())) != null) {
            this.addPropertyChangeEvent(PROP_INPUT_OBFUSCATED, (Object)true);
            this.addPropertyChangeEvent("displayText", (Object)OBFUSCATED_DISPLAY_TEXT);
        }
    }

    @Override
    protected void handleModelPropertyChange(PropertyChangeEvent event) {
        super.handleModelPropertyChange(event);
        if ("inputMasked".equals(event.getPropertyName()) && !BooleanUtility.nvl((Boolean)((Boolean)event.getNewValue()))) {
            JsonProperty<?> displayTextProperty = this.getJsonProperty("displayText");
            this.addPropertyChangeEvent(PROP_INPUT_OBFUSCATED, (Object)false);
            this.addPropertyChangeEvent(displayTextProperty, (Object)((IStringField)this.getModel()).getDisplayText());
        }
    }

    protected boolean isObfuscateDisplayTextRequired() {
        return !((IStringField)this.getModel()).isMultilineText() && ((IStringField)this.getModel()).isInputMasked() && !StringUtility.isNullOrEmpty((CharSequence)((IStringField)this.getModel()).getDisplayText());
    }
}

