/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.form.fields.radiobutton;

import org.eclipse.scout.rt.client.ui.form.fields.button.IButtonUIFacade;
import org.eclipse.scout.rt.client.ui.form.fields.button.IRadioButton;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.form.fields.button.JsonButton;
import org.json.JSONObject;

public class JsonRadioButton<RADIO_BUTTON extends IRadioButton<?>>
extends JsonButton<RADIO_BUTTON> {
    private static final String SELECTED = "selected";

    public JsonRadioButton(RADIO_BUTTON model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "RadioButton";
    }

    @Override
    protected void initJsonProperties(RADIO_BUTTON model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<IRadioButton<?>>("wrapText", (IRadioButton)model){

            @Override
            protected Boolean modelValue() {
                return ((IRadioButton)this.getModel()).isWrapText();
            }
        });
    }

    @Override
    protected void handleUiPropertyChange(String propertyName, JSONObject data) {
        if (SELECTED.equals(propertyName)) {
            boolean selected = data.getBoolean(propertyName);
            this.addPropertyEventFilterCondition(propertyName, selected);
            IButtonUIFacade uiFacade = ((IRadioButton)this.getModel()).getUIFacade();
            uiFacade.setSelectedFromUI(selected);
            if (selected) {
                uiFacade.fireButtonClickFromUI();
            }
        } else {
            super.handleUiPropertyChange(propertyName, data);
        }
    }
}

