/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.form.fields.filechooserfield;

import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.client.ui.form.fields.filechooserfield.IFileChooserField;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.basic.filechooser.JsonFileChooserAcceptAttributeBuilder;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonValueField;
import org.eclipse.scout.rt.ui.html.res.IBinaryResourceConsumer;
import org.json.JSONArray;

public class JsonFileChooserField<M extends IFileChooserField>
extends JsonValueField<M>
implements IBinaryResourceConsumer {
    protected static final String PROP_ACCEPT_TYPES = "acceptTypes";

    public JsonFileChooserField(M model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    protected void initJsonProperties(M model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<M>("maximumUploadSize", (IFileChooserField)model){

            @Override
            protected Long modelValue() {
                return ((IFileChooserField)this.getModel()).getMaximumUploadSize();
            }
        });
        this.putJsonProperty(new JsonProperty<M>("fileExtensions", (IFileChooserField)model){

            @Override
            protected List<String> modelValue() {
                return ((IFileChooserField)this.getModel()).getFileExtensions();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                List fileExtensions = (List)value;
                return new JSONArray(((JsonFileChooserAcceptAttributeBuilder)BEANS.get(JsonFileChooserAcceptAttributeBuilder.class)).withTypes(fileExtensions).build());
            }

            @Override
            public String jsonPropertyName() {
                return JsonFileChooserField.PROP_ACCEPT_TYPES;
            }
        });
    }

    @Override
    public String getObjectType() {
        return "FileChooserField";
    }

    @Override
    protected void handleUiAcceptInputAfterTyping(String displayText) {
        ((IFileChooserField)this.getModel()).getUIFacade().parseAndSetValueFromUI(displayText);
    }

    @Override
    public Collection<String> getAcceptedUploadFileExtensions() {
        return ((IFileChooserField)this.getModel()).getFileExtensions();
    }

    @Override
    public void consumeBinaryResource(List<BinaryResource> binaryResources, Map<String, String> uploadProperties) {
        if (!CollectionUtility.isEmpty(binaryResources)) {
            ((IFileChooserField)this.getModel()).setValue((Object)((BinaryResource)CollectionUtility.firstElement(binaryResources)));
        }
    }

    @Override
    protected void handleModelPropertyChange(PropertyChangeEvent event) {
        if ("value".equals(event.getPropertyName()) && ((IFileChooserField)this.getModel()).getValue() == null) {
            this.addPropertyChangeEvent("value", null);
        } else {
            super.handleModelPropertyChange(event);
        }
    }

    @Override
    public long getMaximumUploadSize() {
        return ((IFileChooserField)this.getModel()).getMaximumUploadSize();
    }
}

