/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.form.fields.button;

import java.util.List;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonEventType;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonFormField;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceHolder;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceUrlUtility;
import org.eclipse.scout.rt.ui.html.res.IBinaryResourceProvider;
import org.json.JSONObject;

public class JsonButton<BUTTON extends IButton>
extends JsonFormField<BUTTON>
implements IBinaryResourceProvider {
    public static final String PROP_SYSTEM_TYPE = "systemType";
    public static final String PROP_PROCESS_BUTTON = "processButton";
    public static final String PROP_DEFAULT_BUTTON = "defaultButton";
    public static final String PROP_DISPLAY_STYLE = "displayStyle";

    public JsonButton(BUTTON model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "Button";
    }

    @Override
    protected void initJsonProperties(BUTTON model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<BUTTON>("label", (IButton)model){

            @Override
            protected String modelValue() {
                return ((IButton)this.getModel()).getLabel();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return BinaryResourceUrlUtility.replaceImageUrls(JsonButton.this, (String)value);
            }
        });
        this.putJsonProperty(new JsonProperty<IButton>(PROP_SYSTEM_TYPE, model){

            @Override
            protected Integer modelValue() {
                return ((IButton)this.getModel()).getSystemType();
            }
        });
        this.putJsonProperty(new JsonProperty<IButton>(PROP_PROCESS_BUTTON, model){

            @Override
            protected Boolean modelValue() {
                return ((IButton)this.getModel()).isProcessButton();
            }
        });
        this.putJsonProperty(new JsonProperty<IButton>(PROP_DEFAULT_BUTTON, model){

            @Override
            protected Boolean modelValue() {
                return ((IButton)this.getModel()).getDefaultButton();
            }
        });
        this.putJsonProperty(new JsonProperty<IButton>(PROP_DISPLAY_STYLE, model){

            @Override
            protected Integer modelValue() {
                return ((IButton)this.getModel()).getDisplayStyle();
            }
        });
        this.putJsonProperty(new JsonProperty<IButton>("selected", model){

            @Override
            protected Boolean modelValue() {
                return ((IButton)this.getModel()).isSelected();
            }
        });
        this.putJsonProperty(new JsonProperty<IButton>("iconId", model){

            @Override
            protected String modelValue() {
                return ((IButton)this.getModel()).getIconId();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return BinaryResourceUrlUtility.createIconUrl((String)value);
            }
        });
        this.putJsonProperty(new JsonProperty<IButton>("keyStroke", model){

            @Override
            protected String modelValue() {
                return ((IButton)this.getModel()).getKeyStroke();
            }
        });
        this.putJsonProperty(new JsonProperty<IButton>("preventDoubleClick", model){

            @Override
            protected Boolean modelValue() {
                return ((IButton)this.getModel()).isPreventDoubleClick();
            }
        });
        this.putJsonProperty(new JsonProperty<IButton>("stackable", model){

            @Override
            protected Boolean modelValue() {
                return ((IButton)this.getModel()).isStackable();
            }
        });
        this.putJsonProperty(new JsonProperty<IButton>("shrinkable", model){

            @Override
            protected Boolean modelValue() {
                return ((IButton)this.getModel()).isShrinkable();
            }
        });
    }

    @Override
    public JSONObject toJson() {
        List<IJsonAdapter<Object>> adapterList;
        JSONObject json = super.toJson();
        IJsonAdapter<Object> adapter = null;
        if (((IButton)this.getModel()).getKeyStrokeScope() != null && !(adapterList = this.getUiSession().getJsonAdapters(((IButton)this.getModel()).getKeyStrokeScope())).isEmpty()) {
            adapter = adapterList.get(0);
        }
        if (adapter != null) {
            json.put("keyStrokeScope", (Object)adapter.getId());
        }
        return json;
    }

    @Override
    public void handleUiEvent(JsonEvent event) {
        if (JsonEventType.CLICK.matches(event)) {
            ((IButton)this.getModel()).getUIFacade().fireButtonClickFromUI();
        } else {
            super.handleUiEvent(event);
        }
    }

    @Override
    protected void handleUiPropertyChange(String propertyName, JSONObject data) {
        if ("selected".equals(propertyName)) {
            this.handleUiSelectedChange(data);
        } else {
            super.handleUiPropertyChange(propertyName, data);
        }
    }

    protected void handleUiSelectedChange(JSONObject data) {
        boolean selected = data.getBoolean("selected");
        this.addPropertyEventFilterCondition("selected", selected);
        ((IButton)this.getModel()).getUIFacade().setSelectedFromUI(selected);
    }

    @Override
    public BinaryResourceHolder provideBinaryResource(String filenameWithFingerprint) {
        return BinaryResourceUrlUtility.provideBinaryResource(filenameWithFingerprint, arg_0 -> ((IButton)((IButton)this.getModel())).getAttachment(arg_0));
    }
}

