/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.form.fields.browserfield;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.ui.form.fields.browserfield.BrowserFieldEvent;
import org.eclipse.scout.rt.client.ui.form.fields.browserfield.BrowserFieldListener;
import org.eclipse.scout.rt.client.ui.form.fields.browserfield.IBrowserField;
import org.eclipse.scout.rt.client.ui.form.fields.browserfield.IBrowserFieldUIFacade;
import org.eclipse.scout.rt.dataobject.DoList;
import org.eclipse.scout.rt.dataobject.IDataObject;
import org.eclipse.scout.rt.dataobject.IDataObjectMapper;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonFormField;
import org.eclipse.scout.rt.ui.html.json.form.fields.browserfield.BrowserFieldContentHttpResponseInterceptor;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceHolder;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceUrlUtility;
import org.eclipse.scout.rt.ui.html.res.IBinaryResourceProvider;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonBrowserField<BROWSER_FIELD extends IBrowserField>
extends JsonFormField<BROWSER_FIELD>
implements IBinaryResourceProvider {
    private BrowserFieldListener m_browserFieldListener;
    public static final String EVENT_POST_MESSAGE = "postMessage";
    public static final String EVENT_EXTERNAL_WINDOW_STATE_CHANGE = "externalWindowStateChange";

    public JsonBrowserField(BROWSER_FIELD model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "BrowserField";
    }

    @Override
    protected void initJsonProperties(BROWSER_FIELD model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<IBrowserField>("scrollBarEnabled", model){

            @Override
            protected Boolean modelValue() {
                return ((IBrowserField)this.getModel()).isScrollBarEnabled();
            }
        });
        this.putJsonProperty(new JsonProperty<IBrowserField>("sandboxEnabled", model){

            @Override
            protected Boolean modelValue() {
                return ((IBrowserField)this.getModel()).isSandboxEnabled();
            }
        });
        this.putJsonProperty(new JsonProperty<IBrowserField>("sandboxPermissions", model){

            @Override
            protected Set<IBrowserField.SandboxPermission> modelValue() {
                return ((IBrowserField)this.getModel()).getSandboxPermissions();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                Set sandbox = (Set)value;
                if (sandbox == null || sandbox.isEmpty()) {
                    return "";
                }
                StringBuilder sb = new StringBuilder();
                for (IBrowserField.SandboxPermission sandboxValue : sandbox) {
                    sb.append(sandboxValue.getAttribute()).append(" ");
                }
                sb.deleteCharAt(sb.length() - 1);
                return sb.toString();
            }
        });
        this.putJsonProperty(new JsonProperty<IBrowserField>("trustedMessageOrigins", model){

            @Override
            protected List<String> modelValue() {
                return ((IBrowserField)this.getModel()).getTrustedMessageOrigins();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                if (value == null) {
                    return JSONObject.NULL;
                }
                return new JSONArray((Collection)value);
            }
        });
        this.putJsonProperty(new JsonProperty<IBrowserField>("showInExternalWindow", model){

            @Override
            protected Boolean modelValue() {
                return ((IBrowserField)this.getModel()).isShowInExternalWindow();
            }
        });
        this.putJsonProperty(new JsonProperty<IBrowserField>("externalWindowButtonText", model){

            @Override
            protected String modelValue() {
                return ((IBrowserField)this.getModel()).getExternalWindowButtonText();
            }
        });
        this.putJsonProperty(new JsonProperty<IBrowserField>("externalWindowFieldText", model){

            @Override
            protected String modelValue() {
                return ((IBrowserField)this.getModel()).getExternalWindowFieldText();
            }
        });
        this.putJsonProperty(new JsonProperty<IBrowserField>("autoCloseExternalWindow", model){

            @Override
            protected Boolean modelValue() {
                return ((IBrowserField)this.getModel()).isAutoCloseExternalWindow();
            }
        });
        this.putJsonProperty(new JsonProperty<IBrowserField>("trackLocation", model){

            @Override
            protected Boolean modelValue() {
                return ((IBrowserField)this.getModel()).isTrackLocation();
            }
        });
    }

    @Override
    protected void attachModel() {
        super.attachModel();
        if (this.m_browserFieldListener != null) {
            throw new IllegalStateException();
        }
        this.m_browserFieldListener = new P_BrowserFieldListener();
        ((IBrowserField)this.getModel()).addBrowserFieldListener(this.m_browserFieldListener);
    }

    @Override
    protected void detachModel() {
        super.detachModel();
        if (this.m_browserFieldListener == null) {
            throw new IllegalStateException();
        }
        ((IBrowserField)this.getModel()).removeBrowserFieldListener(this.m_browserFieldListener);
        this.m_browserFieldListener = null;
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        this.putProperty(json, "location", this.getLocation());
        return json;
    }

    @Override
    public BinaryResourceHolder provideBinaryResource(String filenameWithFingerprint) {
        BinaryResourceHolder holder = BinaryResourceUrlUtility.provideBinaryResource(filenameWithFingerprint, arg_0 -> ((IBrowserFieldUIFacade)((IBrowserField)this.getModel()).getUIFacade()).requestBinaryResourceFromUI(arg_0));
        if (holder != null) {
            holder.addHttpResponseInterceptor(new BrowserFieldContentHttpResponseInterceptor(this.getUiSession()));
        }
        return holder;
    }

    protected void handleModelContentChanged() {
        this.addPropertyChangeEvent("location", (Object)this.getLocation());
    }

    protected void handleModelPostMessage(Object message, String targetOrigin) {
        JSONObject eventData = new JSONObject();
        eventData.put("message", this.messageToJson(message));
        eventData.put("targetOrigin", (Object)targetOrigin);
        this.addActionEvent(EVENT_POST_MESSAGE, eventData);
    }

    protected Object messageToJson(Object message) {
        if (message == null) {
            return JSONObject.NULL;
        }
        if (message instanceof IDataObject) {
            IDataObjectMapper mapper = (IDataObjectMapper)BEANS.get(IDataObjectMapper.class);
            String str = mapper.writeValue(message);
            if (message instanceof DoList) {
                return new JSONArray(str);
            }
            return new JSONObject(str);
        }
        if (message instanceof String || message instanceof Number || message instanceof Boolean) {
            return message;
        }
        throw new IllegalArgumentException("Unsupported message type: " + String.valueOf(message));
    }

    protected void handleModelBrowserFieldEvent(BrowserFieldEvent event) {
        if (900 == event.getType()) {
            this.handleModelContentChanged();
        } else if (901 == event.getType()) {
            this.handleModelPostMessage(event.getMessage(), event.getTargetOrigin());
        }
    }

    @Override
    public void handleUiEvent(JsonEvent event) {
        if (EVENT_POST_MESSAGE.equals(event.getType())) {
            this.handleUiPostMessage(event);
        } else if (EVENT_EXTERNAL_WINDOW_STATE_CHANGE.equals(event.getType())) {
            this.handleUiExternalWindowStateChange(event);
        } else {
            super.handleUiEvent(event);
        }
    }

    @Override
    protected void handleUiPropertyChange(String propertyName, JSONObject data) {
        if ("location".equals(propertyName)) {
            this.handleUiLocationChange(data);
        } else {
            super.handleUiPropertyChange(propertyName, data);
        }
    }

    protected void handleUiLocationChange(JSONObject data) {
        String location = data.optString("location", null);
        this.addPropertyEventFilterCondition("location", location);
        ((IBrowserField)this.getModel()).getUIFacade().setLocationFromUI(location);
    }

    protected void handleUiPostMessage(JsonEvent event) {
        Object data = event.getData().opt("data");
        String origin = event.getData().optString("origin", null);
        if (data instanceof JSONObject || data instanceof JSONArray) {
            IDataObjectMapper mapper = (IDataObjectMapper)BEANS.opt(IDataObjectMapper.class);
            data = mapper != null ? mapper.readValue(data.toString(), IDataObject.class) : data.toString();
        }
        ((IBrowserField)this.getModel()).getUIFacade().firePostMessageFromUI(data, origin);
    }

    protected void handleUiExternalWindowStateChange(JsonEvent event) {
        ((IBrowserField)this.getModel()).getUIFacade().firePostExternalWindowStateFromUI(event.getData().optBoolean("windowState"));
    }

    protected String getLocation() {
        String location = ((IBrowserField)this.getModel()).getLocation();
        BinaryResource binaryResource = ((IBrowserField)this.getModel()).getBinaryResource();
        if (location == null && binaryResource != null) {
            location = BinaryResourceUrlUtility.createDynamicAdapterResourceUrl(this, binaryResource);
        }
        return location;
    }

    protected class P_BrowserFieldListener
    implements BrowserFieldListener {
        protected P_BrowserFieldListener() {
        }

        public void browserFieldChanged(BrowserFieldEvent e) {
            ModelJobs.assertModelThread();
            JsonBrowserField.this.handleModelBrowserFieldEvent(e);
        }
    }
}

