/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.form.fields.browserfield;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URI;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.UriUtility;
import org.eclipse.scout.rt.server.commons.servlet.ContentSecurityPolicy;
import org.eclipse.scout.rt.server.commons.servlet.HttpClientInfo;
import org.eclipse.scout.rt.server.commons.servlet.cache.IHttpResponseInterceptor;
import org.eclipse.scout.rt.ui.html.IUiSession;

public class BrowserFieldContentHttpResponseInterceptor
implements IHttpResponseInterceptor {
    private static final long serialVersionUID = 1L;
    private final URI m_browserUri;

    public BrowserFieldContentHttpResponseInterceptor(IUiSession uiSession) {
        this.m_browserUri = uiSession.getClientSession().getBrowserURI();
    }

    public void intercept(HttpServletRequest req, HttpServletResponse resp) {
        String cspToken = this.getContentSecurityPolicy(req).toToken();
        if (HttpClientInfo.get((HttpServletRequest)req).isMshtml()) {
            resp.setHeader("X-Content-Security-Policy", cspToken);
        } else {
            resp.setHeader("Content-Security-Policy", cspToken);
        }
    }

    protected ContentSecurityPolicy getContentSecurityPolicy(HttpServletRequest req) {
        ContentSecurityPolicy csp = (ContentSecurityPolicy)BEANS.get(ContentSecurityPolicy.class);
        String baseUri = UriUtility.toBaseUri((URI)this.m_browserUri);
        if (baseUri != null) {
            csp.withReportUri(baseUri + "csp-report");
            if (HttpClientInfo.get((HttpServletRequest)req).isWebkit()) {
                csp.appendImgSrc(baseUri);
                csp.appendStyleSrc(baseUri);
            }
        }
        return csp;
    }
}

