/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.form.fields;

import java.util.function.Predicate;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterPropertyConfig;

public class JsonAdapterPropertyConfigBuilder {
    private static final JsonAdapterPropertyConfig DEFAULT = new JsonAdapterPropertyConfig();
    private static final JsonAdapterPropertyConfig GLOBAL = new JsonAdapterPropertyConfigBuilder().global().build();
    private Predicate<Object> m_global;
    private boolean m_disposeOnChange = true;
    private Predicate<?> m_filter;

    public JsonAdapterPropertyConfigBuilder global() {
        this.m_global = model -> true;
        this.m_disposeOnChange = false;
        return this;
    }

    public JsonAdapterPropertyConfigBuilder global(Predicate<Object> global) {
        this.m_global = global;
        return this;
    }

    public JsonAdapterPropertyConfigBuilder disposeOnChange(boolean disposeOnChange) {
        this.m_disposeOnChange = disposeOnChange;
        return this;
    }

    public JsonAdapterPropertyConfigBuilder filter(Predicate<?> filter) {
        this.m_filter = filter;
        return this;
    }

    public JsonAdapterPropertyConfig build() {
        return new JsonAdapterPropertyConfig(this.m_global, this.m_disposeOnChange, this.m_filter);
    }

    public static JsonAdapterPropertyConfig defaultConfig() {
        return DEFAULT;
    }

    public static JsonAdapterPropertyConfig globalConfig() {
        return GLOBAL;
    }
}

