/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.form.fields;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonAdapterUtility;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterPropertyConfig;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterPropertyConfigBuilder;

public abstract class JsonAdapterProperty<MODEL_ELEMENT>
extends JsonProperty<MODEL_ELEMENT> {
    private final IUiSession m_uiSession;
    private final Predicate<Object> m_global;
    private final boolean m_disposeOnChange;
    private final Predicate<Object> m_filter;
    private final Set<IJsonAdapter<?>> m_ownedAdapters = new HashSet();

    public JsonAdapterProperty(String propertyName, MODEL_ELEMENT model, IUiSession session) {
        super(propertyName, model);
        this.m_uiSession = session;
        JsonAdapterPropertyConfig config = this.createConfig();
        this.m_global = config.getGlobal();
        this.m_disposeOnChange = config.isDisposeOnChange();
        this.m_filter = config.getFilter();
    }

    protected JsonAdapterPropertyConfig createConfig() {
        return JsonAdapterPropertyConfigBuilder.defaultConfig();
    }

    protected IUiSession getUiSession() {
        return this.m_uiSession;
    }

    protected boolean isGlobal() {
        return this.isGlobal(null);
    }

    protected boolean isGlobal(Object model) {
        return this.m_global.test(model);
    }

    public boolean isDisposeOnChange() {
        return this.m_disposeOnChange;
    }

    protected Predicate<Object> getFilter() {
        return this.m_filter;
    }

    protected Set<IJsonAdapter<?>> getOwnedAdapters() {
        return this.m_ownedAdapters;
    }

    @Override
    public void handlePropertyChange(Object oldValue, Object newValue) {
        if (this.m_disposeOnChange) {
            this.disposeObsoleteAdapters(newValue);
        }
        this.createAdapters(newValue);
    }

    @Override
    public Object prepareValueForToJson(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            return JsonAdapterUtility.getAdapterIdsForModel(this.getUiSession(), (Collection)value, this.getParentJsonAdapter(), this.m_filter);
        }
        return JsonAdapterUtility.getAdapterIdForModel(this.getUiSession(), value, this.getParentJsonAdapter(), this.m_filter);
    }

    public void createAdapters() {
        this.createAdapters(this.modelValue());
    }

    protected void createAdapters(Object modelValue) {
        if (modelValue == null) {
            return;
        }
        if (modelValue instanceof Collection) {
            for (Object model : (Iterable)modelValue) {
                this.createAdapter(model);
            }
        } else {
            this.createAdapter(modelValue);
        }
    }

    protected void createAdapter(Object model) {
        if (!this.accept()) {
            return;
        }
        if (this.isGlobal(model)) {
            this.m_uiSession.getRootJsonAdapter().attachAdapter(model, this.m_filter);
        } else {
            Object adapter = this.getParentJsonAdapter().attachAdapter(model, this.m_filter);
            if (this.m_disposeOnChange && adapter != null && adapter.getParent() == this.getParentJsonAdapter()) {
                this.m_ownedAdapters.add((IJsonAdapter<?>)adapter);
            }
        }
    }

    protected void disposeObsoleteAdapters(Object newModels) {
        HashSet attachedAdapters = new HashSet(this.m_ownedAdapters);
        for (IJsonAdapter iJsonAdapter : attachedAdapters) {
            if (newModels instanceof Collection) {
                if (((Collection)newModels).contains(iJsonAdapter.getModel())) continue;
                this.disposeAdapter(iJsonAdapter);
                continue;
            }
            this.disposeAdapter(iJsonAdapter);
        }
    }

    public void disposeAdapter(IJsonAdapter<?> adapter) {
        adapter.dispose();
        this.m_ownedAdapters.remove(adapter);
    }

    @Override
    public void attachChildAdapters() {
        this.createAdapters();
    }
}

