/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.form;

import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.ui.IDisplayParent;
import org.eclipse.scout.rt.client.ui.IEventHistory;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.AbstractJsonWidget;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonAdapterUtility;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.JsonStatus;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterProperty;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceUrlUtility;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonForm<FORM extends IForm>
extends AbstractJsonWidget<FORM> {
    private static final Logger LOG = LoggerFactory.getLogger(JsonForm.class);
    public static final String PROP_FORM_ID = "formId";
    public static final String PROP_TITLE = "title";
    public static final String PROP_SUB_TITLE = "subTitle";
    public static final String PROP_ICON_ID = "iconId";
    public static final String PROP_CLOSABLE = "closable";
    public static final String PROP_SAVE_NEEDED_VISIBLE = "saveNeededVisible";
    public static final String PROP_MODAL = "modal";
    public static final String PROP_DISPLAY_HINT = "displayHint";
    public static final String PROP_DISPLAY_VIEW_ID = "displayViewId";
    public static final String PROP_SAVE_NEEDED = "saveNeeded";
    public static final String PROP_CACHE_BOUNDS = "cacheBounds";
    public static final String PROP_CACHE_BOUNDS_KEY = "cacheBoundsKey";
    public static final String PROP_FORM_FIELD = "formField";
    public static final String PROP_ROOT_GROUP_BOX = "rootGroupBox";
    public static final String PROP_INITIAL_FOCUS = "initialFocus";
    public static final String EVENT_FORM_CLOSING = "formClosing";
    public static final String EVENT_CLOSE = "close";
    public static final String EVENT_REQUEST_FOCUS = "requestFocus";
    public static final String EVENT_REQUEST_INPUT = "requestInput";
    private final IDesktop m_desktop;
    private FormListener m_formListener;

    public JsonForm(FORM form, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(form, uiSession, id, parent);
        this.m_desktop = uiSession.getClientSession().getDesktop();
    }

    @Override
    public String getObjectType() {
        return "Form";
    }

    @Override
    public void init() {
        super.init();
        IEventHistory eventHistory = ((IForm)this.getModel()).getEventHistory();
        if (eventHistory != null) {
            for (FormEvent event : eventHistory.getRecentEvents()) {
                this.handleModelFormChanged(event);
            }
        }
    }

    @Override
    protected void initJsonProperties(FORM model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonAdapterProperty<FORM>(PROP_ROOT_GROUP_BOX, (IForm)model, this.getUiSession()){

            protected IGroupBox modelValue() {
                return ((IForm)this.getModel()).getRootGroupBox();
            }
        });
        this.putJsonProperty(new JsonProperty<IForm>(PROP_MODAL, model){

            @Override
            protected Boolean modelValue() {
                return ((IForm)this.getModel()).isModal();
            }
        });
        this.putJsonProperty(new JsonProperty<IForm>(PROP_CACHE_BOUNDS, model){

            @Override
            protected Boolean modelValue() {
                return ((IForm)this.getModel()).isCacheBounds();
            }
        });
        this.putJsonProperty(new JsonProperty<IForm>(PROP_CACHE_BOUNDS_KEY, model){

            @Override
            protected String modelValue() {
                return ((IForm)this.getModel()).computeCacheBoundsKey();
            }

            @Override
            public boolean accept() {
                return ((IForm)this.getModel()).isCacheBounds();
            }
        });
        this.putJsonProperty(new JsonProperty<IForm>(PROP_DISPLAY_VIEW_ID, model){

            @Override
            protected String modelValue() {
                return ((IForm)this.getModel()).getDisplayViewId();
            }
        });
        this.putJsonProperty(new JsonProperty<IForm>("headerVisible", model){

            @Override
            protected Boolean modelValue() {
                return ((IForm)this.getModel()).isHeaderVisible();
            }
        });
        this.putJsonProperty(new JsonProperty<IForm>(PROP_TITLE, model){

            @Override
            protected String modelValue() {
                return ((IForm)this.getModel()).getTitle();
            }
        });
        this.putJsonProperty(new JsonProperty<IForm>(PROP_SUB_TITLE, model){

            @Override
            protected String modelValue() {
                return ((IForm)this.getModel()).getSubTitle();
            }
        });
        this.putJsonProperty(new JsonProperty<IForm>(PROP_ICON_ID, model){

            @Override
            protected String modelValue() {
                return ((IForm)this.getModel()).getIconId();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return BinaryResourceUrlUtility.createIconUrl((String)value);
            }
        });
        this.putJsonProperty(new JsonProperty<IForm>(PROP_CLOSABLE, model){

            @Override
            protected Boolean modelValue() {
                return ((IForm)this.getModel()).isClosable();
            }
        });
        this.putJsonProperty(new JsonProperty<IForm>(PROP_SAVE_NEEDED_VISIBLE, model){

            @Override
            protected Boolean modelValue() {
                return ((IForm)this.getModel()).isSaveNeededVisible();
            }
        });
        this.putJsonProperty(new JsonProperty<IForm>(PROP_SAVE_NEEDED, model){

            @Override
            protected Boolean modelValue() {
                return ((IForm)this.getModel()).isSaveNeeded();
            }
        });
        this.putJsonProperty(new JsonProperty<IForm>("status", model){

            protected IStatus modelValue() {
                return ((IForm)this.getModel()).getStatus();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return JsonStatus.toJson((IStatus)value);
            }
        });
        this.putJsonProperty(new JsonProperty<IForm>("maximized", model){

            @Override
            protected Boolean modelValue() {
                return ((IForm)this.getModel()).isMaximized();
            }
        });
    }

    @Override
    protected void attachChildAdapters() {
        super.attachChildAdapters();
        this.attachGlobalAdapters(this.m_desktop.getViews((IDisplayParent)this.getModel()));
        this.attachGlobalAdapters(this.m_desktop.getDialogs((IDisplayParent)this.getModel(), false));
        this.attachGlobalAdapters(this.m_desktop.getMessageBoxes((IDisplayParent)this.getModel()));
        this.attachGlobalAdapters(this.m_desktop.getFileChoosers((IDisplayParent)this.getModel()));
        this.addInitialInputEvent();
    }

    @Override
    protected void attachModel() {
        super.attachModel();
        Assertions.assertNull((Object)this.m_formListener);
        this.m_formListener = new P_FormListener();
        ((IForm)this.getModel()).addUIFormListener(this.m_formListener, new Integer[0]);
    }

    @Override
    protected void detachModel() {
        super.detachModel();
        Assertions.assertNotNull((Object)this.m_formListener);
        ((IForm)this.getModel()).removeFormListener(this.m_formListener, new Integer[0]);
        this.m_formListener = null;
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        this.putProperty(json, PROP_DISPLAY_HINT, this.displayHintToJson(((IForm)this.getModel()).getDisplayHint()));
        this.setInitialFocusProperty(json);
        this.putAdapterIdsProperty(json, "views", this.m_desktop.getViews((IDisplayParent)this.getModel()));
        this.putAdapterIdsProperty(json, "dialogs", this.m_desktop.getDialogs((IDisplayParent)this.getModel(), false));
        this.putAdapterIdsProperty(json, "messageBoxes", this.m_desktop.getMessageBoxes((IDisplayParent)this.getModel()));
        this.putAdapterIdsProperty(json, "fileChoosers", this.m_desktop.getFileChoosers((IDisplayParent)this.getModel()));
        return json;
    }

    protected void addInitialInputEvent() {
        FormEvent event = this.findRecentEvent(6030);
        if (event != null) {
            this.handleModelRequestEvent(event, true);
        }
    }

    protected void setInitialFocusProperty(JSONObject json) {
        IJsonAdapter<?> childAdapter;
        FormEvent event = this.findRecentEvent(6020);
        if (event != null && (childAdapter = this.findChildAdapter(event)) != null) {
            this.putProperty(json, PROP_INITIAL_FOCUS, childAdapter.getId());
        }
    }

    protected IJsonAdapter<?> findChildAdapter(FormEvent event) {
        IJsonAdapter<?> childAdapter = JsonAdapterUtility.findChildAdapter(this, (IWidget)event.getFormField());
        if (childAdapter == null) {
            LOG.error("Cannot handle form-event {}, because adapter for {} could not be resolved in {}", new Object[]{event.getType(), event.getFormField(), this});
        }
        return childAdapter;
    }

    protected FormEvent findRecentEvent(int eventType) {
        IEventHistory history = ((IForm)this.getModel()).getEventHistory();
        if (history == null) {
            return null;
        }
        for (FormEvent event : history.getRecentEvents()) {
            if (event.getType() != eventType) continue;
            return event;
        }
        return null;
    }

    protected String displayHintToJson(int displayHint) {
        switch (displayHint) {
            case 0: {
                return "dialog";
            }
            case 20: {
                return "view";
            }
            case 10: {
                return "popupWindow";
            }
        }
        return null;
    }

    protected void handleModelFormChanged(FormEvent event) {
        switch (event.getType()) {
            case 3010: {
                this.handleModelFormClosed(event.getForm());
                break;
            }
            case 6020: 
            case 6030: {
                this.handleModelRequestEvent(event, false);
            }
        }
    }

    protected void handleModelFormClosed(IForm form) {
        this.dispose();
        this.getUiSession().sendDisposeAdapterEvent(this);
    }

    protected void handleModelRequestEvent(FormEvent event, boolean protect) {
        IJsonAdapter<?> childAdapter = this.findChildAdapter(event);
        if (childAdapter != null) {
            JSONObject json = new JSONObject();
            this.putProperty(json, PROP_FORM_FIELD, childAdapter.getId());
            JsonEvent jsonEvent = this.addActionEvent(this.getRequestEventName(event.getType()), json);
            if (protect) {
                jsonEvent.protect();
            }
        }
    }

    protected String getRequestEventName(int eventType) {
        switch (eventType) {
            case 6020: {
                return EVENT_REQUEST_FOCUS;
            }
            case 6030: {
                return EVENT_REQUEST_INPUT;
            }
        }
        throw new IllegalArgumentException("Unsupported event type");
    }

    @Override
    public void handleUiEvent(JsonEvent event) {
        if (EVENT_FORM_CLOSING.equals(event.getType())) {
            this.handleUiFormClosing(event);
        } else if (EVENT_CLOSE.equals(event.getType())) {
            this.handleUiClose(event);
        }
    }

    public void handleUiFormClosing(JsonEvent event) {
        ((IForm)this.getModel()).getUIFacade().fireFormClosingFromUI();
    }

    public void handleUiClose(JsonEvent event) {
        ((IForm)this.getModel()).getUIFacade().fireFormKilledFromUI();
    }

    protected class P_FormListener
    implements FormListener {
        protected P_FormListener() {
        }

        public void formChanged(FormEvent e) {
            ModelJobs.assertModelThread();
            JsonForm.this.handleModelFormChanged(e);
        }
    }
}

