/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.desktop.hybrid.uicallback;

import java.util.Optional;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.HybridActionContextElements;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.uicallback.UiCallbackEvent;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.uicallback.UiCallbacks;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.LazyValue;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.event.IEventListener;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.AbstractJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonDataObjectHelper;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.desktop.hybrid.JsonHybridHelper;
import org.eclipse.scout.rt.ui.html.json.desktop.hybrid.uicallback.UiCallbackErrorDo;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonUiCallbacks<T extends UiCallbacks>
extends AbstractJsonAdapter<T> {
    protected static final String EVENT_CALLBACK = "callback";
    protected static final String EVENT_CALLBACK_END = "callbackEnd";
    private final LazyValue<JsonDataObjectHelper> m_jsonDoHelper = new LazyValue(JsonDataObjectHelper.class);
    private IEventListener<UiCallbackEvent> m_listener;

    public JsonUiCallbacks(T model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "UiCallbacks";
    }

    protected JsonDataObjectHelper jsonDoHelper() {
        return (JsonDataObjectHelper)this.m_jsonDoHelper.get();
    }

    @Override
    protected void attachModel() {
        super.attachModel();
        if (this.m_listener != null) {
            throw new IllegalStateException();
        }
        this.m_listener = new P_UiCallbacksListener();
        ((UiCallbacks)this.getModel()).getEventSupport().addListener(this.m_listener);
    }

    @Override
    protected void detachModel() {
        super.detachModel();
        if (this.m_listener == null) {
            throw new IllegalStateException();
        }
        ((UiCallbacks)this.getModel()).getEventSupport().removeListener(this.m_listener);
        this.m_listener = null;
    }

    protected void handleModelEvent(UiCallbackEvent event) {
        this.handleModelCallback(event);
    }

    protected void handleModelCallback(UiCallbackEvent event) {
        String ownerId = Optional.ofNullable(event.getOwner()).flatMap(owner -> this.getUiSession().getJsonAdapters(owner).stream().findAny()).map(IJsonAdapter::getId).orElse(null);
        JSONObject json = new JSONObject().put("id", (Object)event.getCallbackId()).put("owner", (Object)ownerId).put("handlerObjectType", (Object)event.getJsHandlerObjectType()).put("data", (Object)this.jsonDoHelper().dataObjectToJson(event.getData())).putOpt("contextElements", (Object)((JsonHybridHelper)BEANS.get(JsonHybridHelper.class)).contextElementsToJson(this.getUiSession(), event.getContextElements()));
        this.addActionEvent(EVENT_CALLBACK, json);
    }

    @Override
    public void handleUiEvent(JsonEvent event) {
        if (EVENT_CALLBACK_END.equals(event.getType())) {
            this.handleUiCallbackEnd(event);
        } else {
            super.handleUiEvent(event);
        }
    }

    protected void handleUiCallbackEnd(JsonEvent event) {
        JSONObject eventData = event.getData();
        String id = eventData.getString("id");
        if (StringUtility.isNullOrEmpty((CharSequence)id)) {
            return;
        }
        UiCallbackErrorDo error = this.jsonDoHelper().jsonToDataObject(eventData.optJSONObject("error"), UiCallbackErrorDo.class);
        if (error != null) {
            ((UiCallbacks)this.getModel()).getUIFacade().fireCallbackFailedFromUI(id, error.getMessage(), error.getCode());
        } else {
            Object data = this.parseData(eventData.opt("data"));
            HybridActionContextElements contextElements = ((JsonHybridHelper)BEANS.get(JsonHybridHelper.class)).jsonToContextElements(this.getUiSession(), eventData.optJSONObject("contextElements"));
            ((UiCallbacks)this.getModel()).getUIFacade().fireCallbackDoneFromUI(id, data, contextElements);
        }
    }

    protected Object parseData(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof JSONObject) {
            return this.jsonDoHelper().jsonToDataObject((JSONObject)data, IDoEntity.class);
        }
        if (data instanceof JSONArray) {
            return this.jsonDoHelper().jsonToDataObjects((JSONArray)data, IDoEntity.class);
        }
        return data;
    }

    protected class P_UiCallbacksListener
    implements IEventListener<UiCallbackEvent> {
        protected P_UiCallbacksListener() {
        }

        public void fireEvent(UiCallbackEvent e) {
            ModelJobs.assertModelThread();
            JsonUiCallbacks.this.handleModelEvent(e);
        }
    }
}

