/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.desktop.hybrid.converter;

import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.ui.html.json.desktop.hybrid.converter.AbstractHybridActionContextElementConverter;
import org.eclipse.scout.rt.ui.html.json.table.JsonTable;

public class TableRowContextElementConverter
extends AbstractHybridActionContextElementConverter<JsonTable<?>, String, ITableRow> {
    protected static final String JSON_ELEMENT_PREFIX = "row:";

    @Override
    protected boolean acceptJsonElementImpl(String jsonElement) {
        return StringUtility.startsWith((String)jsonElement, (String)JSON_ELEMENT_PREFIX);
    }

    @Override
    protected ITableRow jsonToElement(JsonTable<?> adapter, String jsonElement) {
        String rowId = StringUtility.removePrefix((String)jsonElement, (String)JSON_ELEMENT_PREFIX);
        return adapter.getTableRow(rowId);
    }

    @Override
    protected String elementToJson(JsonTable<?> adapter, ITableRow element) {
        adapter.processBufferedEvents();
        String rowId = adapter.getTableRowId(element);
        return StringUtility.addPrefix((String)rowId, (String)JSON_ELEMENT_PREFIX);
    }
}

