/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.desktop.hybrid.converter;

import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.ui.html.json.desktop.hybrid.converter.AbstractHybridActionContextElementConverter;
import org.eclipse.scout.rt.ui.html.json.table.JsonTable;

public class TableColumnContextElementConverter
extends AbstractHybridActionContextElementConverter<JsonTable<?>, String, IColumn<?>> {
    protected static final String JSON_ELEMENT_PREFIX = "col:";

    @Override
    protected boolean acceptJsonElementImpl(String jsonElement) {
        return StringUtility.startsWith((String)jsonElement, (String)JSON_ELEMENT_PREFIX);
    }

    @Override
    protected IColumn<?> jsonToElement(JsonTable<?> adapter, String jsonElement) {
        String columnId = StringUtility.removePrefix((String)jsonElement, (String)JSON_ELEMENT_PREFIX);
        return adapter.getColumn(columnId);
    }

    @Override
    protected String elementToJson(JsonTable<?> adapter, IColumn<?> element) {
        adapter.processBufferedEvents();
        String columnId = adapter.getColumnId(element);
        return StringUtility.addPrefix((String)columnId, (String)JSON_ELEMENT_PREFIX);
    }
}

