/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.desktop.hybrid.converter;

import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.desktop.hybrid.converter.IHybridActionContextElementConverter;

public abstract class AbstractHybridActionContextElementConverter<ADAPTER extends IJsonAdapter<?>, JSON_ELEMENT, MODEL_ELEMENT>
implements IHybridActionContextElementConverter<ADAPTER, JSON_ELEMENT, MODEL_ELEMENT> {
    private final Class<ADAPTER> m_adapterClass = (Class)Assertions.assertNotNull((Object)TypeCastUtility.getGenericsParameterClass(this.getClass(), AbstractHybridActionContextElementConverter.class, (int)0));
    private final Class<JSON_ELEMENT> m_jsonElementClass = (Class)Assertions.assertNotNull((Object)TypeCastUtility.getGenericsParameterClass(this.getClass(), AbstractHybridActionContextElementConverter.class, (int)1));
    private final Class<MODEL_ELEMENT> m_modelElementClass = (Class)Assertions.assertNotNull((Object)TypeCastUtility.getGenericsParameterClass(this.getClass(), AbstractHybridActionContextElementConverter.class, (int)2));

    protected AbstractHybridActionContextElementConverter() {
    }

    protected Class<ADAPTER> getAdapterClass() {
        return this.m_adapterClass;
    }

    protected Class<JSON_ELEMENT> getJsonElementClass() {
        return this.m_jsonElementClass;
    }

    protected Class<MODEL_ELEMENT> getModelElementClass() {
        return this.m_modelElementClass;
    }

    @Override
    public Object tryConvertFromJson(IJsonAdapter<?> adapter, Object jsonElement) {
        if (this.acceptAdapter(adapter) && this.acceptJsonElement(jsonElement)) {
            return this.jsonToElement((IJsonAdapter)this.getAdapterClass().cast(adapter), this.getJsonElementClass().cast(jsonElement));
        }
        return null;
    }

    @Override
    public Object tryConvertToJson(IJsonAdapter<?> adapter, Object modelElement) {
        if (this.acceptAdapter(adapter) && this.acceptModelElement(modelElement)) {
            return this.elementToJson((IJsonAdapter)this.getAdapterClass().cast(adapter), this.getModelElementClass().cast(modelElement));
        }
        return null;
    }

    protected boolean acceptAdapter(IJsonAdapter<?> adapter) {
        return this.getAdapterClass().isInstance(adapter) && this.acceptAdapterImpl((IJsonAdapter)this.getAdapterClass().cast(adapter));
    }

    protected boolean acceptAdapterImpl(ADAPTER adapter) {
        return true;
    }

    protected boolean acceptJsonElement(Object jsonElement) {
        return this.getJsonElementClass().isInstance(jsonElement) && this.acceptJsonElementImpl(this.getJsonElementClass().cast(jsonElement));
    }

    protected boolean acceptJsonElementImpl(JSON_ELEMENT jsonElement) {
        return true;
    }

    protected boolean acceptModelElement(Object modelElement) {
        return this.getModelElementClass().isInstance(modelElement) && this.acceptModelElementImpl(this.getModelElementClass().cast(modelElement));
    }

    protected boolean acceptModelElementImpl(MODEL_ELEMENT element) {
        return true;
    }

    protected abstract MODEL_ELEMENT jsonToElement(ADAPTER var1, JSON_ELEMENT var2);

    protected abstract JSON_ELEMENT elementToJson(ADAPTER var1, MODEL_ELEMENT var2);
}

