/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.desktop.hybrid;

import java.util.Map;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.HybridActionContextElements;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.HybridEvent;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.HybridEventListener;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.HybridManager;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.LazyValue;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.AbstractJsonPropertyObserver;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonAdapterUtility;
import org.eclipse.scout.rt.ui.html.json.JsonDataObjectHelper;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.desktop.hybrid.JsonHybridHelper;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterProperty;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterPropertyConfig;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterPropertyConfigBuilder;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonHybridManager<T extends HybridManager>
extends AbstractJsonPropertyObserver<T> {
    private static final Logger LOG = LoggerFactory.getLogger(JsonHybridManager.class);
    private HybridEventListener m_listener;
    private final LazyValue<JsonDataObjectHelper> m_jsonDoHelper = new LazyValue(JsonDataObjectHelper.class);

    public JsonHybridManager(T model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "scout.HybridManager";
    }

    protected JsonDataObjectHelper jsonDoHelper() {
        return (JsonDataObjectHelper)this.m_jsonDoHelper.get();
    }

    @Override
    protected void attachModel() {
        super.attachModel();
        if (this.m_listener != null) {
            throw new IllegalStateException();
        }
        this.m_listener = new P_HybridEventListener();
        ((HybridManager)this.getModel()).addHybridEventListener(this.m_listener);
    }

    @Override
    protected void detachModel() {
        super.detachModel();
        ((HybridManager)this.getModel()).removeHybridEventListener(this.m_listener);
    }

    @Override
    protected void initJsonProperties(T model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonAdapterProperty<T>("widgets", (HybridManager)model, this.getUiSession()){

            @Override
            protected JsonAdapterPropertyConfig createConfig() {
                return new JsonAdapterPropertyConfigBuilder().global(model -> model instanceof IForm).build();
            }

            @Override
            protected Map<String, IWidget> modelValue() {
                return ((HybridManager)this.getModel()).getWidgets();
            }

            @Override
            protected void createAdapters(Object modelValue) {
                if (modelValue == null) {
                    return;
                }
                if (modelValue instanceof Map) {
                    ((Map)modelValue).values().forEach(this::createAdapter);
                    return;
                }
                throw new IllegalArgumentException("modelValue must be a Map");
            }

            @Override
            protected void disposeObsoleteAdapters(Object newModels) {
                if (newModels == null) {
                    return;
                }
                if (newModels instanceof Map) {
                    super.disposeObsoleteAdapters(((Map)newModels).values());
                    return;
                }
                throw new IllegalArgumentException("modelValue must be a Map");
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                if (value == null) {
                    return null;
                }
                if (value instanceof Map) {
                    JSONObject json = new JSONObject();
                    ((Map)value).forEach((id, widget) -> {
                        JSONObject jSONObject2 = json.put(id, (Object)JsonAdapterUtility.getAdapterIdForModel(this.getUiSession(), widget, this.getParentJsonAdapter(), this.getFilter()));
                    });
                    return json;
                }
                throw new IllegalArgumentException("modelValue must be a Map");
            }
        });
    }

    protected void handleModelHybridEvent(HybridEvent event) {
        switch (event.getType()) {
            case 13: {
                this.addActionEvent("hybridEvent", this.createJsonHybridEvent(event));
                break;
            }
            case 42: {
                this.addActionEvent("hybridWidgetEvent", this.createJsonHybridEvent(event));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported event type");
            }
        }
    }

    protected JSONObject createJsonHybridEvent(HybridEvent event) {
        return new JSONObject().put("id", (Object)event.getId()).put("eventType", (Object)event.getEventType()).put("data", (Object)this.jsonDoHelper().dataObjectToJson(event.getData())).putOpt("contextElements", (Object)((JsonHybridHelper)BEANS.get(JsonHybridHelper.class)).contextElementsToJson(this.getUiSession(), event.getContextElements()));
    }

    @Override
    public void handleUiEvent(JsonEvent event) {
        if ("hybridAction".equals(event.getType())) {
            this.handleUiHybridAction(event);
        } else {
            super.handleUiEvent(event);
        }
    }

    protected void handleUiHybridAction(JsonEvent event) {
        JSONObject eventData = event.getData();
        String id = eventData.getString("id");
        String actionType = eventData.getString("actionType");
        IDoEntity data = this.jsonDoHelper().jsonToDataObject(eventData.optJSONObject("data"), IDoEntity.class);
        HybridActionContextElements contextElements = ((JsonHybridHelper)BEANS.get(JsonHybridHelper.class)).jsonToContextElements(this.getUiSession(), eventData.optJSONObject("contextElements"));
        LOG.debug("Handling hybrid action '{}' for id '{}'", (Object)actionType, (Object)id);
        try {
            ((HybridManager)this.getModel()).getUIFacade().handleHybridActionFromUI(id, actionType, data, contextElements);
        }
        catch (Exception e) {
            LOG.info("Handling hybrid action '{}' for id '{}' failed", (Object)actionType, (Object)id);
            throw e;
        }
    }

    protected class P_HybridEventListener
    implements HybridEventListener {
        protected P_HybridEventListener() {
        }

        public void handle(HybridEvent e) {
            ModelJobs.assertModelThread();
            JsonHybridManager.this.handleModelHybridEvent(e);
        }
    }
}

