/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.desktop;

import java.util.Collection;
import java.util.Set;
import org.eclipse.scout.rt.client.ui.IDisplayParent;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.ITreeContextMenu;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.OutlineEvent;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithNodes;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.js.IJsPage;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.LazyValue;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.InspectorInfo;
import org.eclipse.scout.rt.ui.html.json.JsonDataObjectHelper;
import org.eclipse.scout.rt.ui.html.json.JsonObjectUtility;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.desktop.IPageToJsonContributor;
import org.eclipse.scout.rt.ui.html.json.desktop.OutlineMenuFilter;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterProperty;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterPropertyConfig;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterPropertyConfigBuilder;
import org.eclipse.scout.rt.ui.html.json.menu.JsonContextMenu;
import org.eclipse.scout.rt.ui.html.json.tree.IChildNodeIndexLookup;
import org.eclipse.scout.rt.ui.html.json.tree.JsonTree;
import org.json.JSONObject;

public class JsonOutline<OUTLINE extends IOutline>
extends JsonTree<OUTLINE> {
    private static final String PROP_DETAIL_FORM = "detailForm";
    private static final String PROP_DETAIL_TABLE = "detailTable";
    private static final String PROP_DETAIL_FORM_VISIBLE = "detailFormVisible";
    private static final String PROP_NAVIGATE_BUTTONS_VISIBLE = "navigateButtonsVisible";
    private static final String PROP_DETAIL_TABLE_VISIBLE = "detailTableVisible";
    private static final String PROP_OVERVIEW_ICON_ID = "overviewIconId";
    private static final String PROP_SHOW_TILE_OVERVIEW = "showTileOverview";
    private static final String PROP_COMPACT_ROOT = "compactRoot";
    private final IDesktop m_desktop;
    private final LazyValue<JsonDataObjectHelper> m_jsonDoHelper = new LazyValue(() -> (JsonDataObjectHelper)BEANS.get(JsonDataObjectHelper.class));

    public JsonOutline(OUTLINE outline, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(outline, uiSession, id, parent);
        this.m_desktop = uiSession.getClientSession().getDesktop();
    }

    @Override
    public String getObjectType() {
        return "Outline";
    }

    protected JsonDataObjectHelper jsonDoHelper() {
        return (JsonDataObjectHelper)this.m_jsonDoHelper.get();
    }

    @Override
    protected void initJsonProperties(OUTLINE model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<OUTLINE>(PROP_NAVIGATE_BUTTONS_VISIBLE, (IOutline)model){

            @Override
            protected Boolean modelValue() {
                return ((IOutline)this.getModel()).isNavigateButtonsVisible();
            }
        });
        this.putJsonProperty(new JsonAdapterProperty<OUTLINE>("defaultDetailForm", (IOutline)model, this.getUiSession()){

            protected IForm modelValue() {
                return ((IOutline)this.getModel()).getDefaultDetailForm();
            }

            @Override
            protected JsonAdapterPropertyConfig createConfig() {
                return JsonAdapterPropertyConfigBuilder.globalConfig();
            }
        });
        this.putJsonProperty(new JsonProperty<OUTLINE>("outlineOverviewVisible", (IOutline)model){

            @Override
            protected Boolean modelValue() {
                return ((IOutline)this.getModel()).isOutlineOverviewVisible();
            }
        });
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        this.putAdapterIdsProperty(json, "views", this.m_desktop.getViews((IDisplayParent)this.getModel()));
        if (!this.m_desktop.getSelectedViews((IDisplayParent)this.getModel()).isEmpty()) {
            this.putAdapterIdsProperty(json, "selectedViewTabs", this.m_desktop.getSelectedViews((IDisplayParent)this.getModel()));
        }
        this.putAdapterIdsProperty(json, "dialogs", this.m_desktop.getDialogs((IDisplayParent)this.getModel(), false));
        this.putAdapterIdsProperty(json, "messageBoxes", this.m_desktop.getMessageBoxes((IDisplayParent)this.getModel()));
        this.putAdapterIdsProperty(json, "fileChoosers", this.m_desktop.getFileChoosers((IDisplayParent)this.getModel()));
        return json;
    }

    @Override
    protected void attachChildAdapters() {
        super.attachChildAdapters();
        this.attachAdapter(((IOutline)this.getModel()).getDefaultDetailForm());
        this.attachGlobalAdapters(this.m_desktop.getViews((IDisplayParent)this.getModel()));
        this.attachGlobalAdapters(this.m_desktop.getSelectedViews((IDisplayParent)this.getModel()));
        this.attachGlobalAdapters(this.m_desktop.getDialogs((IDisplayParent)this.getModel(), false));
        this.attachGlobalAdapters(this.m_desktop.getMessageBoxes((IDisplayParent)this.getModel()));
        this.attachGlobalAdapters(this.m_desktop.getFileChoosers((IDisplayParent)this.getModel()));
    }

    @Override
    protected JsonContextMenu<IContextMenu> createJsonContextMenu() {
        return new JsonContextMenu<ITreeContextMenu>(((IOutline)this.getModel()).getContextMenu(), this, new OutlineMenuFilter<IMenu>());
    }

    @Override
    protected void attachNodeInternal(ITreeNode node) {
        if (!(node instanceof IPage)) {
            throw new IllegalArgumentException("Expected node to be a page. " + String.valueOf(node));
        }
        super.attachNodeInternal(node);
        IPage page = (IPage)node;
        if (this.hasDetailForm(page)) {
            this.attachGlobalAdapter(page.getDetailForm());
        }
        if (page.isTableVisible()) {
            this.attachDetailTable(page);
        }
    }

    @Override
    protected void handleModelTreeEvent(TreeEvent event) {
        if (!this.acceptModelTreeEvent(event)) {
            return;
        }
        super.handleModelTreeEvent(event);
        if (ObjectUtility.isOneOf((Object)event.getType(), (Object)30, (Object[])new Object[]{31})) {
            this.detachDetailTables(event.getNodes(), true);
        }
    }

    protected boolean acceptModelTreeEvent(TreeEvent event) {
        return !(event instanceof OutlineEvent) || !ObjectUtility.isOneOf((Object)event.getType(), (Object)1002, (Object[])new Object[]{1003, 1004, 1005, 1006, 1007, 1008});
    }

    @Override
    protected void putCellProperties(JSONObject json, ITreeNode node) {
        if (node instanceof IJsPage) {
            return;
        }
        super.putCellProperties(json, node);
    }

    @Override
    protected JSONObject treeNodeToJson(ITreeNode node, IChildNodeIndexLookup childIndexes, Set<ITreeNode> acceptedNodes) {
        if (!(node instanceof IPage)) {
            throw new IllegalArgumentException("Expected node to be a page. " + String.valueOf(node));
        }
        IPage page = (IPage)node;
        JSONObject json = super.treeNodeToJson(node, childIndexes, acceptedNodes);
        this.putNodeType(json, node);
        if (node instanceof IJsPage) {
            this.putJsPageObjectTypeAndModel(json, (IJsPage)node);
        } else {
            this.putDetailFormAndTable(json, page);
            this.putProperty(json, PROP_NAVIGATE_BUTTONS_VISIBLE, page.isNavigateButtonsVisible());
            json.put(PROP_OVERVIEW_ICON_ID, (Object)page.getOverviewIconId());
            json.put(PROP_SHOW_TILE_OVERVIEW, page.isShowTileOverview());
            json.put(PROP_COMPACT_ROOT, page.isCompactRoot());
        }
        ((InspectorInfo)BEANS.get(InspectorInfo.class)).put(json, page, this.getUiSession());
        BEANS.all(IPageToJsonContributor.class).forEach(c -> c.contribute(json, page));
        JsonObjectUtility.filterDefaultValues(json, "Page");
        return json;
    }

    protected void putNodeType(JSONObject json, ITreeNode node) {
        String nodeType = null;
        if (node instanceof IPageWithNodes) {
            nodeType = "nodes";
        } else if (node instanceof IPageWithTable) {
            nodeType = "table";
        } else if (node instanceof IJsPage) {
            nodeType = "jsPage";
        }
        if (nodeType != null) {
            this.putProperty(json, "nodeType", nodeType);
        }
    }

    protected void putDetailFormAndTable(JSONObject json, IPage<?> page) {
        ITable table;
        this.putProperty(json, PROP_DETAIL_FORM_VISIBLE, page.isDetailFormVisible());
        if (page.isDetailFormVisible() && this.hasDetailForm(page)) {
            this.putAdapterIdProperty(json, PROP_DETAIL_FORM, page.getDetailForm());
        }
        this.putProperty(json, PROP_DETAIL_TABLE_VISIBLE, page.isTableVisible());
        if (page.isTableVisible() && (table = page.getTable(false)) != null) {
            this.putAdapterIdProperty(json, PROP_DETAIL_TABLE, table);
        }
    }

    protected void putJsPageObjectTypeAndModel(JSONObject json, IJsPage jsPage) {
        this.putProperty(json, "jsPageObjectType", jsPage.getJsPageObjectType());
        this.putProperty(json, "jsPageModel", this.jsonDoHelper().dataObjectToJson(jsPage.getJsPageModel()));
        if (jsPage.getParentNode() instanceof IPageWithTable) {
            JSONObject jsPageModel = (JSONObject)ObjectUtility.nvl((Object)json.optJSONObject("jsPageModel"), (Object)new JSONObject());
            jsPageModel.put("text", (Object)jsPage.getCell().getText());
            jsPageModel.put("htmlEnabled", jsPage.getCell().isHtmlEnabled());
            jsPageModel.put("cssClass", (Object)jsPage.getCell().getCssClass());
            jsPageModel.put("iconId", (Object)jsPage.getCell().getIconId());
            this.putProperty(json, "jsPageModel", jsPageModel);
        }
    }

    @Override
    protected void disposeNode(ITreeNode node, boolean disposeChildren, Set<ITreeNode> disposedNodes) {
        this.detachDetailTable(node, false);
        super.disposeNode(node, disposeChildren, disposedNodes);
    }

    protected void attachDetailTable(IPage<?> page) {
        ITable table = page.getTable(false);
        if (table == null) {
            return;
        }
        table.setProperty("ui:page", page);
        this.attachGlobalAdapter(table);
    }

    protected void detachDetailTable(IPage<?> page) {
        ITable table = page.getTable(false);
        if (table != null) {
            table.setProperty("ui:page", null);
            Object jsonTableAdapter = this.getGlobalAdapter(table);
            if (jsonTableAdapter != null && !jsonTableAdapter.isDisposed()) {
                jsonTableAdapter.dispose();
            }
        }
    }

    protected void detachDetailTable(ITreeNode node, boolean disposeChildren) {
        if (disposeChildren) {
            this.detachDetailTables(this.getChildNodes(node), true);
        }
        if (!(node instanceof IPage)) {
            throw new IllegalArgumentException("Expected node to be a page. " + String.valueOf(node));
        }
        this.detachDetailTable((IPage)node);
    }

    protected void detachDetailTables(Collection<ITreeNode> nodes, boolean disposeChildren) {
        for (ITreeNode node : nodes) {
            this.detachDetailTable(node, disposeChildren);
        }
    }

    @Override
    protected void handleModelOtherTreeEvent(TreeEvent event) {
        switch (event.getType()) {
            case 1001: {
                this.handleModelPageChanged((OutlineEvent)event);
            }
        }
    }

    protected void handleModelPageChanged(OutlineEvent event) {
        IPage page = (IPage)event.getNode();
        if (!this.isNodeAccepted((ITreeNode)page)) {
            return;
        }
        this.attachNode((ITreeNode)page, false);
        String nodeId = this.optNodeId((ITreeNode)page);
        if (nodeId == null) {
            return;
        }
        JSONObject jsonEvent = new JSONObject();
        this.putProperty(jsonEvent, "nodeId", this.getOrCreateNodeId((ITreeNode)page));
        this.putDetailFormAndTable(jsonEvent, page);
        this.putProperty(jsonEvent, PROP_NAVIGATE_BUTTONS_VISIBLE, page.isNavigateButtonsVisible());
        jsonEvent.put(PROP_OVERVIEW_ICON_ID, (Object)page.getOverviewIconId());
        this.addActionEvent("pageChanged", jsonEvent);
    }

    protected boolean hasDetailForm(IPage<?> page) {
        return page.getDetailForm() != null && !page.getDetailForm().isFormClosed();
    }
}

