/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.desktop;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.ui.IDisplayParent;
import org.eclipse.scout.rt.client.ui.IEventHistory;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooser;
import org.eclipse.scout.rt.client.ui.desktop.BrowserHistoryEntry;
import org.eclipse.scout.rt.client.ui.desktop.DesktopEvent;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListener;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.IOpenUriAction;
import org.eclipse.scout.rt.client.ui.desktop.OpenUriAction;
import org.eclipse.scout.rt.client.ui.desktop.bench.layout.BenchLayoutData;
import org.eclipse.scout.rt.client.ui.desktop.notification.IDesktopNotification;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.server.commons.servlet.cache.DownloadHttpResponseInterceptor;
import org.eclipse.scout.rt.server.commons.servlet.cache.IHttpResponseInterceptor;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.AbstractJsonWidget;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.action.DisplayableActionFilter;
import org.eclipse.scout.rt.ui.html.json.desktop.BooleanPropertyChangeFilter;
import org.eclipse.scout.rt.ui.html.json.desktop.DesktopEventFilter;
import org.eclipse.scout.rt.ui.html.json.desktop.DesktopEventFilterCondition;
import org.eclipse.scout.rt.ui.html.json.desktop.DisplayableOutlineFilter;
import org.eclipse.scout.rt.ui.html.json.desktop.DownloadHandlerStorage;
import org.eclipse.scout.rt.ui.html.json.desktop.JsonBrowserHistoryEntry;
import org.eclipse.scout.rt.ui.html.json.desktop.bench.layout.JsonBenchLayoutData;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceHolder;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceUrlUtility;
import org.eclipse.scout.rt.ui.html.res.IBinaryResourceProvider;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonDesktop<DESKTOP extends IDesktop>
extends AbstractJsonWidget<DESKTOP>
implements IBinaryResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(JsonDesktop.class);
    private static final String EVENT_OUTLINE_CHANGED = "outlineChanged";
    private static final String EVENT_OUTLINE_CONTENT_ACTIVATE = "outlineContentActivate";
    private static final String EVENT_HISTORY_ENTRY_ACTIVATE = "historyEntryActivate";
    private static final String EVENT_DESKTOP_READY = "desktopReady";
    private static final String EVENT_ADD_NOTIFICATION = "addNotification";
    private static final String EVENT_REMOVE_NOTIFICATION = "removeNotification";
    private static final String EVENT_OPEN_URI = "openUri";
    private static final String EVENT_FORM_ACTIVATE = "formActivate";
    private static final String EVENT_LOGO_ACTION = "logoAction";
    private static final String EVENT_CANCEL_FORMS = "cancelForms";
    public static final String PROP_OUTLINE = "outline";
    public static final String PROP_DISPLAY_PARENT = "displayParent";
    public static final String PROP_POSITION = "position";
    public static final String PROP_FORM = "form";
    public static final String PROP_MESSAGE_BOX = "messageBox";
    public static final String PROP_NOTIFICATION = "notification";
    public static final String PROP_FILE_CHOOSER = "fileChooser";
    public static final String PROP_ACTIVE_FORM = "activeForm";
    public static final String PROP_BENCH_LAYOUT_DATA = "benchLayoutData";
    private static final AtomicLong RESOURCE_COUNTER = new AtomicLong();
    private final DownloadHandlerStorage m_downloads;
    private DesktopListener m_desktopListener;
    private final DesktopEventFilter m_desktopEventFilter;
    private final BooleanPropertyChangeFilter m_browserHistoryFilter = new BooleanPropertyChangeFilter("browserHistoryEntry", false);

    public JsonDesktop(DESKTOP desktop, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(desktop, uiSession, id, parent);
        this.m_downloads = (DownloadHandlerStorage)BEANS.get(DownloadHandlerStorage.class);
        this.m_desktopEventFilter = (DesktopEventFilter)BEANS.get(DesktopEventFilter.class);
    }

    @Override
    public String getObjectType() {
        return "Desktop";
    }

    @Override
    protected void attachChildAdapters() {
        super.attachChildAdapters();
        this.attachGlobalAdapters(((IDesktop)this.getModel()).getViews((IDisplayParent)this.getModel()));
        this.attachGlobalAdapters(((IDesktop)this.getModel()).getSelectedViews((IDisplayParent)this.getModel()));
        this.attachGlobalAdapters(((IDesktop)this.getModel()).getDialogs((IDisplayParent)this.getModel(), false));
        this.attachGlobalAdapters(((IDesktop)this.getModel()).getMessageBoxes((IDisplayParent)this.getModel()));
        this.attachGlobalAdapters(((IDesktop)this.getModel()).getFileChoosers((IDisplayParent)this.getModel()));
        this.attachAdapters(((IDesktop)this.getModel()).getNotifications());
        this.attachAdapters(((IDesktop)this.getModel()).getMenus(), new DisplayableActionFilter());
        this.attachAdapters(((IDesktop)this.getModel()).getAddOns());
        this.attachAdapters(((IDesktop)this.getModel()).getKeyStrokes(), new DisplayableActionFilter());
        this.attachAdapters(((IDesktop)this.getModel()).getViewButtons(), new DisplayableActionFilter());
        this.attachGlobalAdapter(((IDesktop)this.getModel()).getOutline(), new DisplayableOutlineFilter());
    }

    @Override
    public void handleUiEvent(JsonEvent event) {
        if (EVENT_FORM_ACTIVATE.equals(event.getType())) {
            this.handleUiFormActivate(event);
        } else if (EVENT_HISTORY_ENTRY_ACTIVATE.equals(event.getType())) {
            this.handleUiHistoryEntryActivate(event);
        } else if (EVENT_DESKTOP_READY.equals(event.getType())) {
            this.handleUiDesktopReady(event);
        } else if (EVENT_LOGO_ACTION.equals(event.getType())) {
            this.handleUiLogoAction(event);
        } else if (EVENT_CANCEL_FORMS.equals(event.getType())) {
            this.handleCancelAllForms(event);
        } else {
            super.handleUiEvent(event);
        }
    }

    protected void handleUiDesktopReady(JsonEvent event) {
        ((IDesktop)this.getModel()).getUIFacade().readyFromUI();
    }

    protected void handleUiHistoryEntryActivate(JsonEvent event) {
        this.addPropertyEventFilterCondition(this.m_browserHistoryFilter);
        String deepLinkPath = event.getData().optString("deepLinkPath", null);
        ((IDesktop)this.getModel()).getUIFacade().historyEntryActivateFromUI(deepLinkPath);
    }

    @Override
    protected void handleUiPropertyChange(String propertyName, JSONObject data) {
        boolean visible;
        if ("navigationVisible".equals(propertyName)) {
            visible = data.getBoolean(propertyName);
            this.addPropertyEventFilterCondition(propertyName, visible);
            ((IDesktop)this.getModel()).getUIFacade().setNavigationVisibleFromUI(visible);
        }
        if ("navigationHandleVisible".equals(propertyName)) {
            visible = data.getBoolean(propertyName);
            this.addPropertyEventFilterCondition(propertyName, visible);
            ((IDesktop)this.getModel()).getUIFacade().setNavigationHandleVisibleFromUI(visible);
        } else if ("benchVisible".equals(propertyName)) {
            visible = data.getBoolean(propertyName);
            this.addPropertyEventFilterCondition(propertyName, visible);
            ((IDesktop)this.getModel()).getUIFacade().setBenchVisibleFromUI(visible);
        } else if ("headerVisible".equals(propertyName)) {
            visible = data.getBoolean(propertyName);
            this.addPropertyEventFilterCondition(propertyName, visible);
            ((IDesktop)this.getModel()).getUIFacade().setHeaderVisibleFromUI(visible);
        } else if ("geolocationServiceAvailable".equals(propertyName)) {
            boolean available = data.getBoolean(propertyName);
            this.addPropertyEventFilterCondition(propertyName, available);
            ((IDesktop)this.getModel()).getUIFacade().setGeoLocationServiceAvailableFromUI(available);
        } else if ("inBackground".equals(propertyName)) {
            boolean inBackground = data.getBoolean(propertyName);
            this.addPropertyEventFilterCondition(propertyName, inBackground);
            ((IDesktop)this.getModel()).getUIFacade().setInBackgroundFromUI(inBackground);
        } else if ("focusedElement".equals(propertyName)) {
            String id = data.optString(propertyName, null);
            IWidget focusedElement = this.getWidgetById(id);
            this.addPropertyEventFilterCondition(propertyName, focusedElement);
            ((IDesktop)this.getModel()).getUIFacade().setFocusedElementFromUI(focusedElement);
        } else {
            super.handleUiPropertyChange(propertyName, data);
        }
    }

    protected IWidget getWidgetById(String id) {
        if (id == null) {
            return null;
        }
        IJsonAdapter<?> jsonAdapter = this.getUiSession().getJsonAdapter(id);
        if (jsonAdapter == null) {
            return null;
        }
        return (IWidget)jsonAdapter.getModel();
    }

    protected void handleCancelAllForms(JsonEvent event) {
        JSONArray formIds = event.getData().optJSONArray("formIds");
        HashSet<IForm> formSet = new HashSet<IForm>();
        if (formIds != null) {
            int i = 0;
            while (i < formIds.length()) {
                String formId = formIds.optString(i, null);
                IJsonAdapter<?> jsonAdapter = this.getUiSession().getJsonAdapter(formId);
                if (jsonAdapter != null) {
                    formSet.add((IForm)jsonAdapter.getModel());
                }
                ++i;
            }
        }
        ((IDesktop)this.getModel()).cancelForms(formSet);
    }

    protected void handleUiLogoAction(JsonEvent event) {
        ((IDesktop)this.getModel()).getUIFacade().fireLogoAction();
    }

    protected void handleUiFormActivate(JsonEvent event) {
        String formId = event.getData().optString("formId", null);
        if (formId == null) {
            ((IDesktop)this.getModel()).getUIFacade().activateForm(null);
            return;
        }
        IJsonAdapter<?> jsonAdapter = this.getUiSession().getJsonAdapter(formId);
        if (jsonAdapter == null) {
            LOG.info("handleUIFormActivated is looking for form which exists no more. ID: {}", (Object)formId);
            return;
        }
        IForm form = (IForm)jsonAdapter.getModel();
        this.addDesktopEventFilterCondition(620).setForm(form);
        ((IDesktop)this.getModel()).getUIFacade().activateForm(form);
    }

    protected DesktopEventFilterCondition addDesktopEventFilterCondition(int tableEventType) {
        DesktopEventFilterCondition condition = new DesktopEventFilterCondition(tableEventType);
        condition.setCheckDisplayParents(true);
        this.m_desktopEventFilter.addCondition(condition);
        return condition;
    }

    @Override
    public void cleanUpEventFilters() {
        super.cleanUpEventFilters();
        this.m_desktopEventFilter.removeAllConditions();
    }

    @Override
    protected void attachModel() {
        super.attachModel();
        if (this.m_desktopListener != null) {
            throw new IllegalStateException();
        }
        this.m_desktopListener = new P_DesktopListener();
        ((IDesktop)this.getModel()).addUIDesktopListener(this.m_desktopListener, new Integer[0]);
    }

    @Override
    protected void detachModel() {
        super.detachModel();
        if (this.m_desktopListener == null) {
            throw new IllegalStateException();
        }
        ((IDesktop)this.getModel()).removeDesktopListener(this.m_desktopListener, new Integer[0]);
        this.m_desktopListener = null;
    }

    @Override
    public void init() {
        super.init();
        IEventHistory eventHistory = ((IDesktop)this.getModel()).getEventHistory();
        if (eventHistory != null) {
            for (DesktopEvent event : eventHistory.getRecentEvents()) {
                this.handleModelDesktopEvent(event);
            }
        }
    }

    @Override
    protected void initJsonProperties(DESKTOP model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<DESKTOP>("title", (IDesktop)model){

            @Override
            protected String modelValue() {
                return ((IDesktop)this.getModel()).getTitle();
            }
        });
        this.putJsonProperty(new JsonProperty<DESKTOP>("selectViewTabsKeyStrokesEnabled", (IDesktop)model){

            @Override
            protected Object modelValue() {
                return ((IDesktop)this.getModel()).isSelectViewTabsKeyStrokesEnabled();
            }
        });
        this.putJsonProperty(new JsonProperty<DESKTOP>("selectViewTabsKeyStrokeModifier", (IDesktop)model){

            @Override
            protected Object modelValue() {
                return ((IDesktop)this.getModel()).getSelectViewTabsKeyStrokeModifier();
            }
        });
        this.putJsonProperty(new JsonProperty<DESKTOP>("cacheSplitterPosition", (IDesktop)model){

            @Override
            protected Object modelValue() {
                return ((IDesktop)this.getModel()).isCacheSplitterPosition();
            }
        });
        this.putJsonProperty(new JsonProperty<DESKTOP>("browserHistoryEntry", (IDesktop)model){

            protected BrowserHistoryEntry modelValue() {
                return ((IDesktop)this.getModel()).getBrowserHistoryEntry();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return JsonBrowserHistoryEntry.toJson((BrowserHistoryEntry)value);
            }
        });
        this.putJsonProperty(new JsonProperty<DESKTOP>("logoId", (IDesktop)model){

            @Override
            protected Object modelValue() {
                return ((IDesktop)this.getModel()).getLogoId();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return BinaryResourceUrlUtility.createIconUrl((String)value);
            }

            @Override
            public String jsonPropertyName() {
                return "logoUrl";
            }
        });
        this.putJsonProperty(new JsonProperty<DESKTOP>("navigationVisible", (IDesktop)model){

            @Override
            protected Object modelValue() {
                return ((IDesktop)this.getModel()).isNavigationVisible();
            }
        });
        this.putJsonProperty(new JsonProperty<DESKTOP>("navigationHandleVisible", (IDesktop)model){

            @Override
            protected Object modelValue() {
                return ((IDesktop)this.getModel()).isNavigationHandleVisible();
            }
        });
        this.putJsonProperty(new JsonProperty<DESKTOP>("benchVisible", (IDesktop)model){

            @Override
            protected Object modelValue() {
                return ((IDesktop)this.getModel()).isBenchVisible();
            }
        });
        this.putJsonProperty(new JsonProperty<DESKTOP>("headerVisible", (IDesktop)model){

            @Override
            protected Object modelValue() {
                return ((IDesktop)this.getModel()).isHeaderVisible();
            }
        });
        this.putJsonProperty(new JsonProperty<DESKTOP>("geolocationServiceAvailable", (IDesktop)model){

            @Override
            protected Boolean modelValue() {
                return ((IDesktop)this.getModel()).isGeolocationServiceAvailable();
            }
        });
        this.putJsonProperty(new JsonProperty<DESKTOP>("logoActionEnabled", (IDesktop)model){

            @Override
            protected Boolean modelValue() {
                return ((IDesktop)this.getModel()).isLogoActionEnabled();
            }
        });
        this.putJsonProperty(new JsonProperty<DESKTOP>(PROP_BENCH_LAYOUT_DATA, (IDesktop)model){

            protected BenchLayoutData modelValue() {
                return ((IDesktop)this.getModel()).getBenchLayoutData();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return JsonBenchLayoutData.toJson((BenchLayoutData)value);
            }
        });
        this.putJsonProperty(new JsonProperty<DESKTOP>("displayStyle", (IDesktop)model){

            @Override
            protected String modelValue() {
                return ((IDesktop)this.getModel()).getDisplayStyle();
            }
        });
        this.putJsonProperty(new JsonProperty<DESKTOP>("dense", (IDesktop)model){

            @Override
            protected Boolean modelValue() {
                return ((IDesktop)this.getModel()).isDense();
            }
        });
        this.putJsonProperty(new JsonProperty<DESKTOP>("trackFocus", (IDesktop)model){

            @Override
            protected Boolean modelValue() {
                return ((IDesktop)this.getModel()).isTrackFocus();
            }
        });
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        json.put("displayStyle", (Object)((IDesktop)this.getModel()).getDisplayStyle());
        this.putAdapterIdProperty(json, PROP_ACTIVE_FORM, ((IDesktop)this.getModel()).getActiveForm());
        this.putAdapterIdsProperty(json, "views", ((IDesktop)this.getModel()).getViews((IDisplayParent)this.getModel()));
        this.putAdapterIdsProperty(json, "dialogs", ((IDesktop)this.getModel()).getDialogs((IDisplayParent)this.getModel(), false));
        this.putAdapterIdsProperty(json, "messageBoxes", ((IDesktop)this.getModel()).getMessageBoxes((IDisplayParent)this.getModel()));
        this.putAdapterIdsProperty(json, "notifications", ((IDesktop)this.getModel()).getNotifications());
        this.putAdapterIdsProperty(json, "fileChoosers", ((IDesktop)this.getModel()).getFileChoosers((IDisplayParent)this.getModel()));
        this.putAdapterIdsProperty(json, "menus", ((IDesktop)this.getModel()).getMenus(), new DisplayableActionFilter());
        this.putAdapterIdsProperty(json, "addOns", ((IDesktop)this.getModel()).getAddOns());
        this.putAdapterIdsProperty(json, "keyStrokes", ((IDesktop)this.getModel()).getKeyStrokes(), new DisplayableActionFilter());
        this.putAdapterIdsProperty(json, "viewButtons", ((IDesktop)this.getModel()).getViewButtons(), new DisplayableActionFilter());
        this.putAdapterIdProperty(json, PROP_OUTLINE, ((IDesktop)this.getModel()).getOutline(), new DisplayableOutlineFilter());
        if (!((IDesktop)this.getModel()).getSelectedViews((IDisplayParent)this.getModel()).isEmpty()) {
            this.putAdapterIdsProperty(json, "selectedViewTabs", ((IDesktop)this.getModel()).getSelectedViews((IDisplayParent)this.getModel()));
        }
        return json;
    }

    protected void handleModelDesktopEvent(DesktopEvent event) {
        if ((event = this.m_desktopEventFilter.filter(event)) == null) {
            return;
        }
        switch (event.getType()) {
            case 200: {
                this.handleModelOutlineChanged(event.getOutline());
                break;
            }
            case 210: {
                this.handleModelOutlineContentActivate();
                break;
            }
            case 600: {
                this.handleModelFormShow(event.getForm());
                break;
            }
            case 610: {
                this.handleModelFormHide(event.getForm());
                break;
            }
            case 620: {
                this.handleModelFormActivate(event.getForm());
                break;
            }
            case 700: {
                this.handleModelMessageBoxShow(event.getMessageBox());
                break;
            }
            case 710: {
                this.handleModelMessageBoxHide(event.getMessageBox());
                break;
            }
            case 910: {
                this.handleModelFileChooserShow(event.getFileChooser());
                break;
            }
            case 915: {
                this.handleModelFileChooserHide(event.getFileChooser());
                break;
            }
            case 920: {
                if (event.getUri() != null) {
                    this.handleModelOpenUri(event.getUri(), event.getOpenUriAction());
                    break;
                }
                if (event.getBinaryResource() == null) break;
                this.handleModelOpenUri(event.getBinaryResource(), event.getOpenUriAction());
                break;
            }
            case 100: {
                this.handleModelDesktopClosed();
                break;
            }
            case 1040: {
                this.handleModelNotificationAdded(event);
                break;
            }
            case 1050: {
                this.handleModelNotificationRemoved(event);
                break;
            }
            case 1060: {
                this.handleModelReloadGui();
            }
        }
    }

    protected void handleModelNotificationAdded(DesktopEvent event) {
        IDesktopNotification notification = event.getNotification();
        Object jsonAdapter = this.attachAdapter(notification);
        JSONObject jsonEvent = new JSONObject();
        jsonEvent.put(PROP_NOTIFICATION, (Object)jsonAdapter.getId());
        this.addActionEvent(EVENT_ADD_NOTIFICATION, (IJsonAdapter<?>)jsonAdapter, jsonEvent);
    }

    protected void handleModelNotificationRemoved(DesktopEvent event) {
        IDesktopNotification notification = event.getNotification();
        Object jsonAdapter = this.getAdapter(notification);
        if (jsonAdapter != null) {
            JSONObject jsonEvent = new JSONObject();
            jsonEvent.put(PROP_NOTIFICATION, (Object)jsonAdapter.getId());
            this.addActionEvent(EVENT_REMOVE_NOTIFICATION, (IJsonAdapter<?>)jsonAdapter, jsonEvent);
        }
    }

    @Override
    protected void handleModelPropertyChange(String propertyName, Object oldValue, Object newValue) {
        if ("theme".equals(propertyName)) {
            this.getUiSession().updateTheme((String)newValue);
        }
    }

    protected void handleModelOpenUri(String uri, IOpenUriAction openUriAction) {
        JSONObject json = new JSONObject();
        this.putProperty(json, "uri", uri);
        this.putProperty(json, "action", openUriAction.getIdentifier());
        this.addActionEvent(EVENT_OPEN_URI, json).protect();
    }

    protected void handleModelOpenUri(BinaryResource res, IOpenUriAction openUriAction) {
        long counter = RESOURCE_COUNTER.getAndIncrement();
        String filenameWithCounter = counter + "/" + (String)ObjectUtility.nvl((Object)this.cleanFilename(res.getFilename()), (Object)"binaryData");
        BinaryResourceHolder holder = new BinaryResourceHolder(res);
        if (openUriAction == OpenUriAction.DOWNLOAD) {
            holder.addHttpResponseInterceptor((IHttpResponseInterceptor)new DownloadHttpResponseInterceptor(res.getFilename()));
        }
        this.m_downloads.put(filenameWithCounter, holder, openUriAction);
        String downloadUrl = BinaryResourceUrlUtility.createDynamicAdapterResourceUrl(this, filenameWithCounter);
        this.handleModelOpenUri(downloadUrl, openUriAction);
    }

    protected String cleanFilename(String fileName) {
        return StringUtility.replace((String)fileName, (String)";", (String)"");
    }

    @Override
    public BinaryResourceHolder provideBinaryResource(String filename) {
        DownloadHandlerStorage.BinaryResourceHolderWithAction holderWithAction = this.m_downloads.get(filename);
        if (holderWithAction != null) {
            return holderWithAction.getHolder();
        }
        return null;
    }

    protected void handleModelOutlineChanged(IOutline outline) {
        String jsonOutlineId = null;
        if (outline != null) {
            Object jsonOutline = this.attachGlobalAdapter(outline);
            jsonOutlineId = jsonOutline.getId();
        }
        this.addActionEvent(EVENT_OUTLINE_CHANGED, new JSONObject().put(PROP_OUTLINE, (Object)jsonOutlineId));
    }

    protected void handleModelOutlineContentActivate() {
        this.addActionEvent(EVENT_OUTLINE_CONTENT_ACTIVATE);
    }

    protected void handleModelFormShow(IForm form) {
        if (!form.isShowing()) {
            return;
        }
        Object jsonAdapter = this.attachGlobalAdapter(form);
        this.addActionEventForEachDisplayParentAdapter("formShow", PROP_FORM, (IJsonAdapter<?>)jsonAdapter, form.getDisplayParent(), ((IDesktop)this.getModel()).getViews(form.getDisplayParent()).indexOf(form));
    }

    protected void handleModelFormHide(IForm form) {
        Object jsonAdapter = this.getGlobalAdapter(form);
        if (jsonAdapter != null) {
            this.addActionEventForEachDisplayParentAdapter("formHide", PROP_FORM, (IJsonAdapter<?>)jsonAdapter, form.getDisplayParent(), -1);
        }
    }

    protected void handleModelFormActivate(IForm form) {
        Object jsonAdapter = this.getGlobalAdapter(form);
        if (jsonAdapter != null) {
            List<JsonEvent> events = this.addActionEventForEachDisplayParentAdapter(EVENT_FORM_ACTIVATE, PROP_FORM, (IJsonAdapter<?>)jsonAdapter, form.getDisplayParent(), -1);
            for (JsonEvent event : events) {
                event.protect();
            }
        }
    }

    protected void handleModelMessageBoxShow(IMessageBox messageBox) {
        Object jsonAdapter = this.attachGlobalAdapter(messageBox);
        this.addActionEventForEachDisplayParentAdapter("messageBoxShow", PROP_MESSAGE_BOX, (IJsonAdapter<?>)jsonAdapter, messageBox.getDisplayParent(), -1);
    }

    protected void handleModelMessageBoxHide(IMessageBox messageBox) {
        Object jsonAdapter = this.getGlobalAdapter(messageBox);
        if (jsonAdapter != null) {
            this.addActionEventForEachDisplayParentAdapter("messageBoxHide", PROP_MESSAGE_BOX, (IJsonAdapter<?>)jsonAdapter, messageBox.getDisplayParent(), -1);
        }
    }

    protected void handleModelFileChooserShow(IFileChooser fileChooser) {
        Object jsonAdapter = this.attachGlobalAdapter(fileChooser);
        this.addActionEventForEachDisplayParentAdapter("fileChooserShow", PROP_FILE_CHOOSER, (IJsonAdapter<?>)jsonAdapter, fileChooser.getDisplayParent(), -1);
    }

    protected void handleModelFileChooserHide(IFileChooser fileChooser) {
        Object jsonAdapter = this.getGlobalAdapter(fileChooser);
        if (jsonAdapter != null) {
            this.addActionEventForEachDisplayParentAdapter("fileChooserHide", PROP_FILE_CHOOSER, (IJsonAdapter<?>)jsonAdapter, fileChooser.getDisplayParent(), -1);
        }
    }

    protected void handleModelDesktopClosed() {
    }

    protected void handleModelReloadGui() {
        this.getUiSession().sendReloadPageEvent();
    }

    protected List<JsonEvent> addActionEventForEachDisplayParentAdapter(String eventName, String propModelAdapterId, IJsonAdapter<?> modelAdapter, IDisplayParent displayParent, int position) {
        ArrayList<JsonEvent> events = new ArrayList<JsonEvent>();
        for (IJsonAdapter<IDisplayParent> displayParentAdapter : this.getUiSession().getJsonAdapters(displayParent)) {
            JSONObject jsonEvent = new JSONObject();
            jsonEvent.put(propModelAdapterId, (Object)modelAdapter.getId());
            jsonEvent.put(PROP_DISPLAY_PARENT, (Object)displayParentAdapter.getId());
            if (position >= 0) {
                jsonEvent.put(PROP_POSITION, position);
            }
            events.add(this.addActionEvent(eventName, modelAdapter, jsonEvent));
        }
        return events;
    }

    protected class P_DesktopListener
    implements DesktopListener {
        protected P_DesktopListener() {
        }

        public void desktopChanged(DesktopEvent e) {
            ModelJobs.assertModelThread();
            JsonDesktop.this.handleModelDesktopEvent(e);
        }
    }
}

