/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.desktop;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.scout.rt.client.ui.desktop.IOpenUriAction;
import org.eclipse.scout.rt.client.ui.desktop.OpenUriAction;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.context.RunContexts;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.server.commons.servlet.cache.DownloadHttpResponseInterceptor;
import org.eclipse.scout.rt.server.commons.servlet.cache.IHttpResponseInterceptor;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceHolder;

@Bean
public class DownloadHandlerStorage {
    public static final String RESOURCE_CLEANUP_JOB_MARKER = DownloadHandlerStorage.class.getName();
    private final Map<String, BinaryResourceHolderWithAction> m_valueMap = new HashMap<String, BinaryResourceHolderWithAction>();
    private final Map<String, IFuture<?>> m_futureMap = new HashMap();

    protected Map<String, BinaryResourceHolderWithAction> valueMap() {
        return this.m_valueMap;
    }

    protected Map<String, IFuture<?>> futureMap() {
        return this.m_futureMap;
    }

    protected long getTTLForResource(BinaryResource res) {
        return TimeUnit.MINUTES.toMillis(1L);
    }

    protected long getRemovalTimeoutAfterFirstRequest() {
        return TimeUnit.SECONDS.toMillis(5L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, BinaryResourceHolder holder, IOpenUriAction opeUriAction) {
        long ttl = this.getTTLForResource(holder.get());
        Map<String, BinaryResourceHolderWithAction> map = this.m_valueMap;
        synchronized (map) {
            this.m_valueMap.put(key, new BinaryResourceHolderWithAction(holder, opeUriAction));
            this.scheduleRemoval(key, ttl);
        }
    }

    protected void scheduleRemoval(String key, long ttl) {
        IFuture oldFuture = this.m_futureMap.put(key, Jobs.schedule(() -> this.removeOnTimeout(key), (JobInput)Jobs.newInput().withExecutionHint(RESOURCE_CLEANUP_JOB_MARKER).withRunContext(RunContexts.copyCurrent()).withExecutionTrigger(Jobs.newExecutionTrigger().withStartIn(ttl, TimeUnit.MILLISECONDS))));
        if (oldFuture != null && !oldFuture.isCancelled()) {
            oldFuture.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeOnTimeout(String key) {
        Map<String, BinaryResourceHolderWithAction> map = this.m_valueMap;
        synchronized (map) {
            this.m_valueMap.remove(key);
            IFuture<?> future = this.m_futureMap.remove(key);
            if (future != null && !future.isCancelled()) {
                future.cancel(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinaryResourceHolderWithAction get(String key) {
        BinaryResourceHolderWithAction resHolderWithAction;
        Map<String, BinaryResourceHolderWithAction> map = this.m_valueMap;
        synchronized (map) {
            resHolderWithAction = this.m_valueMap.get(key);
        }
        if (resHolderWithAction != null) {
            if (resHolderWithAction.getOpenUriAction() == OpenUriAction.DOWNLOAD) {
                this.scheduleRemoval(key, this.getRemovalTimeoutAfterFirstRequest());
            } else if (!this.containsDownloadInterceptor(resHolderWithAction.getHolder())) {
                BinaryResourceHolder holder = new BinaryResourceHolder(resHolderWithAction.getHolder().get());
                holder.addHttpResponseInterceptor((IHttpResponseInterceptor)new DownloadHttpResponseInterceptor(holder.get().getFilename()));
                this.put(key, holder, resHolderWithAction.getOpenUriAction());
            }
        }
        return resHolderWithAction;
    }

    protected boolean containsDownloadInterceptor(BinaryResourceHolder holder) {
        for (IHttpResponseInterceptor interceptor : holder.getHttpResponseInterceptors()) {
            if (!(interceptor instanceof DownloadHttpResponseInterceptor)) continue;
            return true;
        }
        return false;
    }

    public static class BinaryResourceHolderWithAction {
        private final BinaryResourceHolder m_holder;
        private final IOpenUriAction m_openUriAction;

        public BinaryResourceHolderWithAction(BinaryResourceHolder holder, IOpenUriAction openUriAction) {
            this.m_holder = holder;
            this.m_openUriAction = openUriAction;
        }

        public BinaryResourceHolder getHolder() {
            return this.m_holder;
        }

        public IOpenUriAction getOpenUriAction() {
            return this.m_openUriAction;
        }
    }
}

