/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.calendar;

import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarItem;
import org.eclipse.scout.rt.ui.html.json.IJsonObject;
import org.eclipse.scout.rt.ui.html.json.calendar.JsonRecurrencePattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonCalendarItem
implements IJsonObject {
    private final ICalendarItem m_item;

    public JsonCalendarItem(ICalendarItem item) {
        this.m_item = item;
    }

    public final ICalendarItem getItem() {
        return this.m_item;
    }

    public JSONObject toJson() {
        if (this.m_item == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        json.put("exists", this.m_item.exists());
        json.put("lastModified", this.m_item.getLastModified());
        json.put("itemId", this.m_item.getItemId());
        json.put("owner", (Object)this.m_item.getOwner());
        json.put("resourceId", (Object)this.m_item.getResourceId());
        json.put("subject", (Object)this.m_item.getSubject());
        json.put("description", (Object)this.m_item.getDescription());
        json.put("cssClass", (Object)this.m_item.getCssClass());
        json.put("recurrencePattern", (Object)new JsonRecurrencePattern(this.m_item.getRecurrencePattern()).toJson());
        json.put("subjectLabel", (Object)this.m_item.getSubjectLabel());
        json.put("subjectAppLink", (Object)this.m_item.getSubjectAppLink());
        json.put("subjectIconId", (Object)this.m_item.getSubjectIconId());
        if (CollectionUtility.hasElements((Collection)this.m_item.getDescriptionElements())) {
            json.put("descriptionElements", (Object)new JSONArray((Collection)this.m_item.getDescriptionElements().stream().map(element -> {
                JSONObject jsonElement = new JSONObject();
                jsonElement.put("text", (Object)element.getText());
                jsonElement.put("iconId", (Object)element.getIconId());
                jsonElement.put("appLink", (Object)element.getAppLink());
                return jsonElement;
            }).collect(Collectors.toList())));
        }
        return json;
    }
}

