/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.calendar;

import java.util.Date;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarComponent;
import org.eclipse.scout.rt.platform.util.Range;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.AbstractJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonDate;
import org.eclipse.scout.rt.ui.html.json.JsonDateRange;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonEventType;
import org.eclipse.scout.rt.ui.html.json.calendar.JsonCalendarItem;
import org.json.JSONObject;

public class JsonCalendarComponent<CALENDAR_COMPONENT extends CalendarComponent>
extends AbstractJsonAdapter<CALENDAR_COMPONENT> {
    public JsonCalendarComponent(CALENDAR_COMPONENT model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "CalendarComponent";
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        json.put("item", (Object)new JsonCalendarItem(((CalendarComponent)this.getModel()).getItem()).toJson());
        json.put("fromDate", (Object)new JsonDate(((CalendarComponent)this.getModel()).getFromDate()).asJsonString());
        json.put("toDate", (Object)new JsonDate(((CalendarComponent)this.getModel()).getToDate()).asJsonString());
        if (((CalendarComponent)this.getModel()).getCoveredDaysRange() != null) {
            Object coveredDaysRange = new JsonDateRange((Range<Date>)((CalendarComponent)this.getModel()).getCoveredDaysRange()).toJson();
            json.put("coveredDaysRange", coveredDaysRange);
        }
        json.put("fullDay", ((CalendarComponent)this.getModel()).isFullDay());
        json.put("draggable", ((CalendarComponent)this.getModel()).getProvider().isMoveItemEnabled());
        return json;
    }

    @Override
    public void handleUiEvent(JsonEvent event) {
        if (JsonEventType.APP_LINK_ACTION.matches(event.getType())) {
            this.handleUiAppLinkAction(event);
        } else {
            super.handleUiEvent(event);
        }
    }

    protected void handleUiAppLinkAction(JsonEvent event) {
        String ref = event.getData().optString("ref", null);
        ((CalendarComponent)this.getModel()).getCalendar().getUIFacade().fireAppLinkActionFromUI(ref);
    }
}

