/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.calendar;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.ui.action.menu.root.ICalendarContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarAdapter;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarComponent;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarEvent;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarListener;
import org.eclipse.scout.rt.client.ui.basic.calendar.ICalendar;
import org.eclipse.scout.rt.client.ui.basic.calendar.ICalendarUIFacade;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.ImmutablePair;
import org.eclipse.scout.rt.platform.util.Pair;
import org.eclipse.scout.rt.platform.util.Range;
import org.eclipse.scout.rt.shared.services.common.calendar.CalendarResourceDo;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.AbstractJsonWidget;
import org.eclipse.scout.rt.ui.html.json.FilteredJsonAdapterIds;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonDataObjectHelper;
import org.eclipse.scout.rt.ui.html.json.JsonDate;
import org.eclipse.scout.rt.ui.html.json.JsonDateRange;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.calendar.JsonCalendarComponent;
import org.eclipse.scout.rt.ui.html.json.calendar.JsonCalendarEvent;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterProperty;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterPropertyConfig;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterPropertyConfigBuilder;
import org.eclipse.scout.rt.ui.html.json.menu.IJsonContextMenuOwner;
import org.eclipse.scout.rt.ui.html.json.menu.JsonContextMenu;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonCalendar<CALENDAR extends ICalendar>
extends AbstractJsonWidget<CALENDAR>
implements IJsonContextMenuOwner {
    private static final Logger LOG = LoggerFactory.getLogger(JsonCalendar.class);
    public static final String EVENT_CALENDAR_CHANGED = "calendarChanged";
    public static final String EVENT_CALENDAR_CHANGED_BATCH = "calendarChangedBatch";
    private static final String EVENT_COMPONENT_ACTION = "componentAction";
    private static final String EVENT_COMPONENT_MOVE = "componentMove";
    private static final String EVENT_RELOAD = "reload";
    private static final String EVENT_SELECTION_CHANGE = "selectionChange";
    private static final String EVENT_VIEW_RANGE_CHANGE = "viewRangeChange";
    private static final String EVENT_SELECTED_RANGE_CHANGE = "selectedRangeChange";
    private static final String EVENT_MODEL_CHANGE = "modelChange";
    private static final String EVENT_RESOURCE_VISIBILITY_CHANGE = "resourceVisibilityChange";
    private static final String EVENT_SELECTED_RESOURCE_CHANGE = "selectedResourceChange";
    private final JsonDataObjectHelper m_jsonDoHelper = (JsonDataObjectHelper)BEANS.get(JsonDataObjectHelper.class);
    private CalendarListener m_calendarListener;
    private JsonContextMenu<IContextMenu> m_jsonContextMenu;

    public JsonCalendar(CALENDAR model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "Calendar";
    }

    protected JsonDataObjectHelper jsonDoHelper() {
        return this.m_jsonDoHelper;
    }

    @Override
    protected void attachModel() {
        super.attachModel();
        if (this.m_calendarListener != null) {
            throw new IllegalStateException();
        }
        this.m_calendarListener = new P_CalendarListener();
        ((ICalendar)this.getModel()).addCalendarListener(this.m_calendarListener);
    }

    @Override
    protected void detachModel() {
        super.detachModel();
        if (this.m_calendarListener == null) {
            throw new IllegalStateException();
        }
        ((ICalendar)this.getModel()).removeCalendarListener(this.m_calendarListener);
        this.m_calendarListener = null;
    }

    @Override
    protected void attachChildAdapters() {
        super.attachChildAdapters();
        this.attachAdapter(((ICalendar)this.getModel()).getSelectedComponent());
        this.attachAdapters(((ICalendar)this.getModel()).getComponents());
        this.m_jsonContextMenu = new JsonContextMenu<ICalendarContextMenu>(((ICalendar)this.getModel()).getContextMenu(), this);
        this.m_jsonContextMenu.init();
    }

    @Override
    protected void disposeChildAdapters() {
        this.m_jsonContextMenu.dispose();
        super.disposeChildAdapters();
    }

    @Override
    protected void initJsonProperties(CALENDAR model) {
        this.putJsonProperty(new JsonAdapterProperty<CALENDAR>("components", (ICalendar)model, this.getUiSession()){

            @Override
            protected Set<? extends CalendarComponent> modelValue() {
                return ((ICalendar)this.getModel()).getComponents();
            }
        });
        this.putJsonProperty(new JsonAdapterProperty<CALENDAR>("selectedComponent", (ICalendar)model, this.getUiSession()){

            protected CalendarComponent modelValue() {
                return ((ICalendar)this.getModel()).getSelectedComponent();
            }

            @Override
            protected JsonAdapterPropertyConfig createConfig() {
                return new JsonAdapterPropertyConfigBuilder().disposeOnChange(false).build();
            }
        });
        this.putJsonProperty(new JsonProperty<CALENDAR>("displayMode", (ICalendar)model){

            @Override
            protected Integer modelValue() {
                return ((ICalendar)this.getModel()).getDisplayMode();
            }
        });
        this.putJsonProperty(new JsonProperty<CALENDAR>("displayCondensed", (ICalendar)model){

            @Override
            protected Boolean modelValue() {
                return ((ICalendar)this.getModel()).isDisplayCondensed();
            }
        });
        this.putJsonProperty(new JsonProperty<CALENDAR>("title", (ICalendar)model){

            @Override
            protected String modelValue() {
                return ((ICalendar)this.getModel()).getTitle();
            }
        });
        this.putJsonProperty(new JsonProperty<CALENDAR>("resources", (ICalendar)model){

            @Override
            protected List<CalendarResourceDo> modelValue() {
                return ((ICalendar)this.getModel()).getResources();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return JsonCalendar.this.resourcesToJson((List)value);
            }
        });
        this.putJsonProperty(new JsonProperty<CALENDAR>("viewRange", (ICalendar)model){

            protected Range<Date> modelValue() {
                return ((ICalendar)this.getModel()).getViewRange();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                if (value == null) {
                    return null;
                }
                return new JsonDateRange((Range<Date>)((Range)value)).toJson();
            }
        });
        this.putJsonProperty(new JsonProperty<CALENDAR>("selectedDate", (ICalendar)model){

            @Override
            protected Date modelValue() {
                return ((ICalendar)this.getModel()).getSelectedDate();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return new JsonDate((Date)value).asJsonString();
            }
        });
        this.putJsonProperty(new JsonProperty<CALENDAR>("selectedRange", (ICalendar)model){

            protected Range<Date> modelValue() {
                return ((ICalendar)this.getModel()).getSelectedRange();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                if (value == null) {
                    return null;
                }
                return new JsonDateRange((Range<Date>)((Range)value)).toJson();
            }
        });
        this.putJsonProperty(new JsonProperty<CALENDAR>("loadInProgress", (ICalendar)model){

            @Override
            protected Boolean modelValue() {
                return ((ICalendar)this.getModel()).isLoadInProgress();
            }
        });
        this.putJsonProperty(new JsonProperty<CALENDAR>("startHour", (ICalendar)model){

            @Override
            protected Integer modelValue() {
                return ((ICalendar)this.getModel()).getStartHour();
            }
        });
        this.putJsonProperty(new JsonProperty<CALENDAR>("useOverflowCells", (ICalendar)model){

            @Override
            protected Boolean modelValue() {
                return ((ICalendar)this.getModel()).getUseOverflowCells();
            }
        });
        this.putJsonProperty(new JsonProperty<CALENDAR>("showDisplayModeSelection", (ICalendar)model){

            @Override
            protected Boolean modelValue() {
                return ((ICalendar)this.getModel()).getShowDisplayModeSelection();
            }
        });
        this.putJsonProperty(new JsonProperty<CALENDAR>("rangeSelectionAllowed", (ICalendar)model){

            @Override
            protected Boolean modelValue() {
                return ((ICalendar)this.getModel()).getRangeSelectionAllowed();
            }
        });
        this.putJsonProperty(new JsonProperty<CALENDAR>("menuInjectionTarget", (ICalendar)model){

            @Override
            protected String modelValue() {
                return JsonCalendar.this.getUiSession().getJsonAdapters(((ICalendar)this.getModel()).getMenuInjectionTarget()).stream().findAny().map(IJsonAdapter::getId).orElse(null);
            }
        });
        this.putJsonProperty(new JsonProperty<CALENDAR>("showCalendarSidebar", (ICalendar)model){

            @Override
            protected Boolean modelValue() {
                return ((ICalendar)this.getModel()).getShowCalendarSidebar();
            }
        });
        this.putJsonProperty(new JsonProperty<CALENDAR>("showResourcePanel", (ICalendar)model){

            @Override
            protected Boolean modelValue() {
                return ((ICalendar)this.getModel()).getShowResourcePanel();
            }
        });
        this.putJsonProperty(new JsonProperty<CALENDAR>("showListPanel", (ICalendar)model){

            @Override
            protected Boolean modelValue() {
                return ((ICalendar)this.getModel()).getShowListPanel();
            }
        });
    }

    public <C extends CalendarComponent> JsonCalendarComponent<C> resolveCalendarComponent(String adapterId) {
        if (adapterId == null) {
            return null;
        }
        return (JsonCalendarComponent)this.getUiSession().getJsonAdapter(adapterId);
    }

    protected JSONArray resourcesToJson(List<CalendarResourceDo> resources) {
        return this.jsonDoHelper().dataObjectsToJson(resources);
    }

    @Override
    protected void handleUiPropertyChange(String propertyName, JSONObject data) {
        if ("showCalendarSidebar".equals(propertyName)) {
            ((ICalendar)this.getModel()).getUIFacade().setShowYearPanelFromUI(data.getBoolean(propertyName));
        } else if ("showResourcePanel".equals(propertyName)) {
            ((ICalendar)this.getModel()).getUIFacade().setShowResourcePanelFromUI(data.getBoolean(propertyName));
        } else if ("showListPanel".equals(propertyName)) {
            ((ICalendar)this.getModel()).getUIFacade().setShowListPanelFromUI(data.getBoolean(propertyName));
        } else {
            super.handleUiPropertyChange(propertyName, data);
        }
    }

    @Override
    public void handleUiEvent(JsonEvent event) {
        if (EVENT_COMPONENT_ACTION.equals(event.getType())) {
            this.handleUiComponentAction(event);
        } else if (EVENT_COMPONENT_MOVE.equals(event.getType())) {
            this.handleUiComponentMove(event);
        } else if (EVENT_RELOAD.equals(event.getType())) {
            this.handleUiReload(event);
        } else if (EVENT_SELECTION_CHANGE.equals(event.getType())) {
            this.handleUiSelectionChange(event);
        } else if (EVENT_MODEL_CHANGE.equals(event.getType())) {
            this.handleUiModelChange(event);
        } else if (EVENT_VIEW_RANGE_CHANGE.equals(event.getType())) {
            this.handleUiViewRangeChange(event);
        } else if (EVENT_SELECTED_RANGE_CHANGE.equals(event.getType())) {
            this.handleUiSelectedRangeChange(event);
        } else if (EVENT_RESOURCE_VISIBILITY_CHANGE.equals(event.getType())) {
            this.handleUiResourceVisibilityChange(event);
        } else if (EVENT_SELECTED_RESOURCE_CHANGE.equals(event.getType())) {
            this.handleUiSelectedResourceChange(event);
        } else {
            super.handleUiEvent(event);
        }
    }

    protected void handleUiComponentAction(JsonEvent event) {
        ((ICalendar)this.getModel()).getUIFacade().fireComponentActionFromUI();
    }

    protected void handleUiComponentMove(JsonEvent event) {
        JSONObject data = event.getData();
        Date fromDate = this.toJavaDate(data, "fromDate");
        Date toDate = this.toJavaDate(data, "toDate");
        String componentId = data.optString("componentId", null);
        JsonCalendarComponent component = this.resolveCalendarComponent(componentId);
        if (component != null) {
            ((ICalendar)this.getModel()).getUIFacade().fireComponentMoveFromUI((CalendarComponent)component.getModel(), fromDate, toDate);
        } else if (componentId != null) {
            LOG.info("Unkown component with ID {} [event='{}']", (Object)componentId, (Object)EVENT_COMPONENT_MOVE);
        }
    }

    protected void handleUiReload(JsonEvent event) {
        ((ICalendar)this.getModel()).getUIFacade().fireReloadFromUI();
    }

    protected void handleUiSelectionChange(JsonEvent event) {
        JSONObject data = event.getData();
        Date selectedDate = this.toJavaDate(data, "date");
        String componentId = data.optString("componentId", null);
        CalendarComponent selectedComponent = null;
        JsonCalendarComponent jsonComponent = this.resolveCalendarComponent(componentId);
        if (jsonComponent != null) {
            selectedComponent = (CalendarComponent)jsonComponent.getModel();
            this.addPropertyEventFilterCondition("selectedComponent", selectedComponent);
        } else if (componentId != null) {
            LOG.info("Unkown component with ID {} [event='{}']", (Object)componentId, (Object)EVENT_SELECTION_CHANGE);
        }
        this.addPropertyEventFilterCondition("selectedDate", selectedDate);
        ((ICalendar)this.getModel()).getUIFacade().setSelectionFromUI(selectedDate, selectedComponent);
        LOG.debug("date={} componentId={}", (Object)selectedDate, (Object)componentId);
    }

    protected void handleUiModelChange(JsonEvent event) {
        JSONObject data = event.getData();
        int displayMode = data.optInt("displayMode");
        this.addPropertyEventFilterCondition("displayMode", displayMode);
        ICalendarUIFacade uiFacade = ((ICalendar)this.getModel()).getUIFacade();
        uiFacade.setDisplayModeFromUI(displayMode);
        Range<Date> viewRange = this.extractViewRange(data);
        this.addPropertyEventFilterCondition("viewRange", viewRange);
        uiFacade.setViewRangeFromUI(viewRange);
        Date selectedDate = this.extractSelectedDate(data);
        this.addPropertyEventFilterCondition("selectedDate", selectedDate);
        uiFacade.setSelectedDateFromUI(selectedDate);
        Range<Date> selectedRange = this.extractSelectedRange(data);
        this.addPropertyEventFilterCondition("selectedRange", selectedRange);
        uiFacade.setSelectedRangeFromUI(selectedRange);
        LOG.debug("displayMode={} viewRange={} selectedDate={} selectedRange={}", new Object[]{displayMode, viewRange, selectedDate, selectedRange});
    }

    protected void handleUiViewRangeChange(JsonEvent event) {
        Range<Date> viewRange = this.extractViewRange(event.getData());
        this.addPropertyEventFilterCondition("viewRange", viewRange);
        ((ICalendar)this.getModel()).getUIFacade().setViewRangeFromUI(viewRange);
        LOG.debug("viewRange={}", viewRange);
    }

    protected Range<Date> extractViewRange(JSONObject data) {
        JSONObject viewRange = data.optJSONObject("viewRange");
        Date fromDate = this.toJavaDate(viewRange, "from");
        Date toDate = this.toJavaDate(viewRange, "to");
        return new Range((Object)fromDate, (Object)toDate);
    }

    protected Date extractSelectedDate(JSONObject data) {
        return this.toJavaDate(data, "selectedDate");
    }

    protected void handleUiSelectedRangeChange(JsonEvent event) {
        Range<Date> selectedRange = this.extractSelectedRange(event.getData());
        this.addPropertyEventFilterCondition("selectedRange", selectedRange);
        ((ICalendar)this.getModel()).getUIFacade().setSelectedRangeFromUI(selectedRange);
        LOG.debug("selectedRange={}", selectedRange);
    }

    protected Range<Date> extractSelectedRange(JSONObject data) {
        JSONObject selectedRange = data.optJSONObject("selectedRange");
        Date fromDate = this.toJavaDate(selectedRange, "from");
        Date toDate = this.toJavaDate(selectedRange, "to");
        return new Range((Object)fromDate, (Object)toDate);
    }

    protected Date toJavaDate(JSONObject data, String propertyName) {
        if (data == null || propertyName == null) {
            return null;
        }
        return new JsonDate(data.optString(propertyName, null)).asJavaDate();
    }

    protected void handleUiResourceVisibilityChange(JsonEvent event) {
        Pair<String, Boolean> resourceVisibility = this.extractResourceVisibility(event.getData());
        ((ICalendar)this.getModel()).getUIFacade().setResourceVisibilityFromUI((String)resourceVisibility.getLeft(), (Boolean)resourceVisibility.getRight());
        LOG.debug("resourceId={} visible={}", resourceVisibility.getLeft(), resourceVisibility.getRight());
    }

    protected void handleUiSelectedResourceChange(JsonEvent event) {
        String resourceId = event.getData().optString("resourceId");
        ((ICalendar)this.getModel()).getUIFacade().setSelectedResourceFromUI(resourceId);
        LOG.debug("resourceId={}", (Object)resourceId);
    }

    protected Pair<String, Boolean> extractResourceVisibility(JSONObject data) {
        String resourcesId = data.optString("resourceId");
        Boolean visible = data.optBoolean("visible");
        return new ImmutablePair((Object)resourcesId, (Object)visible);
    }

    @Override
    public void handleModelContextMenuChanged(FilteredJsonAdapterIds<?> filteredAdapters) {
        this.addPropertyChangeEvent("menus", filteredAdapters);
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        json.put("menus", (Object)this.m_jsonContextMenu.childActionsToJson());
        return json;
    }

    protected class P_CalendarListener
    extends CalendarAdapter {
        protected P_CalendarListener() {
        }

        public void calendarChanged(CalendarEvent e) {
            ModelJobs.assertModelThread();
            JsonCalendar.this.addActionEvent(JsonCalendar.EVENT_CALENDAR_CHANGED, new JsonCalendarEvent(JsonCalendar.this, e).toJson());
        }

        public void calendarChangedBatch(List<CalendarEvent> batch) {
            ModelJobs.assertModelThread();
            JSONArray jsonArray = new JSONArray();
            for (CalendarEvent event : batch) {
                jsonArray.put((Object)new JsonCalendarEvent(JsonCalendar.this, event).toJson());
            }
            JSONObject json = new JSONObject();
            json.put("batch", (Object)jsonArray);
            JsonCalendar.this.addActionEvent(JsonCalendar.EVENT_CALENDAR_CHANGED_BATCH, json);
        }
    }
}

