/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.basic.planner;

import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.planner.Activity;
import org.eclipse.scout.rt.client.ui.basic.planner.Resource;
import org.eclipse.scout.rt.ui.html.json.IIdProvider;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.IJsonObject;
import org.eclipse.scout.rt.ui.html.json.JsonObjectUtility;
import org.eclipse.scout.rt.ui.html.json.basic.cell.JsonCell;
import org.eclipse.scout.rt.ui.html.json.basic.planner.JsonActivity;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonResource
implements IJsonObject {
    private final Resource<?> m_resource;
    private final IIdProvider<Resource<?>> m_resourceIdProvider;
    private final IIdProvider<Activity<?, ?>> m_cellIdProvider;
    private final IJsonAdapter<?> m_parentAdapter;

    public JsonResource(Resource<?> resource, IJsonAdapter<?> parentAdapter, IIdProvider<Resource<?>> resourceIdProvider, IIdProvider<Activity<?, ?>> cellIdProvider) {
        this.m_resource = resource;
        this.m_parentAdapter = parentAdapter;
        this.m_resourceIdProvider = resourceIdProvider;
        this.m_cellIdProvider = cellIdProvider;
    }

    @Override
    public Object toJson() {
        JSONObject jsonRow = new JSONObject();
        jsonRow.put("id", (Object)this.m_resourceIdProvider.getId(this.m_resource));
        jsonRow.put("resourceCell", (Object)new JsonCell((ICell)this.m_resource.getCell(), this.m_parentAdapter).toJson());
        jsonRow.put("activities", (Object)this.cellsToJson());
        JsonObjectUtility.filterDefaultValues(jsonRow, "Resource");
        return jsonRow;
    }

    protected JSONArray cellsToJson() {
        JSONArray jsonCells = new JSONArray();
        for (Activity cell : this.m_resource.getActivities()) {
            JsonActivity jsonCell = new JsonActivity(cell, this.m_cellIdProvider);
            jsonCells.put((Object)jsonCell.toJson());
        }
        return jsonCells;
    }
}

