/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.basic.filechooser;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.ui.basic.filechooser.FileChooserEvent;
import org.eclipse.scout.rt.client.ui.basic.filechooser.FileChooserListener;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooser;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.AbstractJsonWidget;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.basic.filechooser.JsonFileChooserAcceptAttributeBuilder;
import org.eclipse.scout.rt.ui.html.res.IBinaryResourceConsumer;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonFileChooser<FILE_CHOOSER extends IFileChooser>
extends AbstractJsonWidget<FILE_CHOOSER>
implements IBinaryResourceConsumer {
    private static final String EVENT_CANCEL = "cancel";
    private FileChooserListener m_fileChooserListener;

    public JsonFileChooser(FILE_CHOOSER model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "FileChooser";
    }

    @Override
    protected void attachModel() {
        super.attachModel();
        if (this.m_fileChooserListener != null) {
            throw new IllegalStateException();
        }
        this.m_fileChooserListener = new P_FileChooserListener();
        ((IFileChooser)this.getModel()).addFileChooserListener(this.m_fileChooserListener);
    }

    @Override
    protected void detachModel() {
        super.detachModel();
        if (this.m_fileChooserListener == null) {
            throw new IllegalStateException();
        }
        ((IFileChooser)this.getModel()).removeFileChooserListener(this.m_fileChooserListener);
        this.m_fileChooserListener = null;
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        this.putProperty(json, "multiSelect", ((IFileChooser)this.getModel()).isMultiSelect());
        this.putProperty(json, "acceptTypes", new JSONArray(this.collectAcceptTypes()));
        this.putProperty(json, "maximumUploadSize", ((IFileChooser)this.getModel()).getMaximumUploadSize());
        return json;
    }

    protected Set<String> collectAcceptTypes() {
        return ((JsonFileChooserAcceptAttributeBuilder)BEANS.get(JsonFileChooserAcceptAttributeBuilder.class)).withTypes(((IFileChooser)this.getModel()).getFileExtensions()).build();
    }

    protected void handleModelFileChooserEvent(FileChooserEvent event) {
        switch (event.getType()) {
            case 900: {
                this.handleModelClosed();
            }
        }
    }

    protected void handleModelClosed() {
        this.dispose();
        this.getUiSession().sendDisposeAdapterEvent(this);
    }

    @Override
    public void handleUiEvent(JsonEvent event) {
        if (EVENT_CANCEL.equals(event.getType())) {
            this.handleUiCancel(event);
        } else {
            super.handleUiEvent(event);
        }
    }

    protected void handleUiCancel(JsonEvent event) {
        ((IFileChooser)this.getModel()).getUIFacade().setResultFromUI(null);
    }

    @Override
    public Collection<String> getAcceptedUploadFileExtensions() {
        return ((IFileChooser)this.getModel()).getFileExtensions();
    }

    @Override
    public void consumeBinaryResource(List<BinaryResource> binaryResources, Map<String, String> uploadProperties) {
        ((IFileChooser)this.getModel()).getUIFacade().setResultFromUI(binaryResources);
    }

    @Override
    public long getMaximumUploadSize() {
        return ((IFileChooser)this.getModel()).getMaximumUploadSize();
    }

    protected class P_FileChooserListener
    implements FileChooserListener {
        protected P_FileChooserListener() {
        }

        public void fileChooserChanged(FileChooserEvent e) {
            ModelJobs.assertModelThread();
            JsonFileChooser.this.handleModelFileChooserEvent(e);
        }
    }
}

