/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.context.RunContexts;
import org.eclipse.scout.rt.platform.exception.DefaultExceptionTranslator;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.resource.BinaryResources;
import org.eclipse.scout.rt.platform.resource.MimeTypes;
import org.eclipse.scout.rt.platform.security.MalwareScanner;
import org.eclipse.scout.rt.platform.security.RejectedResourceException;
import org.eclipse.scout.rt.platform.util.FileUtility;
import org.eclipse.scout.rt.platform.util.HexUtility;
import org.eclipse.scout.rt.platform.util.IOUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.server.commons.servlet.cache.HttpCacheControl;
import org.eclipse.scout.rt.ui.html.AbstractUiServletRequestHandler;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.UiHtmlConfigProperties;
import org.eclipse.scout.rt.ui.html.UiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonRequestHelper;
import org.eclipse.scout.rt.ui.html.logging.IUiRunContextDiagnostics;
import org.eclipse.scout.rt.ui.html.res.IUploadable;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Order(value=4520.0)
public class UploadRequestHandler
extends AbstractUiServletRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(UploadRequestHandler.class);
    private static final String EMPTY_UPLOAD_FILENAME = "*empty*";
    public static final Pattern PATTERN_UPLOAD_ADAPTER_RESOURCE_PATH = Pattern.compile("^/upload/([^/]*)/([^/]*)$");
    public static final Set<String> DEFAULT_VALID_FILE_EXTENSIONS = Stream.of("avi", "bmp", "docx", "dotx", "gif", "html", "jpg", "jpeg", "log", "m2v", "mkv", "mov", "mp3", "mp4", "mpg", "m4p", "oga", "ogv", "pdf", "png", "potx", "ppsx", "pptx", "sldx", "svg", "thmx", "tif", "tiff", "txt", "vcard", "vcf", "vcs", "xlsx", "xltx").collect(Collectors.toSet());
    private final HttpCacheControl m_httpCacheControl = (HttpCacheControl)BEANS.get(HttpCacheControl.class);
    private final JsonRequestHelper m_jsonRequestHelper = (JsonRequestHelper)BEANS.get(JsonRequestHelper.class);

    @Override
    public boolean handlePost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String pathInfo = req.getPathInfo();
        Matcher matcher = PATTERN_UPLOAD_ADAPTER_RESOURCE_PATH.matcher(pathInfo);
        if (!matcher.matches()) {
            return false;
        }
        String uiSessionId = matcher.group(1);
        String targetAdapterId = matcher.group(2);
        if (!this.isMultipartContent(req)) {
            return false;
        }
        long startNanos = System.nanoTime();
        if (LOG.isDebugEnabled()) {
            LOG.debug("File upload started");
        }
        this.m_httpCacheControl.checkAndSetCacheHeaders(req, resp, null);
        try {
            try {
                IUiSession uiSession = UiSession.get(req, uiSessionId);
                if (uiSession == null) {
                    throw new IllegalStateException("Could not resolve UI session with ID " + uiSessionId);
                }
                uiSession.touch();
                RunContexts.copyCurrent().withThreadLocal(IUiSession.CURRENT, (Object)uiSession).withDiagnostics((Collection)BEANS.all(IUiRunContextDiagnostics.class)).run(() -> this.handleUploadFileRequest(IUiSession.CURRENT.get(), req, resp, targetAdapterId), DefaultExceptionTranslator.class);
            }
            catch (Exception e) {
                LOG.error("Unexpected error while handling multipart upload request", (Throwable)e);
                this.writeJsonResponse((ServletResponse)resp, this.m_jsonRequestHelper.createUnrecoverableFailureResponse());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("File upload completed in {} ms", (Object)StringUtility.formatNanos((long)(System.nanoTime() - startNanos)));
                }
            }
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("File upload completed in {} ms", (Object)StringUtility.formatNanos((long)(System.nanoTime() - startNanos)));
            }
        }
        return true;
    }

    protected boolean isMultipartContent(HttpServletRequest request) {
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase(Locale.ENGLISH).startsWith("multipart/");
    }

    /*
     * Exception decompiling
     */
    protected void handleUploadFileRequest(IUiSession uiSession, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String targetAdapterId) throws IOException, ServletException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Long getAckSequenceNo(HttpServletRequest req) {
        String ackSeqNoStr = req.getHeader("X-Scout-#ACK");
        if (ackSeqNoStr != null) {
            try {
                return Long.valueOf(ackSeqNoStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    protected void readUploadData(HttpServletRequest httpReq, IUploadable uploadable, Map<String, String> uploadProperties, List<BinaryResource> uploadResources) throws IOException, ServletException {
        Set<String> validFileExtensions = this.getValidFileExtensionsFor(uploadable, uploadProperties);
        long maxFileCount = (Long)CONFIG.getPropertyValue(UiHtmlConfigProperties.MaxUploadFileCountProperty.class);
        int fileCount = 0;
        for (Part part : httpReq.getParts()) {
            byte[] content;
            if (maxFileCount > 0L && (long)(++fileCount - 1) > maxFileCount) {
                throw new RejectedResourceException("Too many files ({}).", new Object[]{fileCount});
            }
            String filename = part.getSubmittedFileName();
            if (StringUtility.hasText((CharSequence)filename)) {
                String[] parts = StringUtility.split((String)filename, (String)"[/\\\\]");
                filename = parts[parts.length - 1];
            }
            if (EMPTY_UPLOAD_FILENAME.equals(filename)) {
                filename = null;
            }
            if (StringUtility.hasText((CharSequence)filename)) {
                String ext = FileUtility.getFileExtension((String)filename);
                if (ext != null) {
                    ext = ext.toLowerCase(Locale.ROOT);
                }
                this.verifyFileName(validFileExtensions, filename, ext);
            }
            this.verifyMaximumUploadSize(uploadable, part);
            Throwable throwable = null;
            Object var14_14 = null;
            try (InputStream in = part.getInputStream();){
                content = IOUtility.readBytes((InputStream)in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            BinaryResource res = BinaryResources.create().withFilename(filename).withContentType(this.detectContentType(filename, part, content)).withContent(content).build();
            this.verifyFileSafety(res);
            this.verifyFileIntegrity(res);
            if (StringUtility.isNullOrEmpty((CharSequence)part.getSubmittedFileName())) {
                String name = part.getName();
                uploadProperties.put(name, new String(content, StandardCharsets.UTF_8));
                continue;
            }
            uploadResources.add(res);
        }
    }

    protected String detectContentType(String filename, Part part, byte[] content) {
        if (filename != null) {
            return null;
        }
        return part.getContentType();
    }

    protected Set<String> getValidFileExtensionsFor(IUploadable uploadable, Map<String, String> uploadProperties) {
        Set<String> extSet = this.toExtensionsLowercase(uploadable.getAcceptedUploadFileExtensions());
        if (extSet.isEmpty()) {
            return this.getValidFileExtensionsDefault();
        }
        return extSet;
    }

    protected Set<String> toExtensionsLowercase(Collection<String> extOrMediaList) {
        if (extOrMediaList == null) {
            return Collections.emptySet();
        }
        HashSet<String> extSet = new HashSet<String>();
        for (String extOrMedia : extOrMediaList) {
            if (extOrMedia != null && extOrMedia.indexOf(47) < 0) {
                extSet.add(extOrMedia);
                continue;
            }
            MimeTypes.findByMimeTypeName((String)extOrMedia).forEach(t -> {
                boolean bl = extSet.add(t.getFileExtension());
            });
        }
        return extSet;
    }

    protected Set<String> getValidFileExtensionsDefault() {
        return DEFAULT_VALID_FILE_EXTENSIONS;
    }

    protected IUploadable resolveJsonAdapter(IUiSession uiSession, String targetAdapterId) {
        if (!StringUtility.hasText((CharSequence)targetAdapterId)) {
            throw new IllegalArgumentException("Missing target adapter ID");
        }
        IJsonAdapter<?> jsonAdapter = uiSession.getJsonAdapter(targetAdapterId);
        if (jsonAdapter == null) {
            return null;
        }
        if (jsonAdapter instanceof IUploadable) {
            return (IUploadable)((Object)jsonAdapter);
        }
        throw new IllegalStateException("Invalid adapter for ID " + targetAdapterId + " (unexpected type: " + jsonAdapter.getClass().getName() + ")");
    }

    protected void writeJsonResponse(ServletResponse servletResponse, JSONObject jsonObject) throws IOException {
        this.m_jsonRequestHelper.writeResponse(servletResponse, jsonObject);
    }

    protected void verifyFileName(Set<String> validFileExtensions, String filename, String ext) {
        if (!(validFileExtensions.isEmpty() || validFileExtensions.contains("*") || validFileExtensions.contains(ext))) {
            throw new RejectedResourceException("Filename '{}' has no accepted extension.", new Object[]{filename});
        }
    }

    protected void verifyMaximumUploadSize(IUploadable uploadable, Part part) {
        if (part.getSize() > uploadable.getMaximumUploadSize()) {
            throw new RejectedResourceException("The field {} exceeds its maximum permitted size of {} bytes.", new Object[]{part.getName(), uploadable.getMaximumUploadSize()});
        }
    }

    protected void verifyFileSafety(BinaryResource res) {
        ((MalwareScanner)BEANS.get(MalwareScanner.class)).scan(res);
    }

    protected void verifyFileIntegrity(BinaryResource res) {
        if (!MimeTypes.verifyMagic((BinaryResource)res)) {
            byte[] content = res.getContent();
            String header = content == null || content.length == 0 ? "" : HexUtility.encode((byte[])Arrays.copyOfRange(content, 0, Math.min(8, content.length)));
            String message = "File '{}' has content header '{}' which does not match its extension.";
            LOG.info(message, (Object)res.getFilename(), (Object)header);
            throw new RejectedResourceException(message, new Object[]{res.getFilename(), header});
        }
    }
}

