/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.server.commons.authentication.ServletFilterHelper;
import org.eclipse.scout.rt.ui.html.AbstractUiServletRequestHandler;
import org.eclipse.scout.rt.ui.html.HttpSessionHelper;
import org.eclipse.scout.rt.ui.html.ISessionStore;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Order(value=5500.0)
public class UnloadRequestHandler
extends AbstractUiServletRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(UnloadRequestHandler.class);

    @Override
    public boolean handlePost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String pathInfo = req.getPathInfo();
        Matcher matcher = ServletFilterHelper.UNLOAD_PATH_PATTERN.matcher(pathInfo);
        if (!matcher.matches()) {
            return false;
        }
        String uiSessionId = matcher.group(1);
        this.handleUnloadRequest(req, resp, uiSessionId);
        return true;
    }

    protected void handleUnloadRequest(HttpServletRequest req, HttpServletResponse resp, String uiSessionId) {
        LOG.info("Unloading UI session with ID {} (requested by UI)", (Object)uiSessionId);
        HttpSession httpSession = req.getSession(false);
        if (httpSession == null) {
            LOG.info("Unloading UI session with ID {} skipped (no existing http session).", (Object)uiSessionId);
            return;
        }
        ISessionStore sessionStore = ((HttpSessionHelper)BEANS.get(HttpSessionHelper.class)).optSessionStore(httpSession);
        if (sessionStore == null) {
            LOG.info("Unloading UI session with ID {} skipped (no existing http session store).", (Object)uiSessionId);
            return;
        }
        IUiSession uiSession = sessionStore.getUiSession(uiSessionId);
        if (uiSession == null) {
            LOG.info("Unloading UI session with ID {} skipped (no existing ui session).", (Object)uiSessionId);
            return;
        }
        ReentrantLock uiSessionLock = uiSession.uiSessionLock();
        uiSessionLock.lock();
        try {
            uiSession.dispose();
        }
        finally {
            uiSessionLock.unlock();
        }
    }
}

